/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.log;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import us.ihmc.codecs.demuxer.MP4VideoDemuxer;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.log.TimestampScrubber;
import us.ihmc.scs2.session.log.VideoConverter;

public class BlackMagicScrubber {
    private final TimestampScrubber timestampScrubber;
    private final String name;
    private final MP4VideoDemuxer demuxer;
    private final File videoFile;
    private final Camera camera;
    private long videoTimestamp;
    private long currentRobotTimestamp;

    public BlackMagicScrubber(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        this.camera = camera;
        this.name = camera.getNameAsString();
        boolean interlaced = camera.getInterlaced();
        if (!hasTimeBase) {
            System.err.println("Video data is using timestamps instead of frame numbers. Falling back to seeking based on timestamp.");
        }
        this.videoFile = new File(dataDirectory, camera.getVideoFileAsString());
        if (!this.videoFile.exists()) {
            throw new IOException("Cannot find video: " + String.valueOf(this.videoFile));
        }
        this.demuxer = new MP4VideoDemuxer(this.videoFile);
        File timestampFile = new File(dataDirectory, camera.getTimestampFileAsString());
        this.timestampScrubber = new TimestampScrubber(timestampFile, hasTimeBase, interlaced);
    }

    public YUVPicture readVideoFrame(long queryRobotTimestamp) throws IOException {
        this.videoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(queryRobotTimestamp);
        this.currentRobotTimestamp = this.timestampScrubber.getCurrentRobotTimestamp();
        this.demuxer.seekToPTS(this.videoTimestamp);
        return this.demuxer.getNextFrame();
    }

    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer monitor) throws IOException {
        long startVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(startTimestamp);
        long endVideoTimestamp = this.timestampScrubber.getVideoTimestampFromRobotTimestamp(endTimestamp);
        int framerate = VideoConverter.cropBlackMagicVideo(this.videoFile, outputFile, startVideoTimestamp, endVideoTimestamp, monitor);
        PrintWriter timestampWriter = new PrintWriter(timestampFile);
        timestampWriter.println(1);
        timestampWriter.println(framerate);
        long pts = 0L;
        for (int i = 0; i < this.timestampScrubber.getRobotTimestampsLength(); ++i) {
            long robotTimestamp = this.timestampScrubber.getRobotTimestampAtIndex(i);
            if (robotTimestamp >= startTimestamp && robotTimestamp <= endTimestamp) {
                timestampWriter.print(robotTimestamp);
                timestampWriter.print(" ");
                timestampWriter.println(pts);
                ++pts;
                continue;
            }
            if (robotTimestamp > endTimestamp) break;
        }
        timestampWriter.close();
    }

    public MP4VideoDemuxer getDemuxer() {
        return this.demuxer;
    }

    public long getVideoTimestamp() {
        return this.videoTimestamp;
    }

    public long getCurrentRobotTimestamp() {
        return this.currentRobotTimestamp;
    }

    public String getName() {
        return this.name;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public int getCurrentIndex() {
        return this.timestampScrubber.getCurrentIndex();
    }

    public boolean replacedRobotTimestampsContainsIndex(int index) {
        return this.timestampScrubber.getReplacedRobotTimestampIndex(index);
    }
}

