/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.List;
import java.util.Objects;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.MutableAttachmentIndex;
import us.ihmc.scs2.session.mcap.specs.records.MutableChunkIndex;
import us.ihmc.scs2.session.mcap.specs.records.MutableMetadataIndex;
import us.ihmc.scs2.session.mcap.specs.records.MutableRecord;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.RecordDataInputBacked;
import us.ihmc.scs2.session.mcap.specs.records.Records;

public interface Record
extends MCAPElement {
    public static final int RECORD_HEADER_LENGTH = 9;

    public static Record load(MCAPDataInput dataInput) {
        return Record.load(dataInput, dataInput.position());
    }

    public static Record load(MCAPDataInput dataInput, long elementPosition) {
        return new RecordDataInputBacked(dataInput, elementPosition);
    }

    public Opcode op();

    public long bodyLength();

    public <T> T body();

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-op = " + String.valueOf((Object)this.op());
        Object body = this.body();
        out = out + "\n\t-body = " + (String)(body == null ? "null" : "\n" + ((MCAPElement)body).toString(indent + 2));
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        this.write(dataOutput, true);
    }

    public void write(MCAPDataOutput var1, boolean var2);

    default public Record generateMetadataIndexRecord(long metadataOffset) {
        if (this.op() != Opcode.METADATA) {
            throw new UnsupportedOperationException("Cannot generate a metadata index record from a non-metadata record");
        }
        MutableMetadataIndex metadataIndex = new MutableMetadataIndex();
        metadataIndex.setMetadataOffset(metadataOffset);
        metadataIndex.setMetadata(this);
        return new MutableRecord(metadataIndex);
    }

    default public Record generateAttachmentIndexRecord(long attachmentOffset) {
        if (this.op() != Opcode.ATTACHMENT) {
            throw new UnsupportedOperationException("Cannot generate an attachment index record from a non-attachment record");
        }
        MutableAttachmentIndex attachmentIndex = new MutableAttachmentIndex();
        attachmentIndex.setAttachmentOffset(attachmentOffset);
        attachmentIndex.setAttachment(this);
        return new MutableRecord(attachmentIndex);
    }

    default public Record generateChunkIndexRecord(long chunkOffset, List<? extends Record> messageIndexRecordList) {
        if (this.op() != Opcode.CHUNK) {
            throw new UnsupportedOperationException("Cannot generate a chunk index record from a non-chunk record");
        }
        MutableChunkIndex chunkIndex = new MutableChunkIndex();
        chunkIndex.setChunkOffset(chunkOffset);
        chunkIndex.setChunk(this);
        chunkIndex.setMessageIndexOffsets(Records.generateMessageIndexOffsets(chunkOffset + this.getElementLength(), messageIndexRecordList));
        chunkIndex.setMessageIndexLength(messageIndexRecordList.stream().mapToLong(MCAPElement::getElementLength).sum());
        return new MutableRecord(chunkIndex);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Record) {
            Record other = (Record)mcapElement;
            if (this.op() != other.op()) {
                return false;
            }
            return Objects.equals(this.body(), other.body());
        }
        return false;
    }
}

