/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.output;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;

public class MCAPByteBufferDataOutput
implements MCAPDataOutput {
    private static final int DEFAULT_INITIAL_CAPACITY = 8192;
    private static final int DEFAULT_GROWTH_FACTOR = 2;
    private static final boolean DEFAULT_DIRECT_BUFFER = false;
    private ByteBuffer buffer;
    private final int growthFactor;
    private final boolean directBuffer;

    public MCAPByteBufferDataOutput() {
        this(8192, 2, false);
    }

    public MCAPByteBufferDataOutput(int initialCapacity, int growthFactor, boolean directBuffer) {
        this.growthFactor = growthFactor;
        this.directBuffer = directBuffer;
        this.buffer = this.newBuffer(initialCapacity);
    }

    private ByteBuffer newBuffer(int capacity) {
        ByteBuffer newBuffer = this.directBuffer ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        newBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return newBuffer;
    }

    @Override
    public long position() {
        return this.buffer.position();
    }

    @Override
    public void putLong(long value) {
        this.ensureCapacity(8);
        this.buffer.putLong(value);
    }

    @Override
    public void putInt(int value) {
        this.ensureCapacity(4);
        this.buffer.putInt(value);
    }

    @Override
    public void putShort(short value) {
        this.ensureCapacity(2);
        this.buffer.putShort(value);
    }

    @Override
    public void putByte(byte value) {
        this.ensureCapacity(1);
        this.buffer.put(value);
    }

    @Override
    public void putBytes(byte[] bytes, int offset, int length) {
        this.ensureCapacity(length);
        this.buffer.put(bytes, offset, length);
    }

    @Override
    public void putByteBuffer(ByteBuffer byteBuffer) {
        this.ensureCapacity(byteBuffer.remaining());
        this.buffer.put(byteBuffer);
    }

    @Override
    public void close() {
        this.buffer.flip();
    }

    private void ensureCapacity(int bytesToWrite) {
        if (this.buffer.remaining() < bytesToWrite) {
            int newCapacity = Math.max(this.buffer.capacity() * this.growthFactor, this.buffer.position() + bytesToWrite);
            ByteBuffer newBuffer = this.newBuffer(newCapacity);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

