/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.mcap.MCAPBufferedChunk;
import us.ihmc.scs2.session.mcap.MCAPMessageManager;
import us.ihmc.scs2.session.mcap.encoding.CDRDeserializer;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Channel;
import us.ihmc.scs2.session.mcap.specs.records.Message;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Schema;
import us.ihmc.scs2.simulation.SpyList;

public class MCAPConsoleLogManager {
    public static final String FOXGLOVE_LOG = "foxglove::Log";
    private final long desiredLogDT;
    private final SpyList<MCAPConsoleLogItem> allConsoleLogItems = new SpyList();
    private int channelId = -1;

    public MCAPConsoleLogManager(MCAP mcap, MCAPBufferedChunk chunkBuffer, long desiredLogDT) throws IOException {
        this.desiredLogDT = desiredLogDT;
        Optional<Schema> logSchema = mcap.records().stream().filter(record -> record.op() == Opcode.SCHEMA).map(record -> (Schema)record.body()).filter(schema -> schema.name().equals(FOXGLOVE_LOG)).findFirst();
        if (logSchema.isPresent()) {
            int id = logSchema.get().id();
            Optional<Channel> logChannel = mcap.records().stream().filter(record -> record.op() == Opcode.CHANNEL).map(record -> (Channel)record.body()).filter(channel -> channel.schemaId() == id).findFirst();
            if (logChannel.isPresent()) {
                if (!"cdr".equalsIgnoreCase(logChannel.get().messageEncoding())) {
                    LogTools.error((String)"Unsupported message encoding: {}", (Object)logChannel.get().messageEncoding());
                    return;
                }
                this.channelId = logChannel.get().id();
                Thread loadingThread = this.createLoadingThread(chunkBuffer, desiredLogDT);
                loadingThread.start();
            }
        }
    }

    private Thread createLoadingThread(MCAPBufferedChunk chunkBuffer, long desiredLogDT) {
        Runnable loadingTask = () -> {
            int counter = 0;
            for (MCAPBufferedChunk.ChunkBundle bundle : chunkBuffer.getChunkBundles()) {
                bundle.requestLoadChunkBundle(true, false, false);
                ArrayList<MCAPConsoleLogItem> orderedItems = new ArrayList<MCAPConsoleLogItem>();
                for (Record record : bundle.getChunkRecords()) {
                    Message message;
                    if (record.op() != Opcode.MESSAGE || (message = (Message)record.body()).channelId() != this.channelId) continue;
                    orderedItems.add(MCAPConsoleLogManager.parseLogItem(message, desiredLogDT));
                }
                if (++counter % (chunkBuffer.getChunkBundles().length / 10) == 0 || counter == chunkBuffer.getChunkBundles().length - 1) {
                    LogTools.info((String)"Loaded {} log items from chunk bundle {}/{}", (Object)orderedItems.size(), (Object)counter, (Object)chunkBuffer.getChunkBundles().length);
                }
                orderedItems.sort(Comparator.comparingLong(MCAPConsoleLogItem::logTime));
                this.allConsoleLogItems.addAll(orderedItems);
            }
        };
        Thread loadingThread = new Thread(loadingTask, this.getClass().getSimpleName() + "-LoadingThread");
        loadingThread.setDaemon(true);
        return loadingThread;
    }

    public SpyList<MCAPConsoleLogItem> getAllConsoleLogItems() {
        return this.allConsoleLogItems;
    }

    private static MCAPConsoleLogItem parseLogItem(Message message, long desiredLogDT) {
        long logTime = MCAPMessageManager.round(message.logTime(), desiredLogDT);
        CDRDeserializer deserializer = new CDRDeserializer();
        deserializer.initialize(message.messageBuffer(), 0, message.dataLength());
        Instant instant = Instant.ofEpochSecond(deserializer.read_uint32(), deserializer.read_uint32());
        MCAPLogLevel logLevel = MCAPLogLevel.values()[deserializer.read_uint8()];
        String logMessage = deserializer.read_string();
        String processName = deserializer.read_string();
        String filename = deserializer.read_string();
        long lineNumberInFile = deserializer.read_uint32();
        deserializer.finalize(true);
        return new MCAPConsoleLogItem(logTime, instant, logLevel, logMessage, processName, filename, lineNumberInFile);
    }

    public static enum MCAPLogLevel {
        UNKNOWN,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }

    public record MCAPConsoleLogItem(long logTime, Instant instant, MCAPLogLevel logLevel, String message, String processName, String filename, long lineNumberInFile) {
    }
}

