/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public class MessageIndexEntry
implements MCAPElement {
    private final long logTime;
    private final long offset;

    public MessageIndexEntry(long logTime, long offset) {
        this.logTime = MCAP.checkPositiveLong(logTime, "logTime");
        this.offset = MCAP.checkPositiveLong(offset, "offset");
    }

    public MessageIndexEntry(MCAPDataInput dataInput, long elementPosition) {
        dataInput.position(elementPosition);
        this.logTime = MCAP.checkPositiveLong(dataInput.getLong(), "logTime");
        this.offset = MCAP.checkPositiveLong(dataInput.getLong(), "offset");
    }

    @Override
    public long getElementLength() {
        return 16L;
    }

    public long logTime() {
        return this.logTime;
    }

    public long offset() {
        return this.offset;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.logTime());
        dataOutput.putLong(this.offset());
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.logTime());
        crc32.addLong(this.offset());
        return crc32;
    }

    @Override
    public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-logTime = " + this.logTime();
        out = out + "\n\t-offset = " + this.offset();
        return MCAPElement.indent(out, indent);
    }

    public boolean equals(Object object) {
        MessageIndexEntry other;
        return object instanceof MessageIndexEntry && this.equals(other = (MessageIndexEntry)object);
    }

    @Override
    public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof MessageIndexEntry) {
            MessageIndexEntry other = (MessageIndexEntry)mcapElement;
            if (this.logTime() != other.logTime()) {
                return false;
            }
            return this.offset() == other.offset();
        }
        return false;
    }
}

