/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.records.ChunkDataInputBacked;
import us.ihmc.scs2.session.mcap.specs.records.Compression;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.MutableChunk;
import us.ihmc.scs2.session.mcap.specs.records.Records;

public interface Chunk
extends MCAPElement {
    public static Chunk load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        return new ChunkDataInputBacked(dataInput, elementPosition, elementLength);
    }

    public long messageStartTime();

    public long messageEndTime();

    public long recordsUncompressedLength();

    public long uncompressedCRC32();

    public Compression compression();

    public long recordsCompressedLength();

    default public ByteBuffer getRecordsCompressedBuffer() {
        return this.getRecordsCompressedBuffer(false);
    }

    public ByteBuffer getRecordsCompressedBuffer(boolean var1);

    default public ByteBuffer getRecordsUncompressedBuffer() {
        return this.getRecordsUncompressedBuffer(false);
    }

    public ByteBuffer getRecordsUncompressedBuffer(boolean var1);

    public Records records();

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-messageStartTime = " + this.messageStartTime();
        out = out + "\n\t-messageEndTime = " + this.messageEndTime();
        out = out + "\n\t-compression = " + this.compression();
        out = out + "\n\t-recordsUncompressedLength = " + this.recordsUncompressedLength();
        out = out + "\n\t-uncompressedCrc32 = " + this.uncompressedCRC32();
        out = out + "\n\t-records = " + (String)(this.records() == null ? "null" : "\n" + EuclidCoreIOTools.getCollectionString((String)"\n", (Collection)this.records(), e -> e.toString(indent + 1)));
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Chunk) {
            Chunk other = (Chunk)mcapElement;
            if (this.messageStartTime() != other.messageStartTime()) {
                return false;
            }
            if (this.messageEndTime() != other.messageEndTime()) {
                return false;
            }
            if (this.recordsUncompressedLength() != other.recordsUncompressedLength()) {
                return false;
            }
            if (this.uncompressedCRC32() != other.uncompressedCRC32()) {
                return false;
            }
            if (this.compression() != other.compression()) {
                return false;
            }
            if (this.recordsCompressedLength() != other.recordsCompressedLength()) {
                return false;
            }
            return Objects.equals(this.records(), other.records());
        }
        return false;
    }

    default public Chunk crop(long startTimestamp, long endTimestamp) {
        long croppedStartTime = MathTools.clamp((long)this.messageStartTime(), (long)startTimestamp, (long)endTimestamp);
        long croppedEndTime = MathTools.clamp((long)this.messageEndTime(), (long)startTimestamp, (long)endTimestamp);
        Records croppedRecords = this.records().crop(croppedStartTime, croppedEndTime);
        if (croppedRecords.isEmpty()) {
            return null;
        }
        MutableChunk croppedChunk = new MutableChunk();
        croppedChunk.setRecords(croppedRecords);
        croppedChunk.setCompression(this.compression());
        return croppedChunk;
    }
}

