/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.SchemaDataInputBacked;

public interface Schema
extends MCAPElement {
    public static Schema load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        return new SchemaDataInputBacked(dataInput, elementPosition, elementLength);
    }

    @Override
    default public long getElementLength() {
        return 14 + this.name().length() + this.encoding().length() + (int)this.dataLength();
    }

    public int id();

    public String name();

    public String encoding();

    public long dataLength();

    public ByteBuffer data();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putUnsignedShort(this.id());
        dataOutput.putString(this.name());
        dataOutput.putString(this.encoding());
        dataOutput.putUnsignedInt(this.dataLength());
        dataOutput.putByteBuffer(this.data());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addUnsignedShort(this.id());
        crc32.addString(this.name());
        crc32.addString(this.encoding());
        crc32.addUnsignedInt(this.dataLength());
        crc32.addByteBuffer(this.data());
        return crc32;
    }

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-id = " + this.id();
        out = out + "\n\t-name = " + this.name();
        out = out + "\n\t-encoding = " + this.encoding();
        out = out + "\n\t-dataLength = " + this.dataLength();
        out = out + "\n\t-data = " + Arrays.toString(this.data().array());
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Schema) {
            Schema other = (Schema)mcapElement;
            if (this.id() != other.id()) {
                return false;
            }
            if (!Objects.equals(this.name(), other.name())) {
                return false;
            }
            if (!Objects.equals(this.encoding(), other.encoding())) {
                return false;
            }
            if (this.dataLength() != other.dataLength()) {
                return false;
            }
            return Arrays.equals(this.data().array(), other.data().array());
        }
        return false;
    }
}

