/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Attachment;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.Message;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndex;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexEntry;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndexOffset;
import us.ihmc.scs2.session.mcap.specs.records.MutableMessageIndex;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.RecordDataInputBacked;

public class Records
extends AbstractList<Record> {
    private final List<Record> records = new ArrayList<Record>();
    private long messageStartTime = 0L;
    private long messageEndTime = 0L;
    private long crc32 = 0L;

    public Records() {
    }

    public Records(Collection<? extends Record> collection) {
        this.addAll(collection);
    }

    public static Records load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        ArrayList records = new ArrayList();
        MCAP.parseList(dataInput, RecordDataInputBacked::new, elementPosition, elementLength, records);
        return new Records(records);
    }

    public void sortByTimestamp() {
        this.records.sort(Comparator.comparingLong(r -> {
            if (r.op() == Opcode.MESSAGE) {
                return ((Message)r.body()).logTime();
            }
            if (r.op() == Opcode.ATTACHMENT) {
                return ((Attachment)r.body()).logTime();
            }
            if (r.op() == Opcode.CHANNEL) {
                return -9223372036854775807L;
            }
            if (r.op() == Opcode.SCHEMA) {
                return Long.MIN_VALUE;
            }
            return 0L;
        }));
        this.updateInfo();
    }

    public boolean containsMessages() {
        return this.records.stream().anyMatch(r -> r.op() == Opcode.MESSAGE);
    }

    @Override
    public boolean add(Record record) {
        this.records.add(record);
        this.updateInfo();
        return true;
    }

    @Override
    public void add(int index, Record element) {
        this.records.add(index, element);
        this.updateInfo();
    }

    @Override
    public boolean addAll(Collection<? extends Record> c) {
        this.records.addAll(c);
        this.updateInfo();
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Record> c) {
        this.records.addAll(index, c);
        this.updateInfo();
        return true;
    }

    @Override
    public Record set(int index, Record element) {
        Record old = this.records.set(index, element);
        this.updateInfo();
        return old;
    }

    @Override
    public Record remove(int index) {
        Record old = this.records.remove(index);
        this.updateInfo();
        return old;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.records.subList(fromIndex, toIndex).clear();
        this.updateInfo();
    }

    @Override
    public Record get(int index) {
        return this.records.get(index);
    }

    public int indexOf(Predicate<Record> predicate) {
        for (int i = 0; i < this.records.size(); ++i) {
            if (!predicate.test(this.records.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    private void updateInfo() {
        this.messageStartTime = this.stream().filter(r -> r.op() == Opcode.MESSAGE).mapToLong(r -> ((Message)r.body()).logTime()).min().orElse(0L);
        this.messageEndTime = this.stream().filter(r -> r.op() == Opcode.MESSAGE).mapToLong(r -> ((Message)r.body()).logTime()).max().orElse(0L);
        this.crc32 = new MCAPCRC32Helper().addHeadlessCollection(this.records).getValue();
    }

    public long getMessageStartTime() {
        return this.messageStartTime;
    }

    public long getMessageEndTime() {
        return this.messageEndTime;
    }

    public long getCRC32() {
        return this.crc32;
    }

    public Records crop(long startTimestamp, long endTimestamp) {
        ArrayList<Record> croppedRecords = new ArrayList<Record>();
        block5: for (Record record : this) {
            switch (record.op()) {
                case HEADER: 
                case FOOTER: 
                case SCHEMA: 
                case CHANNEL: 
                case METADATA: 
                case METADATA_INDEX: {
                    croppedRecords.add(record);
                    continue block5;
                }
                case MESSAGE: {
                    Message message = (Message)record.body();
                    if (message.logTime() < startTimestamp || message.logTime() > endTimestamp) continue block5;
                    croppedRecords.add(record);
                    continue block5;
                }
                case ATTACHMENT: {
                    Attachment attachment = (Attachment)record.body();
                    if (attachment.logTime() < startTimestamp || attachment.logTime() > endTimestamp) continue block5;
                    croppedRecords.add(record);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + record.op());
        }
        return new Records(croppedRecords);
    }

    public long getElementLength() {
        return this.stream().mapToLong(MCAPElement::getElementLength).sum();
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        if (this.isEmpty()) {
            return MCAPElement.indent(this.getClass().getSimpleName() + ": []", indent);
        }
        String out = this.getClass().getSimpleName() + "[\n";
        out = out + EuclidCoreIOTools.getCollectionString((String)"\n", (Collection)this, r -> r.toString(indent + 1));
        return MCAPElement.indent(out, indent);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Records) {
            Records other = (Records)object;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                Record otherRecord;
                Record record = this.get(i);
                if (record.equals(otherRecord = other.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<MessageIndex> generateMessageIndexList() {
        TIntObjectHashMap messageIndexMap = new TIntObjectHashMap();
        long messageIndexOffset = 0L;
        for (Record record : this) {
            if (record.op() == Opcode.MESSAGE) {
                Message message = (Message)record.body();
                int channelId = message.channelId();
                MutableMessageIndex messageIndex = (MutableMessageIndex)messageIndexMap.get(channelId);
                if (messageIndex == null) {
                    messageIndex = new MutableMessageIndex();
                    messageIndex.setChannelId(channelId);
                    messageIndexMap.put(channelId, (Object)messageIndex);
                }
                MessageIndexEntry messageIndexEntry = new MessageIndexEntry(message.logTime(), messageIndexOffset);
                messageIndex.addMessageIndexEntry(messageIndexEntry);
            }
            messageIndexOffset += record.getElementLength();
        }
        List<MessageIndex> messageIndices = Arrays.asList((MessageIndex[])messageIndexMap.values((Object[])new MutableMessageIndex[messageIndexMap.size()]));
        messageIndices.sort(Comparator.comparingInt(MessageIndex::channelId));
        return messageIndices;
    }

    public static List<MessageIndexOffset> generateMessageIndexOffsets(long offset, List<? extends Record> messageIndexRecordList) {
        ArrayList<MessageIndexOffset> messageIndexOffsets = new ArrayList<MessageIndexOffset>();
        long messageIndexOffset = offset;
        for (Record record : messageIndexRecordList) {
            if (record.op() != Opcode.MESSAGE_INDEX) {
                throw new IllegalArgumentException("Expected a message index record, but got: " + record.op());
            }
            MessageIndex messageIndex = (MessageIndex)record.body();
            messageIndexOffsets.add(new MessageIndexOffset(messageIndex.channelId(), messageIndexOffset));
            messageIndexOffset += record.getElementLength();
        }
        return messageIndexOffsets;
    }
}

