/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.Arrays;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;

public class Magic {
    public static final int MAGIC_SIZE = 8;
    public static final byte[] MAGIC_BYTES = new byte[]{-119, 77, 67, 65, 80, 48, 13, 10};

    private Magic() {
    }

    public static void readMagic(MCAPDataInput dataInput, long elementPosition) {
        dataInput.position(elementPosition);
        byte[] magic = dataInput.getBytes(8);
        if (!Arrays.equals(magic, MAGIC_BYTES)) {
            throw new IllegalArgumentException("Invalid magic bytes: " + Arrays.toString(magic) + ". Expected: " + Arrays.toString(MAGIC_BYTES));
        }
    }

    public static void writeMagic(MCAPDataOutput dataOutput) {
        dataOutput.putBytes(MAGIC_BYTES);
    }

    public static long getElementLength() {
        return 8L;
    }
}

