/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.encoding;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;
import us.ihmc.scs2.session.mcap.encoding.LZ4FrameDecoder;

public class LZ4FrameEncoder {
    static final LZ4FrameDecoder.FLG.Bits[] DEFAULT_FEATURES = new LZ4FrameDecoder.FLG.Bits[]{LZ4FrameDecoder.FLG.Bits.BLOCK_INDEPENDENCE};
    static final String CLOSED_STREAM = "The stream is already closed";
    private final LZ4Compressor compressor;
    private final XXHash32 checksum;
    private final ByteBuffer blockBuffer;
    private final byte[] compressedBuffer;
    private final int maxBlockSize;
    private final long knownSize;
    private final ByteBuffer intLEBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
    private LZ4FrameDecoder.FrameInfo frameInfo = null;

    public LZ4FrameEncoder(LZ4FrameDecoder.BLOCKSIZE blockSize, LZ4FrameDecoder.FLG.Bits ... bits) {
        this(blockSize, -1L, bits);
    }

    public LZ4FrameEncoder(LZ4FrameDecoder.BLOCKSIZE blockSize, long knownSize, LZ4FrameDecoder.FLG.Bits ... bits) {
        this(blockSize, knownSize, LZ4Factory.fastestInstance().fastCompressor(), XXHashFactory.fastestInstance().hash32(), bits);
    }

    public LZ4FrameEncoder(LZ4FrameDecoder.BLOCKSIZE blockSize, long knownSize, LZ4Compressor compressor, XXHash32 checksum, LZ4FrameDecoder.FLG.Bits ... bits) {
        this.compressor = compressor;
        this.checksum = checksum;
        this.frameInfo = new LZ4FrameDecoder.FrameInfo(new LZ4FrameDecoder.FLG(1, bits), new LZ4FrameDecoder.BD(blockSize));
        this.maxBlockSize = this.frameInfo.getBD().getBlockMaximumSize();
        this.blockBuffer = ByteBuffer.allocate(this.maxBlockSize).order(ByteOrder.LITTLE_ENDIAN);
        this.compressedBuffer = new byte[this.compressor.maxCompressedLength(this.maxBlockSize)];
        if (this.frameInfo.getFLG().isEnabled(LZ4FrameDecoder.FLG.Bits.CONTENT_SIZE) && knownSize < 0L) {
            throw new IllegalArgumentException("Known size must be greater than zero in order to use the known size feature");
        }
        this.knownSize = knownSize;
    }

    public LZ4FrameEncoder(LZ4FrameDecoder.BLOCKSIZE blockSize) {
        this(blockSize, DEFAULT_FEATURES);
    }

    public LZ4FrameEncoder() {
        this(LZ4FrameDecoder.BLOCKSIZE.SIZE_4MB);
    }

    public byte[] encode(byte[] in, byte[] out) {
        return this.encode(in, 0, in.length, out, 0);
    }

    public byte[] encode(byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        ByteBuffer resultBuffer = this.encode(ByteBuffer.wrap(in, inOffset, inLength), out == null ? null : ByteBuffer.wrap(out, outOffset, out.length - outOffset));
        if (resultBuffer == null) {
            return null;
        }
        byte[] result = new byte[resultBuffer.remaining()];
        resultBuffer.get(result);
        return result;
    }

    public ByteBuffer encode(ByteBuffer in, ByteBuffer out) {
        return this.encode(in, 0, in.remaining(), out, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer encode(ByteBuffer in, int inOffset, int inLength, ByteBuffer out, int outOffset) {
        int limitPrev = in.limit();
        in.position(inOffset);
        in.limit(inOffset + inLength);
        if (out != null) {
            out.order(ByteOrder.LITTLE_ENDIAN);
            out.position(outOffset);
        }
        try {
            if (out != null) {
                this.writeHeader(out);
                this.ensureNotFinished();
                while (in.remaining() > this.blockBuffer.remaining()) {
                    int sizeWritten = this.blockBuffer.remaining();
                    this.blockBuffer.put(in.slice(in.position(), sizeWritten));
                    in.position(in.position() + sizeWritten);
                    this.writeBlock(out);
                }
                this.blockBuffer.put(in);
                this.writeBlock(out);
                this.writeEndMark(out);
                out.flip();
                ByteBuffer sizeWritten = out;
                return sizeWritten;
            }
            ByteBuffer whenOutIsNull = ByteBuffer.allocate(inLength + 15).order(ByteOrder.LITTLE_ENDIAN);
            this.writeHeader(whenOutIsNull);
            this.ensureNotFinished();
            while (in.remaining() > this.blockBuffer.remaining()) {
                int sizeWritten = this.blockBuffer.remaining();
                this.blockBuffer.put(in.slice(in.position(), sizeWritten));
                in.position(in.position() + sizeWritten);
                whenOutIsNull = LZ4FrameEncoder.ensureCapacity(whenOutIsNull, this.blockBuffer.limit());
                this.writeBlock(whenOutIsNull);
            }
            this.blockBuffer.put(in);
            whenOutIsNull = LZ4FrameEncoder.ensureCapacity(whenOutIsNull, this.blockBuffer.limit());
            this.writeBlock(whenOutIsNull);
            whenOutIsNull = LZ4FrameEncoder.ensureCapacity(whenOutIsNull, 8);
            this.writeEndMark(whenOutIsNull);
            whenOutIsNull.flip();
            ByteBuffer byteBuffer = whenOutIsNull;
            return byteBuffer;
        }
        finally {
            in.limit(limitPrev);
        }
    }

    private static ByteBuffer ensureCapacity(ByteBuffer buffer, int remainingNeeded) {
        if (buffer.remaining() >= remainingNeeded) {
            return buffer;
        }
        ByteBuffer extended = ByteBuffer.allocate(buffer.capacity() + remainingNeeded);
        extended.order(ByteOrder.LITTLE_ENDIAN);
        buffer.flip();
        extended.put(buffer);
        return extended;
    }

    private void writeHeader(ByteBuffer out) {
        if (out.remaining() < 15) {
            throw new IllegalArgumentException("The provided buffer is too small to write the header");
        }
        out.order(ByteOrder.LITTLE_ENDIAN);
        out.putInt(407708164);
        out.put(this.frameInfo.getFLG().toByte());
        out.put(this.frameInfo.getBD().toByte());
        if (this.frameInfo.isEnabled(LZ4FrameDecoder.FLG.Bits.CONTENT_SIZE)) {
            out.putLong(this.knownSize);
        }
        int hash = this.checksum.hash(out.array(), 4, out.position() - 4, 0) >> 8 & 0xFF;
        out.put((byte)hash);
    }

    private void writeBlock(ByteBuffer out) {
        int compressMethod;
        byte[] bufferToWrite;
        int compressedLength;
        if (this.blockBuffer.position() == 0) {
            return;
        }
        Arrays.fill(this.compressedBuffer, (byte)0);
        if (this.frameInfo.isEnabled(LZ4FrameDecoder.FLG.Bits.CONTENT_CHECKSUM)) {
            this.frameInfo.updateStreamHash(this.blockBuffer.array(), 0, this.blockBuffer.position());
        }
        if ((compressedLength = this.compressor.compress(this.blockBuffer.array(), 0, this.blockBuffer.position(), this.compressedBuffer, 0)) >= this.blockBuffer.position()) {
            compressedLength = this.blockBuffer.position();
            bufferToWrite = Arrays.copyOf(this.blockBuffer.array(), compressedLength);
            compressMethod = Integer.MIN_VALUE;
        } else {
            bufferToWrite = this.compressedBuffer;
            compressMethod = 0;
        }
        out.putInt(compressedLength | compressMethod);
        out.put(bufferToWrite, 0, compressedLength);
        if (this.frameInfo.isEnabled(LZ4FrameDecoder.FLG.Bits.BLOCK_CHECKSUM)) {
            out.putInt(this.checksum.hash(bufferToWrite, 0, compressedLength, 0));
        }
        this.blockBuffer.rewind();
    }

    private void writeEndMark(ByteBuffer out) {
        out.order(ByteOrder.LITTLE_ENDIAN);
        out.putInt(0);
        if (this.frameInfo.isEnabled(LZ4FrameDecoder.FLG.Bits.CONTENT_CHECKSUM)) {
            out.putInt(0, this.frameInfo.currentStreamHash());
        }
        this.frameInfo.finish();
    }

    private void ensureNotFinished() {
        if (this.frameInfo.isFinished()) {
            throw new IllegalStateException(CLOSED_STREAM);
        }
    }
}

