/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.log;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import us.ihmc.commons.Conversions;
import us.ihmc.graphicsDescription.conversion.YoGraphicConversionTools;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.log.LogDataReader;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.tools.RobotDataLogTools;
import us.ihmc.scs2.session.tools.RobotModelLoader;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.simulation.TimeConsumer;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotInterface;

public class LogSession
extends Session {
    private final String sessionName;
    private final List<Robot> robots = new ArrayList<Robot>();
    private final List<RobotDefinition> robotDefinitions = new ArrayList<RobotDefinition>();
    private final List<YoGraphicDefinition> yoGraphicDefinitions = new ArrayList<YoGraphicDefinition>();
    private final Runnable robotStateUpdater;
    private final File logDirectory;
    private final LogDataReader logDataReader;
    private final LogPropertiesReader logProperties;
    private final AtomicInteger logPositionRequest = new AtomicInteger(-1);
    private final List<TimeConsumer> afterReadCallbacks = new ArrayList<TimeConsumer>();
    private boolean firstLogPositionRequest = true;

    public LogSession(File logDirectory, ProgressConsumer progressConsumer) throws IOException {
        this.logDirectory = logDirectory;
        try {
            this.logDataReader = new LogDataReader(logDirectory, progressConsumer);
            LogTools.info((String)"Created data reader.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logProperties = this.logDataReader.getLogProperties();
        YoVariableHandshakeParser parser = this.logDataReader.getParser();
        this.rootRegistry.addChild(this.logDataReader.getYoRegistry());
        this.rootRegistry.addChild(parser.getRootRegistry());
        this.yoGraphicDefinitions.add((YoGraphicDefinition)new YoGraphicGroupDefinition("SCS1 YoGraphics", (Collection)YoGraphicConversionTools.toYoGraphicDefinitions((YoGraphicsListRegistry)parser.getSCS1YoGraphics())));
        if (parser.getSCS2YoGraphics() != null) {
            this.yoGraphicDefinitions.addAll(parser.getSCS2YoGraphics());
        }
        this.sessionName = this.logProperties.getNameAsString();
        RobotDefinition robotDefinition = RobotDataLogTools.loadRobotDefinition(logDirectory, (LogProperties)this.logProperties);
        if (robotDefinition != null) {
            this.robotDefinitions.add(robotDefinition);
            Robot robot = new Robot(robotDefinition, this.getInertialFrame());
            this.robots.add(robot);
            this.robotStateUpdater = RobotModelLoader.setupRobotUpdater((RobotInterface)robot, parser, this.rootRegistry);
        } else {
            this.robotStateUpdater = null;
        }
        this.setDesiredBufferPublishPeriod(Conversions.secondsToNanoseconds((double)0.03333333333333333));
        this.setSessionDTSeconds(parser.getDt());
        this.setSessionMode(SessionMode.PAUSE);
    }

    public void submitLogPositionRequest(int logPosition) {
        this.logPositionRequest.set(logPosition);
    }

    protected void initializeSession() {
        this.logDataReader.read();
        if (this.robotStateUpdater != null) {
            this.robotStateUpdater.run();
        }
    }

    protected void initializeRunTick() {
        if (this.firstRunTick) {
            this.equationManager.reset();
            YoBufferPropertiesReadOnly properties = this.sharedBuffer.getProperties();
            if (properties.getCurrentIndex() != properties.getOutPoint()) {
                this.sharedBuffer.setInPoint(properties.getCurrentIndex());
            } else if (!this.firstLogPositionRequest) {
                this.sharedBuffer.setInPoint(properties.getCurrentIndex());
            }
            this.sharedBuffer.incrementBufferIndex(true);
            this.logDataReader.seek(this.logDataReader.getCurrentLogPosition());
            this.nextRunBufferRecordTickCounter = 0;
            this.firstRunTick = false;
        } else if (this.nextRunBufferRecordTickCounter <= 0) {
            this.sharedBuffer.incrementBufferIndex(true);
            this.sharedBuffer.processLinkedPushRequests(false);
        }
    }

    protected double doSpecificRunTick() {
        boolean endOfLog = this.logDataReader.read();
        if (endOfLog) {
            this.setSessionMode(SessionMode.PAUSE);
        }
        if (this.robotStateUpdater != null) {
            this.robotStateUpdater.run();
        }
        double currentTime = this.logDataReader.getCurrentRobotTime();
        for (int i = 0; i < this.afterReadCallbacks.size(); ++i) {
            this.afterReadCallbacks.get(i).accept(currentTime);
        }
        return currentTime;
    }

    public void pauseTick() {
        int logPosition;
        if (this.firstPauseTick) {
            this.firstLogPositionRequest = true;
        }
        if ((logPosition = this.logPositionRequest.getAndSet(-1)) == -1) {
            super.pauseTick();
        } else {
            this.processBufferRequests(false);
            this.logDataReader.seek(logPosition);
            this.logDataReader.read();
            if (this.robotStateUpdater != null) {
                this.robotStateUpdater.run();
            }
            if (this.firstLogPositionRequest) {
                this.sharedBuffer.incrementBufferIndex(true);
                this.firstLogPositionRequest = false;
            }
            this.sharedBuffer.writeBuffer();
            this.sharedBuffer.prepareLinkedBuffersForPull();
            this.publishBufferProperties(this.sharedBuffer.getProperties());
        }
    }

    public void addAfterReadCallback(TimeConsumer callback) {
        this.afterReadCallbacks.add(Objects.requireNonNull(callback, "The callback cannot be null."));
    }

    public boolean removeAfterReadCallback(TimeConsumer callback) {
        return this.afterReadCallbacks.remove(callback);
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotDefinitions;
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return Collections.emptyList();
    }

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return this.yoGraphicDefinitions;
    }

    public List<Robot> getRobots() {
        return this.robots;
    }

    public List<RobotStateDefinition> getCurrentRobotStateDefinitions(boolean initialState) {
        return this.robots.stream().map(Robot::getCurrentRobotStateDefinition).collect(Collectors.toList());
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public LogDataReader getLogDataReader() {
        return this.logDataReader;
    }

    public LogPropertiesReader getLogProperties() {
        return this.logProperties;
    }
}

