/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import gnu.trove.map.hash.TIntObjectHashMap;
import us.ihmc.scs2.session.mcap.specs.records.Attachment;
import us.ihmc.scs2.session.mcap.specs.records.AttachmentIndex;
import us.ihmc.scs2.session.mcap.specs.records.Channel;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.ChunkIndex;
import us.ihmc.scs2.session.mcap.specs.records.DataEnd;
import us.ihmc.scs2.session.mcap.specs.records.Footer;
import us.ihmc.scs2.session.mcap.specs.records.Header;
import us.ihmc.scs2.session.mcap.specs.records.Message;
import us.ihmc.scs2.session.mcap.specs.records.MessageIndex;
import us.ihmc.scs2.session.mcap.specs.records.Metadata;
import us.ihmc.scs2.session.mcap.specs.records.MetadataIndex;
import us.ihmc.scs2.session.mcap.specs.records.Schema;
import us.ihmc.scs2.session.mcap.specs.records.Statistics;
import us.ihmc.scs2.session.mcap.specs.records.SummaryOffset;

public enum Opcode {
    HEADER(1),
    FOOTER(2),
    SCHEMA(3),
    CHANNEL(4),
    MESSAGE(5),
    CHUNK(6),
    MESSAGE_INDEX(7),
    CHUNK_INDEX(8),
    ATTACHMENT(9),
    ATTACHMENT_INDEX(10),
    STATISTICS(11),
    METADATA(12),
    METADATA_INDEX(13),
    SUMMARY_OFFSET(14),
    DATA_END(15);

    private final int id;
    private static final TIntObjectHashMap<Opcode> byId;

    private Opcode(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public static Opcode byId(int id) {
        return (Opcode)((Object)byId.get(id));
    }

    public static Opcode byBodyType(Class<?> bodyType) {
        if (bodyType == null) {
            return null;
        }
        if (Header.class.isAssignableFrom(bodyType)) {
            return HEADER;
        }
        if (Footer.class.isAssignableFrom(bodyType)) {
            return FOOTER;
        }
        if (Schema.class.isAssignableFrom(bodyType)) {
            return SCHEMA;
        }
        if (Channel.class.isAssignableFrom(bodyType)) {
            return CHANNEL;
        }
        if (Message.class.isAssignableFrom(bodyType)) {
            return MESSAGE;
        }
        if (Chunk.class.isAssignableFrom(bodyType)) {
            return CHUNK;
        }
        if (MessageIndex.class.isAssignableFrom(bodyType)) {
            return MESSAGE_INDEX;
        }
        if (ChunkIndex.class.isAssignableFrom(bodyType)) {
            return CHUNK_INDEX;
        }
        if (Attachment.class.isAssignableFrom(bodyType)) {
            return ATTACHMENT;
        }
        if (AttachmentIndex.class.isAssignableFrom(bodyType)) {
            return ATTACHMENT_INDEX;
        }
        if (Statistics.class.isAssignableFrom(bodyType)) {
            return STATISTICS;
        }
        if (Metadata.class.isAssignableFrom(bodyType)) {
            return METADATA;
        }
        if (MetadataIndex.class.isAssignableFrom(bodyType)) {
            return METADATA_INDEX;
        }
        if (SummaryOffset.class.isAssignableFrom(bodyType)) {
            return SUMMARY_OFFSET;
        }
        if (DataEnd.class.isAssignableFrom(bodyType)) {
            return DATA_END;
        }
        throw new IllegalArgumentException("Unsupported body type: " + bodyType);
    }

    static {
        byId = new TIntObjectHashMap(15);
        for (Opcode e : Opcode.values()) {
            byId.put(e.id(), (Object)e);
        }
    }
}

