/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.List;
import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.ChannelDataInputBacked;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;
import us.ihmc.scs2.session.mcap.specs.records.StringPair;

public interface Channel
extends MCAPElement {
    public static Channel load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        return new ChannelDataInputBacked(dataInput, elementPosition, elementLength);
    }

    public int id();

    public int schemaId();

    public String topic();

    public String messageEncoding();

    public List<StringPair> metadata();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putInt(this.id());
        dataOutput.putInt(this.schemaId());
        dataOutput.putString(this.topic());
        dataOutput.putString(this.messageEncoding());
        dataOutput.putCollection(this.metadata());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addInt(this.id());
        crc32.addInt(this.schemaId());
        crc32.addString(this.topic());
        crc32.addString(this.messageEncoding());
        crc32.addCollection(this.metadata());
        return crc32;
    }

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ":";
        out = out + "\n\t-id = " + this.id();
        out = out + "\n\t-schemaId = " + this.schemaId();
        out = out + "\n\t-topic = " + this.topic();
        out = out + "\n\t-messageEncoding = " + this.messageEncoding();
        out = out + "\n\t-metadata = [%s]".formatted(this.metadata().toString());
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Channel) {
            Channel other = (Channel)mcapElement;
            if (this.id() != other.id()) {
                return false;
            }
            if (this.schemaId() != other.schemaId()) {
                return false;
            }
            if (!Objects.equals(this.topic(), other.topic())) {
                return false;
            }
            if (!Objects.equals(this.messageEncoding(), other.messageEncoding())) {
                return false;
            }
            return Objects.equals(this.metadata(), other.metadata());
        }
        return false;
    }
}

