/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.nio.ByteBuffer;
import java.util.Objects;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.records.AttachmentDataInputBacked;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public interface Attachment
extends MCAPElement {
    public static Attachment load(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        return new AttachmentDataInputBacked(dataInput, elementPosition, elementLength);
    }

    public ByteBuffer crc32Input();

    public long logTime();

    public long createTime();

    public String name();

    public String mediaType();

    public long dataLength();

    public ByteBuffer data();

    public long crc32();

    @Override
    default public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.logTime());
        dataOutput.putLong(this.createTime());
        dataOutput.putString(this.name());
        dataOutput.putString(this.mediaType());
        dataOutput.putLong(this.dataLength());
        dataOutput.putByteBuffer(this.data());
        dataOutput.putUnsignedInt(this.crc32());
    }

    @Override
    default public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.logTime());
        crc32.addLong(this.createTime());
        crc32.addString(this.name());
        crc32.addString(this.mediaType());
        crc32.addLong(this.dataLength());
        crc32.addByteBuffer(this.data());
        crc32.addUnsignedInt(this.crc32());
        return crc32;
    }

    @Override
    default public String toString(int indent) {
        String out = this.getClass().getSimpleName() + ": ";
        out = out + "\n\t-logTime = " + this.logTime();
        out = out + "\n\t-createTime = " + this.createTime();
        out = out + "\n\t-name = " + this.name();
        out = out + "\n\t-mediaType = " + this.mediaType();
        out = out + "\n\t-dataLength = " + this.dataLength();
        out = out + "\n\t-data = " + this.data();
        out = out + "\n\t-crc32 = " + this.crc32();
        return MCAPElement.indent(out, indent);
    }

    @Override
    default public boolean equals(MCAPElement mcapElement) {
        if (mcapElement == this) {
            return true;
        }
        if (mcapElement instanceof Attachment) {
            Attachment other = (Attachment)mcapElement;
            if (this.logTime() != other.logTime()) {
                return false;
            }
            if (this.createTime() != other.createTime()) {
                return false;
            }
            if (!Objects.equals(this.name(), other.name())) {
                return false;
            }
            if (!Objects.equals(this.mediaType(), other.mediaType())) {
                return false;
            }
            if (this.dataLength() != other.dataLength()) {
                return false;
            }
            if (!this.data().equals(other.data())) {
                return false;
            }
            return this.crc32() == other.crc32();
        }
        return false;
    }
}

