/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import us.ihmc.scs2.session.mcap.specs.records.ChannelMessageCount;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Statistics;

public class MutableStatistics
implements Statistics {
    private long messageCount;
    private int schemaCount;
    private long channelCount;
    private long attachmentCount;
    private long metadataCount;
    private long chunkCount;
    private long messageStartTime;
    private long messageEndTime;
    private List<ChannelMessageCount> channelMessageCounts;
    private long channelMessageCountsLength;

    @Override
    public long getElementLength() {
        return 46L + this.channelMessageCountsLength;
    }

    public void incrementCount(Opcode op) {
        switch (op) {
            case MESSAGE: {
                this.incrementMessageCount();
                break;
            }
            case SCHEMA: {
                this.incrementSchemaCount();
                break;
            }
            case CHANNEL: {
                this.incrementChannelCount();
                break;
            }
            case ATTACHMENT: {
                this.incrementAttachmentCount();
                break;
            }
            case METADATA: {
                this.incrementMetadataCount();
                break;
            }
            case CHUNK: {
                this.incrementChunkCount();
                break;
            }
        }
    }

    public void incrementMessageCount() {
        ++this.messageCount;
    }

    public void setMessageCount(long messageCount) {
        this.messageCount = messageCount;
    }

    public void incrementSchemaCount() {
        ++this.schemaCount;
    }

    public void setSchemaCount(int schemaCount) {
        this.schemaCount = schemaCount;
    }

    public void incrementChannelCount() {
        ++this.channelCount;
    }

    public void setChannelCount(long channelCount) {
        this.channelCount = channelCount;
    }

    public void incrementAttachmentCount() {
        ++this.attachmentCount;
    }

    public void setAttachmentCount(long attachmentCount) {
        this.attachmentCount = attachmentCount;
    }

    public void incrementMetadataCount() {
        ++this.metadataCount;
    }

    public void setMetadataCount(long metadataCount) {
        this.metadataCount = metadataCount;
    }

    public void incrementChunkCount() {
        ++this.chunkCount;
    }

    public void setChunkCount(long chunkCount) {
        this.chunkCount = chunkCount;
    }

    public void updateMessageTimes(long messageStartTime, long messageEndTime) {
        this.updateMessageStartTime(messageStartTime);
        this.updateMessageEndTime(messageEndTime);
    }

    public void updateMessageStartTime(long messageStartTime) {
        this.messageStartTime = this.messageStartTime == 0L ? messageStartTime : Math.min(this.messageStartTime, messageStartTime);
    }

    public void setMessageStartTime(long messageStartTime) {
        this.messageStartTime = messageStartTime;
    }

    public void updateMessageEndTime(long messageEndTime) {
        this.messageEndTime = this.messageEndTime == 0L ? messageEndTime : Math.max(this.messageEndTime, messageEndTime);
    }

    public void setMessageEndTime(long messageEndTime) {
        this.messageEndTime = messageEndTime;
    }

    public void incrementChannelMessageCount(int channelIndex) {
        Optional<ChannelMessageCount> countOptional;
        if (this.channelMessageCounts == null) {
            this.channelMessageCounts = new ArrayList<ChannelMessageCount>();
        }
        if ((countOptional = this.channelMessageCounts.stream().filter(count -> count.channelId() == channelIndex).findFirst()).isPresent()) {
            countOptional.get().incrementMessageCount();
        } else {
            this.channelMessageCounts.add(new ChannelMessageCount(channelIndex, 1L));
            this.channelMessageCountsLength += 10L;
        }
    }

    public void setChannelMessageCounts(List<ChannelMessageCount> channelMessageCounts) {
        this.channelMessageCounts = channelMessageCounts;
        this.channelMessageCountsLength = (long)channelMessageCounts.size() * 10L;
    }

    @Override
    public long messageCount() {
        return this.messageCount;
    }

    @Override
    public int schemaCount() {
        return this.schemaCount;
    }

    @Override
    public long channelCount() {
        return this.channelCount;
    }

    @Override
    public long attachmentCount() {
        return this.attachmentCount;
    }

    @Override
    public long metadataCount() {
        return this.metadataCount;
    }

    @Override
    public long chunkCount() {
        return this.chunkCount;
    }

    @Override
    public long messageStartTime() {
        return this.messageStartTime;
    }

    @Override
    public long messageEndTime() {
        return this.messageEndTime;
    }

    @Override
    public List<ChannelMessageCount> channelMessageCounts() {
        return this.channelMessageCounts;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        Statistics other;
        return object instanceof Statistics && Statistics.super.equals(other = (Statistics)object);
    }
}

