/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.specs.records;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import us.ihmc.scs2.session.mcap.encoding.MCAPCRC32Helper;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.Compression;
import us.ihmc.scs2.session.mcap.specs.records.Records;

public class ChunkDataInputBacked
implements Chunk {
    private final MCAPDataInput dataInput;
    private final long elementLength;
    private final long messageStartTime;
    private final long messageEndTime;
    private final long recordsUncompressedLength;
    private final long uncompressedCRC32;
    private final Compression compression;
    private final long recordsOffset;
    private final long recordsCompressedLength;
    private WeakReference<Records> recordsRef;
    private WeakReference<ByteBuffer> recordsUncompressedBufferRef;

    ChunkDataInputBacked(MCAPDataInput dataInput, long elementPosition, long elementLength) {
        this.dataInput = dataInput;
        this.elementLength = elementLength;
        dataInput.position(elementPosition);
        this.messageStartTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageStartTime");
        this.messageEndTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageEndTime");
        this.recordsUncompressedLength = MCAP.checkPositiveLong(dataInput.getLong(), "recordsUncompressedLength");
        this.uncompressedCRC32 = dataInput.getUnsignedInt();
        this.compression = Compression.fromString(dataInput.getString());
        this.recordsCompressedLength = MCAP.checkPositiveLong(dataInput.getLong(), "recordsCompressedLength");
        this.recordsOffset = dataInput.position();
        MCAP.checkLength(this.getElementLength(), (long)(36 + this.compression.getLength()) + this.recordsCompressedLength);
    }

    @Override
    public long getElementLength() {
        return this.elementLength;
    }

    @Override
    public long messageStartTime() {
        return this.messageStartTime;
    }

    @Override
    public long messageEndTime() {
        return this.messageEndTime;
    }

    @Override
    public long recordsUncompressedLength() {
        return this.recordsUncompressedLength;
    }

    @Override
    public long uncompressedCRC32() {
        return this.uncompressedCRC32;
    }

    @Override
    public Compression compression() {
        return this.compression;
    }

    public long recordsOffset() {
        return this.recordsOffset;
    }

    @Override
    public long recordsCompressedLength() {
        return this.recordsCompressedLength;
    }

    @Override
    public ByteBuffer getRecordsCompressedBuffer(boolean directBuffer) {
        return this.dataInput.getByteBuffer(this.recordsOffset, (int)this.recordsCompressedLength, directBuffer);
    }

    @Override
    public ByteBuffer getRecordsUncompressedBuffer(boolean directBuffer) {
        ByteBuffer recordsUncompressedBuffer;
        ByteBuffer byteBuffer = recordsUncompressedBuffer = this.recordsUncompressedBufferRef == null ? null : (ByteBuffer)this.recordsUncompressedBufferRef.get();
        if (recordsUncompressedBuffer == null) {
            recordsUncompressedBuffer = this.dataInput.getDecompressedByteBuffer(this.recordsOffset, (int)this.recordsCompressedLength, (int)this.recordsUncompressedLength, this.compression, directBuffer);
            this.recordsUncompressedBufferRef = new WeakReference<ByteBuffer>(recordsUncompressedBuffer);
        }
        return recordsUncompressedBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public Records records() {
        Records records;
        Records records2 = records = this.recordsRef == null ? null : (Records)this.recordsRef.get();
        if (records != null) {
            return records;
        }
        records = this.compression == Compression.NONE ? Records.load(this.dataInput, this.recordsOffset, (int)this.recordsCompressedLength) : Records.load(MCAPDataInput.wrap(this.getRecordsUncompressedBuffer()), 0L, (int)this.recordsUncompressedLength);
        this.recordsRef = new WeakReference<Records>(records);
        return records;
    }

    @Override
    public void write(MCAPDataOutput dataOutput) {
        dataOutput.putLong(this.messageStartTime);
        dataOutput.putLong(this.messageEndTime);
        dataOutput.putLong(this.recordsUncompressedLength);
        dataOutput.putUnsignedInt(this.uncompressedCRC32);
        dataOutput.putString(this.compression.getName());
        dataOutput.putLong(this.recordsCompressedLength);
        dataOutput.putByteBuffer(this.dataInput.getByteBuffer(this.recordsOffset, (int)this.recordsCompressedLength, false));
    }

    @Override
    public MCAPCRC32Helper updateCRC(MCAPCRC32Helper crc32) {
        if (crc32 == null) {
            crc32 = new MCAPCRC32Helper();
        }
        crc32.addLong(this.messageStartTime);
        crc32.addLong(this.messageEndTime);
        crc32.addLong(this.recordsUncompressedLength);
        crc32.addUnsignedInt(this.uncompressedCRC32);
        crc32.addString(this.compression.getName());
        crc32.addLong(this.recordsCompressedLength);
        crc32.addByteBuffer(this.dataInput.getByteBuffer(this.recordsOffset, (int)this.recordsCompressedLength, false));
        return crc32;
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(Object object) {
        Chunk other;
        return object instanceof Chunk && Chunk.super.equals(other = (Chunk)object);
    }
}

