/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.encoding;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.zip.CRC32;
import us.ihmc.scs2.session.mcap.specs.records.MCAPElement;

public class MCAPCRC32Helper {
    private final CRC32 crc32 = new CRC32();
    private final ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    public MCAPCRC32Helper reset() {
        this.crc32.reset();
        return this;
    }

    public MCAPCRC32Helper addLong(long value) {
        this.buffer.clear();
        this.buffer.putLong(value);
        this.buffer.flip();
        return this.addByteBuffer(this.buffer);
    }

    public MCAPCRC32Helper addInt(int value) {
        this.buffer.clear();
        this.buffer.putInt(value);
        this.buffer.flip();
        return this.addByteBuffer(this.buffer);
    }

    public MCAPCRC32Helper addUnsignedInt(long value) {
        return this.addInt((int)value);
    }

    public MCAPCRC32Helper addShort(short value) {
        this.buffer.clear();
        this.buffer.putShort(value);
        this.buffer.flip();
        return this.addByteBuffer(this.buffer);
    }

    public MCAPCRC32Helper addUnsignedShort(int value) {
        return this.addShort((short)value);
    }

    public MCAPCRC32Helper addByte(byte value) {
        this.crc32.update(value);
        return this;
    }

    public MCAPCRC32Helper addUnsignedByte(int value) {
        return this.addByte((byte)value);
    }

    public MCAPCRC32Helper addBytes(byte[] bytes) {
        this.crc32.update(bytes);
        return this;
    }

    public MCAPCRC32Helper addBytes(byte[] bytes, int offset, int length) {
        this.crc32.update(bytes, offset, length);
        return this;
    }

    public MCAPCRC32Helper addByteBuffer(ByteBuffer byteBuffer) {
        this.crc32.update(byteBuffer);
        return this;
    }

    public MCAPCRC32Helper addString(String value) {
        byte[] bytes = value.getBytes();
        this.addUnsignedInt(bytes.length);
        return this.addBytes(bytes);
    }

    public <T extends MCAPElement> MCAPCRC32Helper addCollection(Collection<T> collection) {
        this.addUnsignedInt(collection.stream().mapToLong(MCAPElement::getElementLength).sum());
        return this.addHeadlessCollection(collection);
    }

    public <T extends MCAPElement> MCAPCRC32Helper addHeadlessCollection(Collection<T> collection) {
        collection.forEach(element -> element.updateCRC(this));
        return this;
    }

    public long getValue() {
        return this.crc32.getValue();
    }
}

