/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.scs2.session.mcap.RobotStateUpdater;
import us.ihmc.scs2.session.mcap.YoMCAPMessage;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoPose3D;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoTuple3D;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class MCAPMujocoBasedRobotStateUpdater
implements RobotStateUpdater {
    private static final String MUJOCO_ROOT_JOINT = "root_joint";
    private final List<Runnable> jointStateUpdaters = new ArrayList<Runnable>();

    public static boolean isRobotMujocoStateMessage(Robot robot, YoMCAPMessage message) {
        if (!message.getSchema().getName().contains("mujoco")) {
            return false;
        }
        SimFloatingJointBasics rootJoint = robot.getFloatingRootJoint();
        if (rootJoint != null) {
            if (rootJoint instanceof SixDoFJointReadOnly) {
                if (MCAPMujocoBasedRobotStateUpdater.findSixDoFJointConfigurationVariable(message, MUJOCO_ROOT_JOINT) == null) {
                    return false;
                }
            } else {
                throw new UnsupportedOperationException("Cannot handle root joint type: " + rootJoint.getClass().getSimpleName());
            }
        }
        for (JointReadOnly joint : robot.getAllJoints()) {
            SixDoFJointReadOnly sixDoFJoint;
            OneDoFJointReadOnly oneDoFJoint;
            if (rootJoint == joint || !(joint instanceof OneDoFJointReadOnly ? MCAPMujocoBasedRobotStateUpdater.findOneDoFJointConfigurationVariable(message, oneDoFJoint = (OneDoFJointReadOnly)joint) == null : joint instanceof SixDoFJointReadOnly && MCAPMujocoBasedRobotStateUpdater.findSixDoFJointConfigurationVariable(message, sixDoFJoint = (SixDoFJointReadOnly)joint) == null)) continue;
            return false;
        }
        return true;
    }

    public MCAPMujocoBasedRobotStateUpdater(Robot robot, YoMCAPMessage message) {
        SimFloatingJointBasics rootJoint = robot.getFloatingRootJoint();
        if (rootJoint != null) {
            if (rootJoint instanceof SixDoFJointBasics) {
                SixDoFJointBasics sixDoFJoint = (SixDoFJointBasics)rootJoint;
                YoPose3D pose = MCAPMujocoBasedRobotStateUpdater.findSixDoFJointConfigurationVariable(message, MUJOCO_ROOT_JOINT);
                YoFrameVectorPair velocity = MCAPMujocoBasedRobotStateUpdater.findSixDoFJointVelocityVariable(message, MUJOCO_ROOT_JOINT, (ReferenceFrame)sixDoFJoint.getFrameBeforeJoint(), (ReferenceFrame)sixDoFJoint.getFrameAfterJoint());
                YoFrameVectorPair acceleration = MCAPMujocoBasedRobotStateUpdater.findSixDoFJointAccelerationVariable(message, MUJOCO_ROOT_JOINT, (ReferenceFrame)sixDoFJoint.getFrameBeforeJoint(), (ReferenceFrame)sixDoFJoint.getFrameAfterJoint());
                if (pose != null) {
                    this.jointStateUpdaters.add(new SixDoFJointStateUpdater(sixDoFJoint, pose, velocity, acceleration));
                }
            } else {
                throw new UnsupportedOperationException("Cannot handle root joint type: " + rootJoint.getClass().getSimpleName());
            }
        }
        for (JointReadOnly joint : robot.getAllJoints()) {
            if (joint == rootJoint) continue;
            if (joint instanceof OneDoFJointBasics) {
                OneDoFJointBasics oneDoFJoint = (OneDoFJointBasics)joint;
                YoDouble q = MCAPMujocoBasedRobotStateUpdater.findOneDoFJointConfigurationVariable(message, (OneDoFJointReadOnly)oneDoFJoint);
                YoDouble qd = MCAPMujocoBasedRobotStateUpdater.findOneDoFJointVelocityVariable(message, (OneDoFJointReadOnly)oneDoFJoint);
                YoDouble qdd = MCAPMujocoBasedRobotStateUpdater.findOneDoFJointAccelerationVariable(message, (OneDoFJointReadOnly)oneDoFJoint);
                YoDouble tau = MCAPMujocoBasedRobotStateUpdater.findOneDoFJointTorqueVariable(message, (OneDoFJointReadOnly)oneDoFJoint);
                if (q == null) continue;
                this.jointStateUpdaters.add(new OneDoFJointStateUpdater(oneDoFJoint, q, qd, qdd, tau));
                continue;
            }
            if (!(joint instanceof SixDoFJointBasics)) continue;
            SixDoFJointBasics sixDoFJoint = (SixDoFJointBasics)joint;
            YoPose3D pose = MCAPMujocoBasedRobotStateUpdater.findSixDoFJointConfigurationVariable(message, (SixDoFJointReadOnly)sixDoFJoint);
            YoFrameVectorPair velocity = MCAPMujocoBasedRobotStateUpdater.findSixDoFJointVelocityVariable(message, (SixDoFJointReadOnly)sixDoFJoint);
            YoFrameVectorPair acceleration = MCAPMujocoBasedRobotStateUpdater.findSixDoFJointAccelerationVariable(message, (SixDoFJointReadOnly)sixDoFJoint);
            if (pose == null) continue;
            this.jointStateUpdaters.add(new SixDoFJointStateUpdater(sixDoFJoint, pose, velocity, acceleration));
        }
    }

    @Override
    public void updateRobotState() {
        for (Runnable jointStateUpdater : this.jointStateUpdaters) {
            jointStateUpdater.run();
        }
    }

    private static YoDouble findOneDoFJointConfigurationVariable(YoMCAPMessage message, OneDoFJointReadOnly joint) {
        return MCAPMujocoBasedRobotStateUpdater.findOneDoFJointConfigurationVariable(message, joint.getName());
    }

    private static YoDouble findOneDoFJointConfigurationVariable(YoMCAPMessage message, String jointName) {
        return (YoDouble)YoSearchTools.findVariable(variable -> {
            if (!(variable instanceof YoDouble)) {
                return false;
            }
            String varName = variable.getName();
            if (!varName.contains(jointName)) {
                return false;
            }
            varName = varName.replace(jointName, "").replace("_", "");
            return varName.equals("q");
        }, (YoVariableHolder)message.getRegistry());
    }

    private static YoDouble findOneDoFJointVelocityVariable(YoMCAPMessage message, OneDoFJointReadOnly joint) {
        return MCAPMujocoBasedRobotStateUpdater.findOneDoFJointVelocityVariable(message, joint.getName());
    }

    private static YoDouble findOneDoFJointVelocityVariable(YoMCAPMessage message, String jointName) {
        return (YoDouble)YoSearchTools.findVariable(variable -> {
            if (!(variable instanceof YoDouble)) {
                return false;
            }
            String varName = variable.getName();
            if (!varName.contains(jointName)) {
                return false;
            }
            varName = varName.replace(jointName, "").replace("_", "");
            return varName.equals("qd");
        }, (YoVariableHolder)message.getRegistry());
    }

    private static YoDouble findOneDoFJointAccelerationVariable(YoMCAPMessage message, OneDoFJointReadOnly joint) {
        return MCAPMujocoBasedRobotStateUpdater.findOneDoFJointAccelerationVariable(message, joint.getName());
    }

    private static YoDouble findOneDoFJointAccelerationVariable(YoMCAPMessage message, String jointName) {
        return (YoDouble)YoSearchTools.findVariable(variable -> {
            if (!(variable instanceof YoDouble)) {
                return false;
            }
            String varName = variable.getName();
            if (!varName.contains(jointName)) {
                return false;
            }
            varName = varName.replace(jointName, "").replace("_", "");
            return varName.equals("qdd");
        }, (YoVariableHolder)message.getRegistry());
    }

    private static YoDouble findOneDoFJointTorqueVariable(YoMCAPMessage message, OneDoFJointReadOnly joint) {
        return MCAPMujocoBasedRobotStateUpdater.findOneDoFJointTorqueVariable(message, joint.getName());
    }

    private static YoDouble findOneDoFJointTorqueVariable(YoMCAPMessage message, String jointName) {
        return (YoDouble)YoSearchTools.findVariable(variable -> {
            if (!(variable instanceof YoDouble)) {
                return false;
            }
            String varName = variable.getName();
            if (!varName.contains(jointName)) {
                return false;
            }
            varName = varName.replace(jointName, "").replace("_", "");
            return varName.equals("tau");
        }, (YoVariableHolder)message.getRegistry());
    }

    private static YoPose3D findSixDoFJointConfigurationVariable(YoMCAPMessage message, SixDoFJointReadOnly joint) {
        return MCAPMujocoBasedRobotStateUpdater.findSixDoFJointConfigurationVariable(message, joint.getName());
    }

    private static YoPose3D findSixDoFJointConfigurationVariable(YoMCAPMessage message, String jointName) {
        YoPoint3D position = MCAPMujocoBasedRobotStateUpdater.findPoint3D(vector -> {
            Object varName = vector.getNamePrefix() + vector.getNameSuffix();
            if (!((String)varName).contains(jointName)) {
                return false;
            }
            varName = ((String)varName).replace(jointName, "").replace("_", "");
            return ((String)varName).isBlank();
        }, (YoVariableHolder)message.getRegistry());
        YoQuaternion orientation = MCAPMujocoBasedRobotStateUpdater.findQuaternion(quaternion -> {
            Object varName = quaternion.getNamePrefix() + quaternion.getNameSuffix();
            if (!((String)varName).contains(jointName)) {
                return false;
            }
            return ((String)(varName = ((String)varName).replace(jointName, "").replace("_", ""))).isBlank() || ((String)varName).equals("q");
        }, (YoVariableHolder)message.getRegistry());
        if (position == null || orientation == null) {
            return null;
        }
        return new YoPose3D(position, orientation);
    }

    private static YoFrameVectorPair findSixDoFJointVelocityVariable(YoMCAPMessage message, SixDoFJointReadOnly joint) {
        return MCAPMujocoBasedRobotStateUpdater.findSixDoFJointVelocityVariable(message, joint.getName(), (ReferenceFrame)joint.getFrameBeforeJoint(), (ReferenceFrame)joint.getFrameAfterJoint());
    }

    private static YoFrameVectorPair findSixDoFJointVelocityVariable(YoMCAPMessage message, String jointName, ReferenceFrame frameBeforeJoint, ReferenceFrame frameAfterJoint) {
        YoVector3D linearVelocity = MCAPMujocoBasedRobotStateUpdater.findVector3D(vector -> {
            Object varName = vector.getNamePrefix() + vector.getNameSuffix();
            if (!((String)varName).contains(jointName)) {
                return false;
            }
            varName = ((String)varName).replace(jointName, "").replace("_", "");
            return ((String)varName).equals("d");
        }, (YoVariableHolder)message.getRegistry());
        YoVector3D angularVelocity = MCAPMujocoBasedRobotStateUpdater.findVector3D(vector -> {
            Object varName = vector.getNamePrefix() + vector.getNameSuffix();
            if (!((String)varName).contains(jointName)) {
                return false;
            }
            varName = ((String)varName).replace(jointName, "").replace("_", "");
            return ((String)varName).equals("w");
        }, (YoVariableHolder)message.getRegistry());
        if (linearVelocity == null || angularVelocity == null) {
            return null;
        }
        return new YoFrameVectorPair(new YoFrameVector3D(angularVelocity, frameAfterJoint), new YoFrameVector3D(linearVelocity, frameBeforeJoint));
    }

    private static YoFrameVectorPair findSixDoFJointAccelerationVariable(YoMCAPMessage message, SixDoFJointReadOnly joint) {
        return MCAPMujocoBasedRobotStateUpdater.findSixDoFJointAccelerationVariable(message, joint.getName(), (ReferenceFrame)joint.getFrameBeforeJoint(), (ReferenceFrame)joint.getFrameAfterJoint());
    }

    private static YoFrameVectorPair findSixDoFJointAccelerationVariable(YoMCAPMessage message, String jointName, ReferenceFrame frameBeforeJoint, ReferenceFrame frameAfterJoint) {
        YoVector3D linearAcceleration = MCAPMujocoBasedRobotStateUpdater.findVector3D(vector -> {
            Object varName = vector.getNamePrefix() + vector.getNameSuffix();
            if (!((String)varName).contains(jointName)) {
                return false;
            }
            varName = ((String)varName).replace(jointName, "").replace("_", "");
            return ((String)varName).equals("dd");
        }, (YoVariableHolder)message.getRegistry());
        YoVector3D angularAcceleration = MCAPMujocoBasedRobotStateUpdater.findVector3D(vector -> {
            Object varName = vector.getNamePrefix() + vector.getNameSuffix();
            if (!((String)varName).contains(jointName)) {
                return false;
            }
            varName = ((String)varName).replace(jointName, "").replace("_", "");
            return ((String)varName).equals("wd");
        }, (YoVariableHolder)message.getRegistry());
        if (linearAcceleration == null || angularAcceleration == null) {
            return null;
        }
        return new YoFrameVectorPair(new YoFrameVector3D(angularAcceleration, frameAfterJoint), new YoFrameVector3D(linearAcceleration, frameBeforeJoint));
    }

    public static YoPoint3D findPoint3D(Predicate<YoPoint3D> filter, YoVariableHolder yoVariableHolder) {
        List<YoPoint3D> yoPoint3Ds = MCAPMujocoBasedRobotStateUpdater.filterPoint3Ds(filter, yoVariableHolder);
        if (yoPoint3Ds.isEmpty()) {
            return null;
        }
        return yoPoint3Ds.get(0);
    }

    public static YoVector3D findVector3D(Predicate<YoVector3D> filter, YoVariableHolder yoVariableHolder) {
        List<YoVector3D> yoVector3Ds = MCAPMujocoBasedRobotStateUpdater.filterVector3Ds(filter, yoVariableHolder);
        if (yoVector3Ds.isEmpty()) {
            return null;
        }
        return yoVector3Ds.get(0);
    }

    public static List<YoPoint3D> filterPoint3Ds(Predicate<YoPoint3D> filter, YoVariableHolder yoVariableHolder) {
        return MCAPMujocoBasedRobotStateUpdater.filterTuple3Ds(filter, yoVariableHolder, YoPoint3D::new);
    }

    public static List<YoVector3D> filterVector3Ds(Predicate<YoVector3D> filter, YoVariableHolder yoVariableHolder) {
        return MCAPMujocoBasedRobotStateUpdater.filterTuple3Ds(filter, yoVariableHolder, YoVector3D::new);
    }

    public static YoQuaternion findQuaternion(Predicate<YoQuaternion> filter, YoVariableHolder yoVariableHolder) {
        List<YoQuaternion> yoQuaternions = MCAPMujocoBasedRobotStateUpdater.filterQuaternions(filter, yoVariableHolder);
        if (yoQuaternions.isEmpty()) {
            return null;
        }
        return yoQuaternions.get(0);
    }

    private static <T extends YoTuple3D> List<T> filterTuple3Ds(Predicate<T> filter, YoVariableHolder yoVariableHolder, YoTuple3DBuilder<T> builder) {
        ArrayList<T> yoTuple3Ds = new ArrayList<T>();
        List xComponents = YoSearchTools.filterVariables(variable -> variable instanceof YoDouble && variable.getName().toLowerCase().contains("x"), (YoVariableHolder)yoVariableHolder);
        for (YoVariable xComponent : xComponents) {
            String xComponentName = xComponent.getName();
            String xComponentNameLC = xComponentName.toLowerCase();
            int xIndex = -1;
            while ((xIndex = xComponentNameLC.indexOf(120, xIndex + 1)) > -1) {
                T yoTuple3D;
                String zComponentName;
                YoVariable zComponent;
                String suffix;
                boolean isIdentifierUpperCase;
                String prefix = xIndex == 0 ? "" : xComponentName.substring(0, xIndex);
                String yComponentName = prefix + ((isIdentifierUpperCase = Character.isUpperCase(xComponentName.charAt(xIndex))) ? "Y" : "y") + (suffix = xIndex == xComponentName.length() - 1 ? "" : xComponentName.substring(xIndex + 1));
                YoVariable yComponent = yoVariableHolder.findVariable(yComponentName);
                if (!(yComponent instanceof YoDouble) || !((zComponent = yoVariableHolder.findVariable(zComponentName = prefix + (isIdentifierUpperCase ? "Z" : "z") + suffix)) instanceof YoDouble) || !filter.test(yoTuple3D = builder.build((YoDouble)xComponent, (YoDouble)yComponent, (YoDouble)zComponent))) continue;
                yoTuple3Ds.add(yoTuple3D);
            }
        }
        return yoTuple3Ds;
    }

    public static List<YoQuaternion> filterQuaternions(Predicate<YoQuaternion> filter, YoVariableHolder yoVariableHolder) {
        ArrayList<YoQuaternion> yoQuaternions = new ArrayList<YoQuaternion>();
        List sComponents = YoSearchTools.filterVariables(variable -> variable instanceof YoDouble && variable.getName().toLowerCase().contains("x"), (YoVariableHolder)yoVariableHolder);
        for (YoVariable xComponent : sComponents) {
            String xComponentName = xComponent.getName();
            String xComponentNameLC = xComponentName.toLowerCase();
            int wIndex = -1;
            while ((wIndex = xComponentNameLC.indexOf(120, wIndex + 1)) > -1) {
                YoQuaternion yoQuaternion;
                String sComponentName;
                YoVariable sComponent;
                String zComponentName;
                YoVariable zComponent;
                String suffix;
                boolean isIdentifierUpperCase;
                String prefix = wIndex == 0 ? "" : xComponentName.substring(0, wIndex);
                String yComponentName = prefix + ((isIdentifierUpperCase = Character.isUpperCase(xComponentName.charAt(wIndex))) ? "Y" : "y") + (suffix = wIndex == xComponentName.length() - 1 ? "" : xComponentName.substring(wIndex + 1));
                YoVariable yComponent = yoVariableHolder.findVariable(yComponentName);
                if (!(yComponent instanceof YoDouble) || !((zComponent = yoVariableHolder.findVariable(zComponentName = prefix + (isIdentifierUpperCase ? "Z" : "z") + suffix)) instanceof YoDouble) || !((sComponent = yoVariableHolder.findVariable(sComponentName = prefix + (isIdentifierUpperCase ? "S" : "s") + suffix)) instanceof YoDouble) && !((sComponent = yoVariableHolder.findVariable(sComponentName = prefix + (isIdentifierUpperCase ? "W" : "w") + suffix)) instanceof YoDouble) || !filter.test(yoQuaternion = new YoQuaternion((YoDouble)xComponent, (YoDouble)yComponent, (YoDouble)zComponent, (YoDouble)sComponent))) continue;
                yoQuaternions.add(yoQuaternion);
            }
        }
        return yoQuaternions;
    }

    private record YoFrameVectorPair(YoFrameVector3D angularPart, YoFrameVector3D linearPart) {
    }

    private static class SixDoFJointStateUpdater
    implements Runnable {
        private final SixDoFJointBasics joint;
        private final YoPose3D pose;
        private final YoFrameVectorPair velocity;
        private final YoFrameVectorPair acceleration;
        private final Vector3D tempAcceleration = new Vector3D();

        public SixDoFJointStateUpdater(SixDoFJointBasics joint, YoPose3D pose, YoFrameVectorPair velocity, YoFrameVectorPair acceleration) {
            this.joint = joint;
            this.pose = pose;
            this.velocity = velocity;
            this.acceleration = acceleration;
        }

        @Override
        public void run() {
            this.joint.getJointPose().set((Pose3DReadOnly)this.pose);
            YoQuaternion orientation = this.pose.getOrientation();
            if (this.velocity != null) {
                if (this.velocity.angularPart.getReferenceFrame() == this.joint.getFrameAfterJoint()) {
                    this.joint.getJointTwist().getAngularPart().set((FrameTuple3DReadOnly)this.velocity.angularPart);
                } else if (this.velocity.angularPart.getReferenceFrame() == this.joint.getFrameBeforeJoint()) {
                    orientation.inverseTransform((Tuple3DReadOnly)this.velocity.angularPart, (Tuple3DBasics)this.joint.getJointTwist().getAngularPart());
                } else {
                    throw new UnsupportedOperationException("Cannot handle angular velocity expressed in frame: " + this.velocity.angularPart.getReferenceFrame());
                }
                if (this.velocity.linearPart.getReferenceFrame() == this.joint.getFrameAfterJoint()) {
                    this.joint.getJointTwist().getLinearPart().set((FrameTuple3DReadOnly)this.velocity.linearPart);
                } else if (this.velocity.linearPart.getReferenceFrame() == this.joint.getFrameBeforeJoint()) {
                    orientation.inverseTransform((Tuple3DReadOnly)this.velocity.linearPart, (Tuple3DBasics)this.joint.getJointTwist().getLinearPart());
                } else {
                    throw new UnsupportedOperationException("Cannot handle linear velocity expressed in frame: " + this.velocity.linearPart.getReferenceFrame());
                }
            }
            if (this.acceleration != null) {
                if (this.acceleration.angularPart.getReferenceFrame() == this.joint.getFrameAfterJoint()) {
                    this.joint.getJointAcceleration().getAngularPart().set((FrameTuple3DReadOnly)this.acceleration.angularPart);
                } else if (this.acceleration.angularPart.getReferenceFrame() == this.joint.getFrameBeforeJoint()) {
                    orientation.inverseTransform((Tuple3DReadOnly)this.acceleration.angularPart, (Tuple3DBasics)this.joint.getJointAcceleration().getAngularPart());
                } else {
                    throw new UnsupportedOperationException("Cannot handle angular acceleration expressed in frame: " + this.acceleration.angularPart.getReferenceFrame());
                }
                if (this.acceleration.linearPart.getReferenceFrame() == this.joint.getFrameAfterJoint()) {
                    this.joint.getJointAcceleration().getLinearPart().set((FrameTuple3DReadOnly)this.acceleration.linearPart);
                } else if (this.acceleration.linearPart.getReferenceFrame() == this.joint.getFrameBeforeJoint()) {
                    orientation.inverseTransform((Tuple3DReadOnly)this.acceleration.linearPart, (Tuple3DBasics)this.tempAcceleration);
                    MecanoTools.addCrossToVector((Tuple3DReadOnly)this.joint.getJointTwist().getLinearPart(), (Tuple3DReadOnly)this.joint.getJointTwist().getAngularPart(), (Vector3DBasics)this.tempAcceleration);
                    this.joint.getJointAcceleration().getLinearPart().set((Tuple3DReadOnly)this.tempAcceleration);
                } else {
                    throw new UnsupportedOperationException("Cannot handle linear acceleration expressed in frame: " + this.acceleration.linearPart.getReferenceFrame());
                }
            }
        }
    }

    public static class OneDoFJointStateUpdater
    implements Runnable {
        private final OneDoFJointBasics joint;
        private final YoDouble q;
        private final YoDouble qd;
        private final YoDouble qdd;
        private final YoDouble tau;

        public OneDoFJointStateUpdater(OneDoFJointBasics joint, YoDouble q, YoDouble qd, YoDouble qdd, YoDouble tau) {
            this.joint = joint;
            this.q = q;
            this.qd = qd;
            this.qdd = qdd;
            this.tau = tau;
        }

        @Override
        public void run() {
            this.joint.setQ(this.q.getValue());
            if (this.qd != null) {
                this.joint.setQd(this.qd.getValue());
            }
            if (this.qdd != null) {
                this.joint.setQdd(this.qdd.getValue());
            }
            if (this.tau != null) {
                this.joint.setTau(this.tau.getValue());
            }
        }
    }

    private static interface YoTuple3DBuilder<T extends YoTuple3D> {
        public T build(YoDouble var1, YoDouble var2, YoDouble var3);
    }
}

