/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.io.FileOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.mcap.output.MCAPDataOutput;
import us.ihmc.scs2.session.mcap.specs.MCAP;
import us.ihmc.scs2.session.mcap.specs.records.Chunk;
import us.ihmc.scs2.session.mcap.specs.records.DataEnd;
import us.ihmc.scs2.session.mcap.specs.records.MCAPSummaryBuilder;
import us.ihmc.scs2.session.mcap.specs.records.Magic;
import us.ihmc.scs2.session.mcap.specs.records.Message;
import us.ihmc.scs2.session.mcap.specs.records.MutableChunk;
import us.ihmc.scs2.session.mcap.specs.records.MutableRecord;
import us.ihmc.scs2.session.mcap.specs.records.Opcode;
import us.ihmc.scs2.session.mcap.specs.records.Record;
import us.ihmc.scs2.session.mcap.specs.records.Records;

public class MCAPLogRepacker {
    public void repack(MCAP mcap, FileOutputStream outputStream, ProgressConsumer progressConsumer) {
        this.repack(mcap, 0L, Long.MAX_VALUE, outputStream, progressConsumer);
    }

    public void repack(MCAP mcap, long chunkMinDuration, long chunkMaxDuration, FileOutputStream outputStream, ProgressConsumer progressConsumer) {
        MCAPDataOutput dataOutput = MCAPDataOutput.wrap(outputStream.getChannel());
        dataOutput.putBytes(Magic.MAGIC_BYTES);
        AbstractList recordsForNextChunk = null;
        MCAPSummaryBuilder summaryBuilder = new MCAPSummaryBuilder();
        block9: for (int i = 0; i < mcap.records().size(); ++i) {
            Record record = mcap.records().get(i);
            if (progressConsumer != null) {
                progressConsumer.progress((double)i / (double)(mcap.records().size() - 1));
            }
            switch (record.op()) {
                case CHUNK_INDEX: 
                case MESSAGE_INDEX: 
                case ATTACHMENT_INDEX: 
                case METADATA_INDEX: 
                case FOOTER: {
                    continue block9;
                }
                case HEADER: {
                    record.write(dataOutput);
                    continue block9;
                }
                case DATA_END: {
                    new MutableRecord(new DataEnd(0L)).write(dataOutput);
                    summaryBuilder.writeSummary(dataOutput);
                    continue block9;
                }
                case SCHEMA: 
                case CHANNEL: {
                    summaryBuilder.update(record);
                    continue block9;
                }
                case CHUNK: {
                    Chunk chunk = (Chunk)record.body();
                    Records records = new Records(chunk.records());
                    if (recordsForNextChunk != null) {
                        records.addAll(recordsForNextChunk);
                        recordsForNextChunk = null;
                    }
                    records.sortByTimestamp();
                    if (!records.containsMessages()) {
                        recordsForNextChunk = records;
                        continue block9;
                    }
                    if (records.getMessageEndTime() - records.getMessageStartTime() < chunkMinDuration) {
                        recordsForNextChunk = records;
                        continue block9;
                    }
                    if (records.getMessageEndTime() - records.getMessageStartTime() > chunkMaxDuration) {
                        long splitTime = records.getMessageStartTime() + chunkMaxDuration;
                        int splitIndex = records.indexOf(r -> r.op() == Opcode.MESSAGE && ((Message)r.body()).logTime() > splitTime);
                        recordsForNextChunk = new ArrayList(records.subList(splitIndex, records.size()));
                        records = new Records(records.subList(0, splitIndex));
                    }
                    MutableChunk repackedChunk = new MutableChunk();
                    repackedChunk.setRecords(records);
                    repackedChunk.setCompression(chunk.compression());
                    MutableRecord repackedChunkRecord = new MutableRecord(repackedChunk);
                    long chunkOffset = dataOutput.position();
                    List<MutableRecord> repackedMessageIndexRecords = repackedChunk.records().generateMessageIndexList().stream().map(MutableRecord::new).toList();
                    summaryBuilder.update(repackedChunkRecord);
                    summaryBuilder.update(repackedChunkRecord.generateChunkIndexRecord(chunkOffset, repackedMessageIndexRecords));
                    repackedChunkRecord.write(dataOutput, true);
                    repackedMessageIndexRecords.forEach(r -> r.write(dataOutput, true));
                    continue block9;
                }
                case ATTACHMENT: {
                    long attachmentOffset = dataOutput.position();
                    record.write(dataOutput, true);
                    summaryBuilder.update(record);
                    summaryBuilder.update(record.generateAttachmentIndexRecord(attachmentOffset));
                    continue block9;
                }
                case METADATA: {
                    long metadataOffset = dataOutput.position();
                    record.write(dataOutput, true);
                    summaryBuilder.update(record);
                    summaryBuilder.update(record.generateMetadataIndexRecord(metadataOffset));
                    continue block9;
                }
            }
        }
        dataOutput.putBytes(Magic.MAGIC_BYTES);
        dataOutput.close();
    }
}

