/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap.input;

import com.github.luben.zstd.ZstdDecompressCtx;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import us.ihmc.scs2.session.mcap.LZ4FrameDecoder;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;

public class MCAPBufferedFileChannelInput
implements MCAPDataInput {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final boolean DEFAULT_USE_DIRECT_BUFFER = false;
    private long _pos;
    private final ByteBuffer readingBuffer;
    private final FileChannel fileChannel;

    public MCAPBufferedFileChannelInput(FileChannel fileChannel) {
        this(fileChannel, 8192, false);
    }

    public MCAPBufferedFileChannelInput(FileChannel fileChannel, int readingBufferSize, boolean useDirectBuffer) {
        this.fileChannel = fileChannel;
        this.readingBuffer = useDirectBuffer ? ByteBuffer.allocateDirect(readingBufferSize) : ByteBuffer.allocate(readingBufferSize);
        this.readingBuffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            this._pos = fileChannel.position();
            fileChannel.read(this.readingBuffer, this._pos);
            this.readingBuffer.flip();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void position(long newPosition) {
        if (newPosition == this.position()) {
            return;
        }
        try {
            if (newPosition > this._pos && newPosition < this._pos + (long)this.readingBuffer.limit()) {
                this.readingBuffer.position((int)(newPosition - this._pos));
                return;
            }
            this._pos = newPosition;
            this.readingBuffer.clear();
            this.fileChannel.read(this.readingBuffer, this._pos);
            this.readingBuffer.flip();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long position() {
        return this._pos + (long)this.readingBuffer.position();
    }

    @Override
    public long size() {
        try {
            return this.fileChannel.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getLong() {
        if (this.readingBuffer.remaining() < 8) {
            this.fillBuffer();
        }
        return this.readingBuffer.getLong();
    }

    @Override
    public int getInt() {
        if (this.readingBuffer.remaining() < 4) {
            this.fillBuffer();
        }
        return this.readingBuffer.getInt();
    }

    @Override
    public short getShort() {
        if (this.readingBuffer.remaining() < 2) {
            this.fillBuffer();
        }
        return this.readingBuffer.getShort();
    }

    @Override
    public byte getByte() {
        if (this.readingBuffer.remaining() < 1) {
            this.fillBuffer();
        }
        return this.readingBuffer.get();
    }

    @Override
    public void getBytes(byte[] bytes) {
        int length;
        int remaining = length = bytes.length;
        if (this.size() - this.position() < (long)length) {
            throw new IndexOutOfBoundsException("End of file reached. Requested: " + length + ", remaining: " + (this.size() - this.position()) + ", position: " + this.position() + ", size: " + this.size());
        }
        while (remaining > 0) {
            if (this.readingBuffer.remaining() < remaining) {
                int toRead = this.readingBuffer.remaining();
                this.readingBuffer.get(bytes, length - remaining, toRead);
                remaining -= toRead;
                this.fillBuffer();
                continue;
            }
            this.readingBuffer.get(bytes, length - remaining, remaining);
            remaining = 0;
        }
    }

    @Override
    public byte[] getBytes(long offset, int length) {
        byte[] bytes = new byte[length];
        try {
            if (offset >= this._pos && offset + (long)length < this._pos + (long)this.readingBuffer.limit()) {
                this.readingBuffer.get((int)(offset - this._pos), bytes);
            } else {
                this.fileChannel.read(ByteBuffer.wrap(bytes), offset);
            }
            return bytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteBuffer getByteBuffer(long offset, int length, boolean direct) {
        try {
            ByteBuffer buffer = direct ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.fileChannel.read(buffer, offset);
            buffer.flip();
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteBuffer getDecompressedByteBuffer(long offset, int compressedLength, int uncompressedLength, MCAPDataInput.Compression compression, boolean direct) {
        ByteBuffer decompressedBuffer;
        if (compression == MCAPDataInput.Compression.NONE) {
            return this.getByteBuffer(offset, uncompressedLength, direct);
        }
        ByteBuffer compressedBuffer = this.getByteBuffer(offset, compressedLength, compression == MCAPDataInput.Compression.ZSTD);
        if (compression == MCAPDataInput.Compression.LZ4) {
            LZ4FrameDecoder lz4FrameDecoder = new LZ4FrameDecoder();
            decompressedBuffer = direct ? ByteBuffer.allocateDirect(uncompressedLength) : ByteBuffer.allocate(uncompressedLength);
            lz4FrameDecoder.decode(compressedBuffer, 0, compressedLength, decompressedBuffer, 0);
        } else if (compression == MCAPDataInput.Compression.ZSTD) {
            try (ZstdDecompressCtx zstdDecompressCtx = new ZstdDecompressCtx();){
                decompressedBuffer = zstdDecompressCtx.decompress(compressedBuffer, uncompressedLength);
            }
        } else {
            throw new IllegalArgumentException("Unsupported compression: " + compression);
        }
        decompressedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return decompressedBuffer;
    }

    private void fillBuffer() {
        try {
            long fileReadingPosition = this._pos + (long)this.readingBuffer.limit();
            this.readingBuffer.compact();
            int bytesRead = this.fileChannel.read(this.readingBuffer, fileReadingPosition);
            this.readingBuffer.flip();
            this._pos = fileReadingPosition + (long)bytesRead - (long)this.readingBuffer.limit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    long _pos() {
        return this._pos;
    }

    ByteBuffer getReadingBuffer() {
        return this.readingBuffer;
    }

    public String toString() {
        return "MCAPBufferedFileChannelInput{readingBuffer=" + this.readingBuffer + ", fileChannel=" + this.fileChannel + "}";
    }
}

