/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.mcap.MCAP;
import us.ihmc.scs2.session.mcap.MCAPSchema;
import us.ihmc.scs2.session.mcap.omgidl_parser.IDLBaseListener;
import us.ihmc.scs2.session.mcap.omgidl_parser.IDLLexer;
import us.ihmc.scs2.session.mcap.omgidl_parser.IDLParser;

public class OMGIDLSchemaParser {
    public static MCAPSchema loadSchema(MCAP.Schema mcapSchema) throws IOException {
        return OMGIDLSchemaParser.loadSchema(mcapSchema.name(), mcapSchema.id(), (InputStream)new ByteBufferBackedInputStream(mcapSchema.data()));
    }

    public static MCAPSchema loadSchema(String name, int id, byte[] data) throws IOException {
        return OMGIDLSchemaParser.loadSchema(name, id, new ByteArrayInputStream(data));
    }

    public static MCAPSchema loadSchema(String name, int id, InputStream is) throws IOException {
        MCAPSchema schema = new MCAPSchema(name, id, new ArrayList<MCAPSchema.MCAPSchemaField>(), new HashMap<String, MCAPSchema>());
        CharStream bytesAsChar = CharStreams.fromStream((InputStream)is);
        IDLLexer lexer = new IDLLexer(bytesAsChar);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        IDLParser parser = new IDLParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        IDLParser.SpecificationContext tree = parser.specification();
        SchemaCreatorListener schemaCreatorListener = new SchemaCreatorListener(schema);
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)schemaCreatorListener, (ParseTree)tree);
        return schema;
    }

    private static class SchemaCreatorListener
    extends IDLBaseListener {
        private final MCAPSchema rootSchema;
        private MCAPSchema currentSchema = null;
        private MCAPSchema previousSchema = null;
        private final MemberInfo currentMemberInfo = new MemberInfo();

        public SchemaCreatorListener(MCAPSchema schema) {
            this.rootSchema = schema;
            this.currentSchema = schema;
        }

        @Override
        public void exitScoped_name(IDLParser.Scoped_nameContext ctx) {
            this.currentMemberInfo.type = ctx.ID(0).getText();
            this.currentMemberInfo.isComplexType = true;
        }

        @Override
        public void exitConst_decl(IDLParser.Const_declContext ctx) {
            MCAPSchema.MCAPSchemaField newField = new MCAPSchema.MCAPSchemaField(ctx.identifier().getText(), ctx.const_type().getText(), false, false, -1, false);
            newField.setDefaultValue(ctx.const_exp().getText());
            this.currentSchema.getStaticFields().add(newField);
        }

        @Override
        public void exitBase_type_spec(IDLParser.Base_type_specContext ctx) {
            this.currentMemberInfo.type = ctx.getText();
        }

        @Override
        public void exitSimple_declarator(IDLParser.Simple_declaratorContext ctx) {
            this.currentMemberInfo.name = ctx.ID().getText();
        }

        @Override
        public void enterStruct_type(IDLParser.Struct_typeContext ctx) {
            Object structName = ctx.identifier().getText();
            if (ctx.scoped_name() != null) {
                structName = (String)structName + ctx.DOUBLE_COLON().getText() + ctx.scoped_name().getText();
            }
            if (Objects.equals(this.rootSchema.getName(), structName)) {
                this.previousSchema = this.currentSchema;
                this.currentSchema = this.rootSchema;
            } else {
                MCAPSchema newCurrentSchema = new MCAPSchema((String)structName, 0);
                this.currentSchema.getSubSchemaMap().put((String)structName, newCurrentSchema);
                this.previousSchema = this.currentSchema;
                this.currentSchema = newCurrentSchema;
            }
        }

        @Override
        public void exitStruct_type(IDLParser.Struct_typeContext ctx) {
            this.currentSchema = this.previousSchema;
            this.previousSchema = null;
        }

        @Override
        public void exitMember(IDLParser.MemberContext ctx) {
            assert (this.currentMemberInfo.type != null) : String.format("Got a null member type for %s", ctx.type_spec().getText());
            assert (this.currentMemberInfo.name != null) : String.format("Got a null member name for %s", ctx.declarators().getText());
            MCAPSchema.MCAPSchemaField newField = new MCAPSchema.MCAPSchemaField(this.currentMemberInfo.name, this.currentMemberInfo.type, this.currentMemberInfo.isArray, this.currentMemberInfo.isSequence, this.currentMemberInfo.maxLength, this.currentMemberInfo.isComplexType);
            this.currentSchema.getFields().add(newField);
            this.currentMemberInfo.reset();
        }

        @Override
        public void exitSequence_type(IDLParser.Sequence_typeContext ctx) {
            if (ctx.positive_int_const() != null) {
                this.currentMemberInfo.maxLength = Integer.parseInt(ctx.positive_int_const().getText());
            } else {
                this.currentMemberInfo.maxLength = 255;
                LogTools.warn((String)"Unbounded sequences are not supported, limiting max length to 255");
            }
            this.currentMemberInfo.isSequence = true;
            this.currentMemberInfo.isComplexType = true;
        }

        @Override
        public void exitEnum_type(IDLParser.Enum_typeContext ctx) {
            String name = ctx.identifier().getText();
            MCAPSchema enumSchema = new MCAPSchema(name, -1, (String[])ctx.enumerator().stream().map(it -> it.identifier().ID().getText()).toArray(String[]::new));
            this.currentSchema.getSubSchemaMap().put(name, enumSchema);
        }

        @Override
        public void exitString_type(IDLParser.String_typeContext ctx) {
            this.currentMemberInfo.type = "string";
        }

        @Override
        public void exitArray_declarator(IDLParser.Array_declaratorContext ctx) {
            this.currentMemberInfo.name = ctx.ID().getText();
        }

        @Override
        public void exitFixed_array_size(IDLParser.Fixed_array_sizeContext ctx) {
            this.currentMemberInfo.maxLength = Integer.parseInt(ctx.positive_int_const().getText());
            this.currentMemberInfo.isComplexType = true;
            this.currentMemberInfo.isArray = true;
        }

        private static class MemberInfo {
            private String type;
            private String name;
            private int maxLength;
            private boolean isArray;
            private boolean isSequence;
            private boolean isEnum;
            private boolean isComplexType;
            private String[] enumConstants;

            public MemberInfo() {
                this.reset();
            }

            private void reset() {
                this.type = null;
                this.name = null;
                this.maxLength = -1;
                this.isArray = false;
                this.isSequence = false;
                this.isEnum = false;
                this.isComplexType = false;
                this.enumConstants = null;
            }

            public String toString() {
                return "MemberInfo{type='" + this.type + "', name='" + this.name + "', maxLength=" + this.maxLength + ", isArray=" + this.isArray + ", isSequence=" + this.isSequence + ", isEnum=" + this.isEnum + ", isComplexType=" + this.isComplexType + ", enumConstants=" + Arrays.toString(this.enumConstants) + "}";
            }
        }
    }
}

