/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import gnu.trove.list.array.TLongArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import us.ihmc.scs2.session.mcap.MCAP;
import us.ihmc.scs2.session.mcap.MCAPBufferedChunk;

public class MCAPMessageManager {
    private final TLongArrayList allMessageTimestamps = new TLongArrayList();
    private final List<MCAP.ChunkIndex> mcapChunkIndices = new ArrayList<MCAP.ChunkIndex>();
    private final MCAPBufferedChunk chunkBuffer;
    private MCAPBufferedChunk.ChunkBundle currentChunkBundle = null;
    private final long desiredLogDT;

    public MCAPMessageManager(MCAP mcap, MCAPBufferedChunk chunkBuffer, long desiredLogDT) {
        this.chunkBuffer = chunkBuffer;
        this.desiredLogDT = desiredLogDT;
        this.loadFromMCAP(mcap);
    }

    public long getTimestampAtIndex(int index) {
        return this.allMessageTimestamps.get(index);
    }

    public long getRelativeTimestampAtIndex(int index) {
        return this.allMessageTimestamps.get(index) - this.firstMessageTimestamp();
    }

    public int getIndexFromTimestamp(long timestamp) {
        int index = this.allMessageTimestamps.binarySearch(timestamp);
        if (index < 0) {
            index = -(index + 1);
        }
        return index;
    }

    public int getNumberOfEntries() {
        return this.allMessageTimestamps.size();
    }

    public void loadFromMCAP(MCAP mcap) {
        for (MCAP.Record record : mcap.records()) {
            if (record.op() == MCAP.Opcode.CHUNK_INDEX) {
                this.mcapChunkIndices.add((MCAP.ChunkIndex)record.body());
                continue;
            }
            if (record.op() != MCAP.Opcode.MESSAGE_INDEX) continue;
            MCAP.MessageIndex messageIndex = (MCAP.MessageIndex)record.body();
            for (MCAP.MessageIndex.MessageIndexEntry mcapEntry : messageIndex.messageIndexEntries()) {
                int insertion;
                long timestamp = MCAPMessageManager.round(mcapEntry.logTime(), this.desiredLogDT);
                if (this.allMessageTimestamps.isEmpty() || timestamp > this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1)) {
                    this.allMessageTimestamps.add(timestamp);
                    continue;
                }
                if (timestamp == this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1) || (insertion = this.allMessageTimestamps.binarySearch(timestamp)) >= 0) continue;
                this.allMessageTimestamps.insert(-insertion - 1, timestamp);
            }
        }
        this.mcapChunkIndices.sort(Comparator.comparingLong(chunkIndex -> MCAPMessageManager.round(chunkIndex.messageStartTime(), this.desiredLogDT)));
    }

    public long firstMessageTimestamp() {
        return MCAPMessageManager.round(this.mcapChunkIndices.get(0).messageStartTime(), this.desiredLogDT);
    }

    public long lastMessageTimestamp() {
        return MCAPMessageManager.round(this.mcapChunkIndices.get(this.mcapChunkIndices.size() - 1).messageEndTime(), this.desiredLogDT);
    }

    public long nextMessageTimestamp(long timestamp) {
        if (timestamp < this.allMessageTimestamps.get(0)) {
            return this.allMessageTimestamps.get(0);
        }
        if (timestamp >= this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1)) {
            return -1L;
        }
        int index = this.allMessageTimestamps.binarySearch(timestamp);
        index = index < 0 ? -(index + 1) + 1 : ++index;
        return this.allMessageTimestamps.get(index);
    }

    public long previousMessageTimestamp(long timestamp) {
        if (timestamp <= this.allMessageTimestamps.get(0)) {
            return -1L;
        }
        if (timestamp > this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1)) {
            return this.allMessageTimestamps.get(this.allMessageTimestamps.size() - 1);
        }
        int index = this.allMessageTimestamps.binarySearch(timestamp);
        index = index < 0 ? -(index + 1) : --index;
        return this.allMessageTimestamps.get(index);
    }

    public List<MCAP.Message> loadMessages(long timestamp) throws IOException {
        if (this.currentChunkBundle == null || timestamp < this.currentChunkBundle.startTime() || timestamp > this.currentChunkBundle.endTime()) {
            this.currentChunkBundle = this.chunkBuffer.getChunkBundle(timestamp);
            if (this.currentChunkBundle == null) {
                return Collections.emptyList();
            }
            this.currentChunkBundle.requestLoadChunkBundle(true);
        }
        if (this.currentChunkBundle.startTime() == timestamp) {
            MCAPBufferedChunk.ChunkBundle previous = this.currentChunkBundle.previous();
            if (previous == null) {
                return this.currentChunkBundle.getMessages(timestamp);
            }
            previous.requestLoadChunkBundle(true);
            return MCAPMessageManager.merge(previous.getMessages(timestamp), this.currentChunkBundle.getMessages(timestamp));
        }
        if (this.currentChunkBundle.endTime() == timestamp) {
            MCAPBufferedChunk.ChunkBundle next = this.currentChunkBundle.next();
            if (next == null) {
                return this.currentChunkBundle.getMessages(timestamp);
            }
            next.requestLoadChunkBundle(true);
            return MCAPMessageManager.merge(this.currentChunkBundle.getMessages(timestamp), next.getMessages(timestamp));
        }
        return this.currentChunkBundle.getMessages(timestamp);
    }

    private static <T> List<T> merge(List<T> listA, List<T> listB) {
        if (listA == null && listB == null) {
            return Collections.emptyList();
        }
        if (listA == null) {
            return listB;
        }
        if (listB == null) {
            return listA;
        }
        ArrayList<T> merged = new ArrayList<T>(listA.size() + listB.size());
        merged.addAll(listA);
        merged.addAll(listB);
        return merged;
    }

    public long getActiveChunkStartTimestamp() {
        if (this.currentChunkBundle == null) {
            return -1L;
        }
        return this.currentChunkBundle.startTime();
    }

    public long getActiveChunkEndTimestamp() {
        if (this.currentChunkBundle == null) {
            return -1L;
        }
        return this.currentChunkBundle.endTime();
    }

    static long round(long value, long step) {
        if (step <= 1L) {
            return value;
        }
        long floor = value / step * step;
        long ceil = floor + step;
        return value - floor < ceil - value ? floor : ceil;
    }
}

