/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.mcap.MCAP;
import us.ihmc.scs2.session.mcap.MCAPMessageManager;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;

public class MCAPBufferedChunk {
    private static final double ALLOWABLE_CHUNK_MEMORY_RATIO = 0.05;
    private final MCAP mcap;
    private final long desiredLogDT;
    private final int maxNumberOfChunksLoaded;
    private final ConcurrentLinkedQueue<ChunkBundle> loadedChunkBundles = new ConcurrentLinkedQueue();
    private final ChunkBundle[] chunkBundles;
    private final ExecutorService executorService = Executors.newFixedThreadPool(4, ThreadTools.createNamedDaemonThreadFactory((String)this.getClass().getSimpleName()));

    public MCAPBufferedChunk(MCAP mcap, long desiredLogDT) {
        this.mcap = mcap;
        this.desiredLogDT = desiredLogDT;
        int numberOfChunks = 0;
        long minChunkSize = Long.MAX_VALUE;
        long maxChunkSize = Long.MIN_VALUE;
        long totalChunkSize = 0L;
        ArrayList<MCAP.ChunkIndex> orderedChunkIndices = new ArrayList<MCAP.ChunkIndex>();
        for (MCAP.Record record : mcap.records()) {
            if (record.op() == MCAP.Opcode.CHUNK) {
                MCAP.Chunk chunk = (MCAP.Chunk)record.body();
                ++numberOfChunks;
                long chunkSize = chunk.recordsLength();
                minChunkSize = Math.min(minChunkSize, chunkSize);
                maxChunkSize = Math.max(maxChunkSize, chunkSize);
                totalChunkSize += chunkSize;
                continue;
            }
            if (record.op() != MCAP.Opcode.CHUNK_INDEX) continue;
            MCAP.ChunkIndex chunkIndex2 = (MCAP.ChunkIndex)record.body();
            orderedChunkIndices.add(chunkIndex2);
        }
        long averageChunkSize = totalChunkSize / (long)numberOfChunks;
        this.maxNumberOfChunksLoaded = (int)Math.ceil(0.05 * (double)Runtime.getRuntime().maxMemory() / (double)averageChunkSize);
        LogTools.info((String)"Chunk stats: [Average size: %d, min size: %d, max size: %d, total size: %d, quantity: %d], max memory: %d, max chunks loaded: %d".formatted(averageChunkSize, minChunkSize, maxChunkSize, totalChunkSize, numberOfChunks, Runtime.getRuntime().maxMemory(), this.maxNumberOfChunksLoaded));
        orderedChunkIndices.sort(Comparator.comparingLong(chunkIndex -> MCAPMessageManager.round(chunkIndex.messageStartTime(), desiredLogDT)));
        this.chunkBundles = new ChunkBundle[numberOfChunks];
        for (int i = 0; i < numberOfChunks; ++i) {
            this.chunkBundles[i] = new ChunkBundle(i, (MCAP.ChunkIndex)orderedChunkIndices.get(i));
        }
    }

    public ChunkBundle[] getChunkBundles() {
        return this.chunkBundles;
    }

    public ChunkBundle getChunkBundle(long logTime) {
        int chunkIndex = this.searchChunkBundle(logTime);
        if (chunkIndex < 0) {
            return null;
        }
        return this.chunkBundles[chunkIndex];
    }

    public void requestLoadChunk(long logTime, boolean wait) {
        ChunkBundle chunkBundle = this.getChunkBundle(logTime);
        if (chunkBundle != null) {
            chunkBundle.requestLoadChunkBundle(wait);
        }
    }

    public void preloadChunks(long startTime, long duration) {
        ChunkBundle chunkBundle = this.getChunkBundle(startTime);
        if (chunkBundle == null) {
            return;
        }
        int maxNumberOfChunksToLoad = this.maxNumberOfChunksLoaded / 2;
        chunkBundle.requestLoadChunkBundle(false);
        for (int numberOfChunksLoaded = 1; chunkBundle.endTime() < startTime + duration && numberOfChunksLoaded < maxNumberOfChunksToLoad && (chunkBundle = chunkBundle.next()) != null; ++numberOfChunksLoaded) {
            chunkBundle.requestLoadChunkBundle(false);
        }
    }

    public int getMaxNumberOfChunksLoaded() {
        return this.maxNumberOfChunksLoaded;
    }

    public int getNumberOfChunksLoaded() {
        return this.loadedChunkBundles.size();
    }

    private int searchChunkBundle(long timestamp) {
        if (this.chunkBundles.length == 0) {
            return -1;
        }
        int low = 0;
        int high = this.chunkBundles.length - 1;
        if (timestamp < this.chunkBundles[low].startTime()) {
            return -1;
        }
        if (timestamp > this.chunkBundles[high].endTime()) {
            return -1;
        }
        while (low <= high) {
            int mid = low + high >>> 1;
            ChunkBundle midVal = this.chunkBundles[mid];
            long midValStartTime = midVal.startTime();
            if (timestamp == midValStartTime) {
                return mid;
            }
            if (timestamp > midValStartTime) {
                if (timestamp <= midVal.endTime()) {
                    return mid;
                }
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -1;
    }

    public ChunkBundle getChunkBundle(int chunkIndex) {
        return this.chunkBundles[chunkIndex];
    }

    public int getNumberOfChunks() {
        return this.chunkBundles.length;
    }

    public class ChunkBundle {
        private final int index;
        private final MCAP.ChunkIndex chunkIndex;
        private MCAP.Records chunkRecords;
        private TLongObjectHashMap<List<MCAP.Message>> bundledMessages;
        private volatile CountDownLatch chunkLoadedLatch;
        private volatile CountDownLatch messagesLoadedLatch;
        private long lastLoadingRequestTime = Long.MIN_VALUE;

        public ChunkBundle(int index, MCAP.ChunkIndex chunkIndex) {
            this.index = index;
            this.chunkIndex = chunkIndex;
        }

        public MCAP.ChunkIndex getChunkIndex() {
            return this.chunkIndex;
        }

        public ChunkBundle next() {
            return this.index + 1 < MCAPBufferedChunk.this.chunkBundles.length ? MCAPBufferedChunk.this.chunkBundles[this.index + 1] : null;
        }

        public ChunkBundle previous() {
            return this.index > 0 ? MCAPBufferedChunk.this.chunkBundles[this.index - 1] : null;
        }

        private void freeUpChunkBundleSpots(int numberOfSpots) {
            while (MCAPBufferedChunk.this.loadedChunkBundles.size() > MCAPBufferedChunk.this.maxNumberOfChunksLoaded - numberOfSpots) {
                ChunkBundle oldestChunkBundle = null;
                for (ChunkBundle chunkBundle : MCAPBufferedChunk.this.loadedChunkBundles) {
                    if (oldestChunkBundle != null && chunkBundle.lastLoadingRequestTime >= oldestChunkBundle.lastLoadingRequestTime) continue;
                    oldestChunkBundle = chunkBundle;
                }
                if (oldestChunkBundle == null) {
                    throw new RuntimeException("Unexpected: no chunk bundle to unload");
                }
                oldestChunkBundle.unloadChunk();
            }
        }

        private void unloadChunk() {
            this.chunkRecords = null;
            this.bundledMessages = null;
            this.chunkLoadedLatch = null;
            this.messagesLoadedLatch = null;
            MCAPBufferedChunk.this.loadedChunkBundles.remove(this);
            this.lastLoadingRequestTime = Long.MIN_VALUE;
        }

        public void requestLoadChunkBundle(boolean wait) {
            this.requestLoadChunkBundle(wait, true, true);
        }

        public void requestLoadChunkBundle(boolean wait, boolean recordRequestTime, boolean createMessages) {
            if (recordRequestTime) {
                this.lastLoadingRequestTime = System.nanoTime();
            }
            if (this.chunkRecords != null) {
                if (createMessages && this.bundledMessages == null) {
                    try {
                        this.loadMessagesNow();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return;
            }
            if (this.chunkLoadedLatch == null) {
                this.chunkLoadedLatch = new CountDownLatch(1);
                this.freeUpChunkBundleSpots(1);
                Runnable loadingTask = () -> {
                    try {
                        this.loadChunkNow();
                        if (createMessages) {
                            this.loadMessagesNow();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.unloadChunk();
                    }
                    finally {
                        this.chunkLoadedLatch.countDown();
                        this.chunkLoadedLatch = null;
                    }
                };
                if (wait) {
                    loadingTask.run();
                } else {
                    MCAPBufferedChunk.this.executorService.submit(loadingTask);
                }
            }
            try {
                if (this.chunkLoadedLatch != null && wait) {
                    this.chunkLoadedLatch.await();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private void loadChunkNow() throws IOException {
            if (this.chunkRecords == null) {
                ByteBuffer chunkBuffer = MCAPBufferedChunk.this.mcap.getDataInput().getByteBuffer(this.chunkIndex.chunkOffset(), (int)this.chunkIndex.chunkLength(), true);
                this.chunkRecords = ((MCAP.Chunk)new MCAP.Record(MCAPDataInput.wrap(chunkBuffer), 0L).body()).records();
            }
            if (!MCAPBufferedChunk.this.loadedChunkBundles.contains(this)) {
                MCAPBufferedChunk.this.loadedChunkBundles.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadMessagesNow() throws IOException {
            if (this.bundledMessages != null) {
                return;
            }
            if (this.messagesLoadedLatch != null) {
                try {
                    this.messagesLoadedLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            this.messagesLoadedLatch = new CountDownLatch(1);
            try {
                for (MCAP.Record record : this.chunkRecords) {
                    MCAP.Message message;
                    ArrayList<MCAP.Message> messages;
                    if (record.op() != MCAP.Opcode.MESSAGE) continue;
                    if (this.bundledMessages == null) {
                        this.bundledMessages = new TLongObjectHashMap();
                    }
                    if ((messages = (ArrayList<MCAP.Message>)this.bundledMessages.get(MCAPMessageManager.round((message = (MCAP.Message)record.body()).logTime(), MCAPBufferedChunk.this.desiredLogDT))) == null) {
                        messages = new ArrayList<MCAP.Message>();
                        this.bundledMessages.put(MCAPMessageManager.round(message.logTime(), MCAPBufferedChunk.this.desiredLogDT), messages);
                    }
                    messages.add(message);
                }
            }
            finally {
                this.messagesLoadedLatch.countDown();
                this.messagesLoadedLatch = null;
            }
        }

        public MCAP.Records getChunkRecords() {
            return this.chunkRecords;
        }

        public long startTime() {
            return MCAPMessageManager.round(this.chunkIndex.messageStartTime(), MCAPBufferedChunk.this.desiredLogDT);
        }

        public long endTime() {
            return MCAPMessageManager.round(this.chunkIndex.messageEndTime(), MCAPBufferedChunk.this.desiredLogDT);
        }

        public List<MCAP.Message> getMessages(long logTime) {
            if (this.chunkRecords == null) {
                return null;
            }
            if (this.bundledMessages == null) {
                try {
                    this.loadMessagesNow();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return (List)this.bundledMessages.get(MCAPMessageManager.round(logTime, MCAPBufferedChunk.this.desiredLogDT));
        }
    }
}

