/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.scs2.session.mcap.input.MCAPDataInput;

public class MCAP {
    protected MCAPDataInput dataInput;
    private final Magic headerMagic;
    private final List<Record> records;
    private final Magic footerMagic;
    private Record footer;

    public MCAP(FileChannel fileChannel) {
        Record lastRecord;
        this.dataInput = MCAPDataInput.wrap(fileChannel);
        long currentPos = 0L;
        this.headerMagic = new Magic(this.dataInput, currentPos);
        currentPos += this.headerMagic.getElementLength();
        this.records = new ArrayList<Record>();
        do {
            if ((lastRecord = new Record(this.dataInput, currentPos)).getElementLength() < 0L) {
                throw new IllegalArgumentException("Invalid record length: " + lastRecord.getElementLength());
            }
            currentPos += lastRecord.getElementLength();
            this.records.add(lastRecord);
        } while (lastRecord.op() != Opcode.FOOTER);
        this.footerMagic = new Magic(this.dataInput, currentPos);
    }

    public MCAPDataInput getDataInput() {
        return this.dataInput;
    }

    public Magic headerMagic() {
        return this.headerMagic;
    }

    public List<Record> records() {
        return this.records;
    }

    public Magic footerMagic() {
        return this.footerMagic;
    }

    public Record footer() {
        if (this.footer == null) {
            this.footer = new Record(this.dataInput, MCAP.computeOffsetFooter(this.dataInput));
        }
        return this.footer;
    }

    public static long computeOffsetFooter(MCAPDataInput dataInput) {
        return dataInput.size() - 1L - 8L - 20L - 8L;
    }

    public static <T extends MCAPElement> List<T> parseList(MCAPDataInput dataInput, MCAPDataReader<T> elementParser) {
        return MCAP.parseList(dataInput, elementParser, dataInput.getUnsignedInt());
    }

    public static <T extends MCAPElement> List<T> parseList(MCAPDataInput dataInput, MCAPDataReader<T> elementParser, long length) {
        return MCAP.parseList(dataInput, elementParser, dataInput.position(), length);
    }

    public static <T extends MCAPElement> List<T> parseList(MCAPDataInput dataInput, MCAPDataReader<T> elementParser, long offset, long length) {
        return MCAP.parseList(dataInput, elementParser, offset, length, null);
    }

    public static <T extends MCAPElement> List<T> parseList(MCAPDataInput dataInput, MCAPDataReader<T> elementParser, long offset, long length, List<T> listToPack) {
        long position = offset;
        long limit = position + length;
        if (listToPack == null) {
            listToPack = new ArrayList<T>();
        }
        while (position < limit) {
            T parsed = elementParser.parse(dataInput, position);
            listToPack.add(parsed);
            position += parsed.getElementLength();
        }
        return listToPack;
    }

    private static String indent(String stringToIndent, int indent) {
        if (indent <= 0) {
            return stringToIndent;
        }
        String indentStr = "\t".repeat(indent);
        return indentStr + stringToIndent.replace("\n", "\n" + indentStr);
    }

    private static int checkPositiveInt(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " must be positive. Value: " + value);
        }
        return value;
    }

    private static long checkPositiveLong(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + " must be positive. Value: " + value);
        }
        return value;
    }

    private static void checkLength(long expectedLength, long actualLength) {
        if (actualLength != expectedLength) {
            throw new IllegalArgumentException("Unexpected length: expected= " + expectedLength + ", actual= " + actualLength);
        }
    }

    public static class Magic
    implements MCAPElement {
        public static final int MAGIC_SIZE = 8;
        public static final byte[] MAGIC_BYTES = new byte[]{-119, 77, 67, 65, 80, 48, 13, 10};
        private final byte[] magic;

        public Magic(MCAPDataInput dataInput, long elementPosition) {
            dataInput.position(elementPosition);
            this.magic = dataInput.getBytes(8);
            if (!Arrays.equals(this.magic, MAGIC_BYTES)) {
                throw new IllegalArgumentException("Invalid magic bytes: " + Arrays.toString(this.magic) + ". Expected: " + Arrays.toString(MAGIC_BYTES));
            }
        }

        @Override
        public long getElementLength() {
            return 8L;
        }

        public byte[] magic() {
            return this.magic;
        }

        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-magic = " + Arrays.toString(this.magic);
            return MCAP.indent(out, indent);
        }
    }

    public static class Record
    implements MCAPElement {
        public static final int RECORD_HEADER_LENGTH = 9;
        private final MCAPDataInput dataInput;
        private final Opcode op;
        private final long bodyLength;
        private final long bodyOffset;
        private WeakReference<Object> bodyRef;

        public Record(MCAPDataInput dataInput) {
            this(dataInput, dataInput.position());
        }

        public Record(MCAPDataInput dataInput, long elementPosition) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.op = Opcode.byId(dataInput.getUnsignedByte());
            this.bodyLength = MCAP.checkPositiveLong(dataInput.getLong(), "bodyLength");
            this.bodyOffset = dataInput.position();
            MCAP.checkLength(this.getElementLength(), (int)(this.bodyLength + 9L));
        }

        public Opcode op() {
            return this.op;
        }

        public long bodyLength() {
            return this.bodyLength;
        }

        public Object body() {
            Object body;
            byte[] byArray = body = this.bodyRef == null ? null : (byte[])this.bodyRef.get();
            if (body == null) {
                if (this.op == null) {
                    body = this.dataInput.getBytes(this.bodyOffset, (int)this.bodyLength);
                } else {
                    body = switch (this.op) {
                        default -> throw new IncompatibleClassChangeError();
                        case Opcode.MESSAGE -> new Message(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.METADATA_INDEX -> new MetadataIndex(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.CHUNK -> new Chunk(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.SCHEMA -> new Schema(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.CHUNK_INDEX -> new ChunkIndex(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.DATA_END -> new DataEnd(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.ATTACHMENT_INDEX -> new AttachmentIndex(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.STATISTICS -> new Statistics(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.MESSAGE_INDEX -> new MessageIndex(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.CHANNEL -> new Channel(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.METADATA -> new Metadata(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.ATTACHMENT -> new Attachment(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.HEADER -> new Header(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.FOOTER -> new Footer(this.dataInput, this.bodyOffset, this.bodyLength);
                        case Opcode.SUMMARY_OFFSET -> new SummaryOffset(this.dataInput, this.bodyOffset, this.bodyLength);
                    };
                }
                this.bodyRef = new WeakReference<byte[]>((byte[])body);
            }
            return body;
        }

        @Override
        public long getElementLength() {
            return 9L + this.bodyLength;
        }

        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-op = " + this.op;
            out = out + "\n\t-bodyLength = " + this.bodyLength;
            out = out + "\n\t-bodyOffset = " + this.bodyOffset;
            Object body = this.body();
            out = out + "\n\t-body = " + (String)(body == null ? "null" : "\n" + ((MCAPElement)body).toString(indent + 2));
            return MCAP.indent(out, indent);
        }
    }

    public static enum Opcode {
        HEADER(1L),
        FOOTER(2L),
        SCHEMA(3L),
        CHANNEL(4L),
        MESSAGE(5L),
        CHUNK(6L),
        MESSAGE_INDEX(7L),
        CHUNK_INDEX(8L),
        ATTACHMENT(9L),
        ATTACHMENT_INDEX(10L),
        STATISTICS(11L),
        METADATA(12L),
        METADATA_INDEX(13L),
        SUMMARY_OFFSET(14L),
        DATA_END(15L);

        private final long id;
        private static final TLongObjectHashMap<Opcode> byId;

        private Opcode(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static Opcode byId(long id) {
            return (Opcode)((Object)byId.get(id));
        }

        static {
            byId = new TLongObjectHashMap(15);
            for (Opcode e : Opcode.values()) {
                byId.put(e.id(), (Object)e);
            }
        }
    }

    public static interface MCAPDataReader<T extends MCAPElement> {
        public T parse(MCAPDataInput var1, long var2);
    }

    public static interface MCAPElement {
        public long getElementLength();

        default public String toString(int indent) {
            return MCAP.indent(this.toString(), indent);
        }
    }

    public static class ChunkIndex
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long elementLength;
        private final long messageStartTime;
        private final long messageEndTime;
        private final long chunkOffset;
        private final long chunkLength;
        private final long messageIndexOffsetsOffset;
        private final long messageIndexOffsetsLength;
        private WeakReference<MessageIndexOffsets> messageIndexOffsetsRef;
        private final long messageIndexLength;
        private final String compression;
        private final long compressedSize;
        private final long uncompressedSize;
        private WeakReference<Record> chunkRef;

        private ChunkIndex(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            this.elementLength = elementLength;
            dataInput.position(elementPosition);
            this.messageStartTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageStartTime");
            this.messageEndTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageEndTime");
            this.chunkOffset = MCAP.checkPositiveLong(dataInput.getLong(), "chunkOffset");
            this.chunkLength = MCAP.checkPositiveLong(dataInput.getLong(), "chunkLength");
            this.messageIndexOffsetsLength = dataInput.getUnsignedInt();
            this.messageIndexOffsetsOffset = dataInput.position();
            dataInput.skip(this.messageIndexOffsetsLength);
            this.messageIndexLength = MCAP.checkPositiveLong(dataInput.getLong(), "messageIndexLength");
            this.compression = dataInput.getString();
            this.compressedSize = MCAP.checkPositiveLong(dataInput.getLong(), "compressedSize");
            this.uncompressedSize = MCAP.checkPositiveLong(dataInput.getLong(), "uncompressedSize");
        }

        @Override
        public long getElementLength() {
            return this.elementLength;
        }

        public Record chunk() {
            Record chunk;
            Record record = chunk = this.chunkRef == null ? null : (Record)this.chunkRef.get();
            if (chunk == null) {
                chunk = new Record(this.dataInput, this.chunkOffset);
                this.chunkRef = new WeakReference<Record>(chunk);
            }
            return (Record)this.chunkRef.get();
        }

        public long messageStartTime() {
            return this.messageStartTime;
        }

        public long messageEndTime() {
            return this.messageEndTime;
        }

        public long chunkOffset() {
            return this.chunkOffset;
        }

        public long chunkLength() {
            return this.chunkLength;
        }

        public long messageIndexOffsetsLength() {
            return this.messageIndexOffsetsLength;
        }

        public MessageIndexOffsets messageIndexOffsets() {
            MessageIndexOffsets messageIndexOffsets;
            MessageIndexOffsets messageIndexOffsets2 = messageIndexOffsets = this.messageIndexOffsetsRef == null ? null : (MessageIndexOffsets)this.messageIndexOffsetsRef.get();
            if (messageIndexOffsets == null) {
                messageIndexOffsets = new MessageIndexOffsets(this.dataInput, this.messageIndexOffsetsOffset, this.messageIndexOffsetsLength);
                this.messageIndexOffsetsRef = new WeakReference<MessageIndexOffsets>(messageIndexOffsets);
            }
            return messageIndexOffsets;
        }

        public long messageIndexLength() {
            return this.messageIndexLength;
        }

        public String compression() {
            return this.compression;
        }

        public long compressedSize() {
            return this.compressedSize;
        }

        public long uncompressedSize() {
            return this.uncompressedSize;
        }

        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-messageStartTime = " + this.messageStartTime;
            out = out + "\n\t-messageEndTime = " + this.messageEndTime;
            out = out + "\n\t-chunkOffset = " + this.chunkOffset;
            out = out + "\n\t-chunkLength = " + this.chunkLength;
            out = out + "\n\t-messageIndexOffsetsLength = " + this.messageIndexOffsetsLength;
            out = out + "\n\t-messageIndexLength = " + this.messageIndexLength;
            out = out + "\n\t-compression = " + this.compression;
            out = out + "\n\t-compressedSize = " + this.compressedSize;
            out = out + "\n\t-uncompressedSize = " + this.uncompressedSize;
            return MCAP.indent(out, indent);
        }

        public static class MessageIndexOffsets
        implements MCAPElement {
            private final List<MessageIndexOffset> entries;
            private final long elementLength;

            public MessageIndexOffsets(MCAPDataInput dataInput, long elementPosition, long elementLength) {
                long remaining;
                MessageIndexOffset entry;
                this.elementLength = elementLength;
                this.entries = new ArrayList<MessageIndexOffset>();
                long currentPos = elementPosition;
                for (remaining = elementLength; remaining > 0L; remaining -= entry.getElementLength()) {
                    entry = new MessageIndexOffset(dataInput, currentPos);
                    this.entries.add(entry);
                    currentPos += entry.getElementLength();
                }
                if (remaining != 0L) {
                    throw new IllegalArgumentException("Invalid element length. Expected: " + elementLength + ", remaining: " + remaining + ", entries: " + this.entries.size());
                }
            }

            @Override
            public long getElementLength() {
                return this.elementLength;
            }

            public List<MessageIndexOffset> entries() {
                return this.entries;
            }

            public String toString() {
                return this.toString(0);
            }

            @Override
            public String toString(int indent) {
                String out = this.getClass().getSimpleName() + ":";
                out = out + "\n\t-entries = " + (String)(this.entries == null ? "null" : "\n" + EuclidCoreIOTools.getCollectionString((String)"\n", this.entries, e -> e.toString(indent + 1)));
                return MCAP.indent(out, indent);
            }
        }

        public static class MessageIndexOffset
        implements MCAPElement {
            private final int channelId;
            private final long offset;

            public MessageIndexOffset(MCAPDataInput dataInput, long elementPosition) {
                dataInput.position(elementPosition);
                this.channelId = dataInput.getUnsignedShort();
                this.offset = MCAP.checkPositiveLong(dataInput.getLong(), "offset");
            }

            @Override
            public long getElementLength() {
                return 10L;
            }

            public int channelId() {
                return this.channelId;
            }

            public long offset() {
                return this.offset;
            }

            public String toString() {
                return this.toString(0);
            }

            @Override
            public String toString(int indent) {
                String out = this.getClass().getSimpleName() + ":";
                out = out + "\n\t-channelId = " + this.channelId;
                out = out + "\n\t-offset = " + this.offset;
                return MCAP.indent(out, indent);
            }
        }
    }

    public static class Footer
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long ofsSummarySection;
        private final long ofsSummaryOffsetSection;
        private final long summaryCrc32;
        private Integer ofsSummaryCrc32Input;
        private Records summaryOffsetSection;
        private Records summarySection;
        private byte[] summaryCrc32Input;

        public Footer(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.ofsSummarySection = MCAP.checkPositiveLong(dataInput.getLong(), "ofsSummarySection");
            this.ofsSummaryOffsetSection = MCAP.checkPositiveLong(dataInput.getLong(), "ofsSummaryOffsetSection");
            this.summaryCrc32 = dataInput.getUnsignedInt();
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 20L;
        }

        public Records summarySection() {
            if (this.summarySection == null && this.ofsSummarySection != 0L) {
                long length = (this.ofsSummaryOffsetSection != 0L ? this.ofsSummaryOffsetSection : MCAP.computeOffsetFooter(this.dataInput)) - this.ofsSummarySection;
                this.summarySection = new Records(this.dataInput, this.ofsSummarySection, (int)length);
            }
            return this.summarySection;
        }

        public Records summaryOffsetSection() {
            if (this.summaryOffsetSection == null && this.ofsSummaryOffsetSection != 0L) {
                this.summaryOffsetSection = new Records(this.dataInput, this.ofsSummaryOffsetSection, (int)(MCAP.computeOffsetFooter(this.dataInput) - this.ofsSummaryOffsetSection));
            }
            return this.summaryOffsetSection;
        }

        public Integer ofsSummaryCrc32Input() {
            if (this.ofsSummaryCrc32Input == null) {
                this.ofsSummaryCrc32Input = (int)(this.ofsSummarySection() != 0L ? this.ofsSummarySection() : MCAP.computeOffsetFooter(this.dataInput));
            }
            return this.ofsSummaryCrc32Input;
        }

        public byte[] summaryCrc32Input() {
            if (this.summaryCrc32Input == null) {
                long length = this.dataInput.size() - (long)this.ofsSummaryCrc32Input().intValue() - 8L - 4L;
                this.summaryCrc32Input = this.dataInput.getBytes(this.ofsSummaryCrc32Input().intValue(), (int)length);
            }
            return this.summaryCrc32Input;
        }

        public long ofsSummarySection() {
            return this.ofsSummarySection;
        }

        public long ofsSummaryOffsetSection() {
            return this.ofsSummaryOffsetSection;
        }

        public long summaryCrc32() {
            return this.summaryCrc32;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-ofsSummarySection = " + this.ofsSummarySection;
            out = out + "\n\t-ofsSummaryOffsetSection = " + this.ofsSummaryOffsetSection;
            out = out + "\n\t-summaryCrc32 = " + this.summaryCrc32;
            return out;
        }
    }

    public static class Records
    extends ArrayList<Record> {
        public Records(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            MCAP.parseList(dataInput, Record::new, elementPosition, elementLength, this);
        }

        @Override
        public String toString() {
            return this.toString(0);
        }

        public String toString(int indent) {
            if (this.isEmpty()) {
                return MCAP.indent(this.getClass().getSimpleName() + ": []", indent);
            }
            String out = this.getClass().getSimpleName() + "[\n";
            out = out + EuclidCoreIOTools.getCollectionString((String)"\n", (Collection)this, r -> r.toString(indent + 1));
            return MCAP.indent(out, indent);
        }
    }

    public static class MetadataIndex
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long metadataOffset;
        private final long metadataLength;
        private final String name;
        private WeakReference<Record> metadataRef;

        private MetadataIndex(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.metadataOffset = MCAP.checkPositiveLong(dataInput.getLong(), "metadataOffset");
            this.metadataLength = MCAP.checkPositiveLong(dataInput.getLong(), "metadataLength");
            this.name = dataInput.getString();
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 20 + this.name.length();
        }

        public Record metadata() {
            Record metadata;
            Record record = metadata = this.metadataRef == null ? null : (Record)this.metadataRef.get();
            if (metadata == null) {
                metadata = new Record(this.dataInput, this.metadataOffset);
                this.metadataRef = new WeakReference<Record>(metadata);
            }
            return metadata;
        }

        public long metadataOffset() {
            return this.metadataOffset;
        }

        public long metadataLength() {
            return this.metadataLength;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-metadataOffset = " + this.metadataOffset;
            out = out + "\n\t-metadataLength = " + this.metadataLength;
            out = out + "\n\t-name = " + this.name;
            return out;
        }
    }

    public static class TupleStrStr
    implements MCAPElement {
        private final String key;
        private final String value;

        public TupleStrStr(MCAPDataInput dataInput, long elementPosition) {
            dataInput.position(elementPosition);
            this.key = dataInput.getString();
            this.value = dataInput.getString();
        }

        @Override
        public long getElementLength() {
            return this.key.length() + this.value.length() + 8;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return (this.key + ": " + this.value).replace("\n", "");
        }
    }

    public static class Message
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private int channelId;
        private long sequence;
        private long logTime;
        private long publishTime;
        private long dataOffset;
        private int dataLength;
        private WeakReference<ByteBuffer> messageBufferRef;
        private WeakReference<byte[]> messageDataRef;

        public static Message createSpoofMessageForTesting(final int channelId, final byte[] data) {
            return new Message(){

                @Override
                public int channelId() {
                    return channelId;
                }

                @Override
                public long dataOffset() {
                    return 0L;
                }

                @Override
                public int dataLength() {
                    return data.length;
                }

                @Override
                public ByteBuffer messageBuffer() {
                    return ByteBuffer.wrap(data);
                }

                @Override
                public byte[] messageData() {
                    return data;
                }
            };
        }

        private Message() {
            this.dataInput = null;
        }

        private Message(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.channelId = dataInput.getUnsignedShort();
            this.sequence = dataInput.getUnsignedInt();
            this.logTime = MCAP.checkPositiveLong(dataInput.getLong(), "logTime");
            this.publishTime = MCAP.checkPositiveLong(dataInput.getLong(), "publishTime");
            this.dataOffset = dataInput.position();
            this.dataLength = (int)(elementLength - 22L);
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return this.dataLength + 2 + 4 + 16;
        }

        public int channelId() {
            return this.channelId;
        }

        public long sequence() {
            return this.sequence;
        }

        public long logTime() {
            return this.logTime;
        }

        public long publishTime() {
            return this.publishTime;
        }

        public long dataOffset() {
            return this.dataOffset;
        }

        public int dataLength() {
            return this.dataLength;
        }

        public ByteBuffer messageBuffer() {
            ByteBuffer messageBuffer;
            ByteBuffer byteBuffer = messageBuffer = this.messageBufferRef == null ? null : (ByteBuffer)this.messageBufferRef.get();
            if (messageBuffer == null) {
                messageBuffer = this.dataInput.getByteBuffer(this.dataOffset, this.dataLength, false);
                this.messageBufferRef = new WeakReference<ByteBuffer>(messageBuffer);
            }
            return messageBuffer;
        }

        public byte[] messageData() {
            byte[] messageData;
            byte[] byArray = messageData = this.messageDataRef == null ? null : (byte[])this.messageDataRef.get();
            if (messageData == null) {
                messageData = this.dataInput.getBytes(this.dataOffset, this.dataLength);
                this.messageDataRef = new WeakReference<byte[]>(messageData);
            }
            return messageData;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-channelId = " + this.channelId;
            out = out + "\n\t-sequence = " + this.sequence;
            out = out + "\n\t-logTime = " + this.logTime;
            out = out + "\n\t-publishTime = " + this.publishTime;
            return out;
        }
    }

    public static class Header
    implements MCAPElement {
        private final String profile;
        private final String library;

        public Header(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            dataInput.position(elementPosition);
            this.profile = dataInput.getString();
            this.library = dataInput.getString();
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 8 + this.profile.length() + this.library.length();
        }

        public String profile() {
            return this.profile;
        }

        public String library() {
            return this.library;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-profile = " + this.profile;
            out = out + "\n\t-library = " + this.library;
            return out;
        }
    }

    public static class Metadata
    implements MCAPElement {
        private final String name;
        private final List<TupleStrStr> metadata;
        private final int metadataLength;

        private Metadata(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            dataInput.position(elementPosition);
            this.name = dataInput.getString();
            long start = dataInput.position();
            this.metadata = MCAP.parseList(dataInput, TupleStrStr::new);
            this.metadataLength = (int)(dataInput.position() - start);
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 4 + this.name.length() + this.metadataLength;
        }

        public String name() {
            return this.name;
        }

        public List<TupleStrStr> metadata() {
            return this.metadata;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-name = " + this.name;
            out = out + "\n\t-metadata = " + EuclidCoreIOTools.getCollectionString((String)", ", this.metadata, e -> e.key());
            return out;
        }
    }

    public static class Attachment
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long logTime;
        private final long createTime;
        private final String name;
        private final String mediaType;
        private final long lengthData;
        private final long offsetData;
        private WeakReference<ByteBuffer> dataRef;
        private final long crc32;
        private final long crc32InputStart;
        private final int crc32InputLength;
        private WeakReference<ByteBuffer> crc32InputRef;

        private Attachment(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.crc32InputStart = elementPosition;
            this.logTime = MCAP.checkPositiveLong(dataInput.getLong(), "logTime");
            this.createTime = MCAP.checkPositiveLong(dataInput.getLong(), "createTime");
            this.name = dataInput.getString();
            this.mediaType = dataInput.getString();
            this.lengthData = MCAP.checkPositiveLong(dataInput.getLong(), "lengthData");
            this.offsetData = dataInput.position();
            dataInput.skip(this.lengthData);
            this.crc32InputLength = (int)(dataInput.position() - elementPosition);
            this.crc32 = dataInput.getUnsignedInt();
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 36 + this.name.length() + this.mediaType.length() + (int)this.lengthData;
        }

        public ByteBuffer crc32Input() {
            ByteBuffer crc32Input;
            ByteBuffer byteBuffer = crc32Input = this.crc32InputRef == null ? null : (ByteBuffer)this.crc32InputRef.get();
            if (crc32Input == null) {
                crc32Input = this.dataInput.getByteBuffer(this.crc32InputStart, this.crc32InputLength, false);
                this.crc32InputRef = new WeakReference<ByteBuffer>(crc32Input);
            }
            return crc32Input;
        }

        public long logTime() {
            return this.logTime;
        }

        public long createTime() {
            return this.createTime;
        }

        public String name() {
            return this.name;
        }

        public String mediaType() {
            return this.mediaType;
        }

        public long lenData() {
            return this.lengthData;
        }

        public ByteBuffer data() {
            ByteBuffer data;
            ByteBuffer byteBuffer = data = this.dataRef == null ? null : (ByteBuffer)this.dataRef.get();
            if (data == null) {
                data = this.dataInput.getByteBuffer(this.offsetData, (int)this.lengthData, false);
                this.dataRef = new WeakReference<ByteBuffer>(data);
            }
            return data;
        }

        public void unloadData() {
            this.dataRef = null;
        }

        public long crc32() {
            return this.crc32;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-logTime = " + this.logTime;
            out = out + "\n\t-createTime = " + this.createTime;
            out = out + "\n\t-name = " + this.name;
            out = out + "\n\t-mediaType = " + this.mediaType;
            out = out + "\n\t-lengthData = " + this.lengthData;
            out = out + "\n\t-crc32 = " + this.crc32;
            return out;
        }
    }

    public static class SummaryOffset
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final Opcode groupOpcode;
        private final long offsetGroup;
        private final long lengthGroup;
        private WeakReference<Records> groupRef;

        public SummaryOffset(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.groupOpcode = Opcode.byId(dataInput.getUnsignedByte());
            this.offsetGroup = MCAP.checkPositiveLong(dataInput.getLong(), "offsetGroup");
            this.lengthGroup = MCAP.checkPositiveLong(dataInput.getLong(), "lengthGroup");
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 17L;
        }

        public Records group() {
            Records group;
            Records records = group = this.groupRef == null ? null : (Records)this.groupRef.get();
            if (group == null) {
                group = new Records(this.dataInput, this.offsetGroup, (int)this.lengthGroup);
                this.groupRef = new WeakReference<Records>(group);
            }
            return group;
        }

        public Opcode groupOpcode() {
            return this.groupOpcode;
        }

        public long offsetGroup() {
            return this.offsetGroup;
        }

        public long lengthGroup() {
            return this.lengthGroup;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-groupOpcode = " + this.groupOpcode;
            out = out + "\n\t-offsetGroup = " + this.offsetGroup;
            out = out + "\n\t-lengthGroup = " + this.lengthGroup;
            return out;
        }
    }

    public static class Schema
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final int id;
        private final String name;
        private final String encoding;
        private final long dataLength;
        private final long dataOffset;
        private WeakReference<ByteBuffer> dataRef;

        public Schema(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.id = dataInput.getUnsignedShort();
            this.name = dataInput.getString();
            this.encoding = dataInput.getString();
            this.dataLength = dataInput.getUnsignedInt();
            this.dataOffset = dataInput.position();
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 14 + this.name.length() + this.encoding.length() + (int)this.dataLength;
        }

        public int id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public String encoding() {
            return this.encoding;
        }

        public ByteBuffer data() {
            ByteBuffer data;
            ByteBuffer byteBuffer = data = this.dataRef == null ? null : (ByteBuffer)this.dataRef.get();
            if (data == null) {
                data = this.dataInput.getByteBuffer(this.dataOffset, (int)this.dataLength, false);
                this.dataRef = new WeakReference<ByteBuffer>(data);
            }
            return data;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-id = " + this.id;
            out = out + "\n\t-name = " + this.name;
            out = out + "\n\t-encoding = " + this.encoding;
            out = out + "\n\t-dataLength = " + this.dataLength;
            out = out + "\n\t-data = " + Arrays.toString(this.data().array());
            return out;
        }
    }

    public static class AttachmentIndex
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long attachmentOffset;
        private final long attachmentLength;
        private final long logTime;
        private final long createTime;
        private final long dataSize;
        private final String name;
        private final String mediaType;
        private WeakReference<Record> attachmentRef;

        private AttachmentIndex(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.attachmentOffset = MCAP.checkPositiveLong(dataInput.getLong(), "attachmentOffset");
            this.attachmentLength = MCAP.checkPositiveLong(dataInput.getLong(), "attachmentLength");
            this.logTime = MCAP.checkPositiveLong(dataInput.getLong(), "logTime");
            this.createTime = MCAP.checkPositiveLong(dataInput.getLong(), "createTime");
            this.dataSize = MCAP.checkPositiveLong(dataInput.getLong(), "dataSize");
            this.name = dataInput.getString();
            this.mediaType = dataInput.getString();
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 48 + this.name.length() + this.mediaType.length();
        }

        public Record attachment() {
            Record attachment;
            Record record = attachment = this.attachmentRef == null ? null : (Record)this.attachmentRef.get();
            if (attachment == null) {
                attachment = new Record(this.dataInput, this.attachmentOffset);
                this.attachmentRef = new WeakReference<Record>(attachment);
            }
            return attachment;
        }

        public long attachmentOffset() {
            return this.attachmentOffset;
        }

        public long attachmentLength() {
            return this.attachmentLength;
        }

        public long logTime() {
            return this.logTime;
        }

        public long createTime() {
            return this.createTime;
        }

        public long dataSize() {
            return this.dataSize;
        }

        public String name() {
            return this.name;
        }

        public String mediaType() {
            return this.mediaType;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-attachmentOffset = " + this.attachmentOffset;
            out = out + "\n\t-attachmentLength = " + this.attachmentLength;
            out = out + "\n\t-logTime = " + this.logTime;
            out = out + "\n\t-createTime = " + this.createTime;
            out = out + "\n\t-dataSize = " + this.dataSize;
            out = out + "\n\t-name = " + this.name;
            out = out + "\n\t-mediaType = " + this.mediaType;
            return out;
        }
    }

    public static class Statistics
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long elementLength;
        private final long messageCount;
        private final int schemaCount;
        private final long channelCount;
        private final long attachmentCount;
        private final long metadataCount;
        private final long chunkCount;
        private final long messageStartTime;
        private final long messageEndTime;
        private WeakReference<List<ChannelMessageCount>> channelMessageCountsRef;
        private final long channelMessageCountsOffset;
        private final long channelMessageCountsLength;

        public Statistics(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            this.elementLength = elementLength;
            dataInput.position(elementPosition);
            this.messageCount = MCAP.checkPositiveLong(dataInput.getLong(), "messageCount");
            this.schemaCount = dataInput.getUnsignedShort();
            this.channelCount = dataInput.getUnsignedInt();
            this.attachmentCount = dataInput.getUnsignedInt();
            this.metadataCount = dataInput.getUnsignedInt();
            this.chunkCount = dataInput.getUnsignedInt();
            this.messageStartTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageStartTime");
            this.messageEndTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageEndTime");
            this.channelMessageCountsLength = dataInput.getUnsignedInt();
            this.channelMessageCountsOffset = dataInput.position();
        }

        @Override
        public long getElementLength() {
            return this.elementLength;
        }

        public long messageCount() {
            return this.messageCount;
        }

        public int schemaCount() {
            return this.schemaCount;
        }

        public long channelCount() {
            return this.channelCount;
        }

        public long attachmentCount() {
            return this.attachmentCount;
        }

        public long metadataCount() {
            return this.metadataCount;
        }

        public long chunkCount() {
            return this.chunkCount;
        }

        public long messageStartTime() {
            return this.messageStartTime;
        }

        public long messageEndTime() {
            return this.messageEndTime;
        }

        public List<ChannelMessageCount> channelMessageCounts() {
            List<ChannelMessageCount> channelMessageCounts;
            List<ChannelMessageCount> list = channelMessageCounts = this.channelMessageCountsRef == null ? null : (List<ChannelMessageCount>)this.channelMessageCountsRef.get();
            if (channelMessageCounts == null) {
                channelMessageCounts = MCAP.parseList(this.dataInput, ChannelMessageCount::new, this.channelMessageCountsOffset, this.channelMessageCountsLength);
                this.channelMessageCountsRef = new WeakReference<List<ChannelMessageCount>>(channelMessageCounts);
            }
            return channelMessageCounts;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ": ";
            out = out + "\n\t-messageCount = " + this.messageCount;
            out = out + "\n\t-schemaCount = " + this.schemaCount;
            out = out + "\n\t-channelCount = " + this.channelCount;
            out = out + "\n\t-attachmentCount = " + this.attachmentCount;
            out = out + "\n\t-metadataCount = " + this.metadataCount;
            out = out + "\n\t-chunkCount = " + this.chunkCount;
            out = out + "\n\t-messageStartTime = " + this.messageStartTime;
            out = out + "\n\t-messageEndTime = " + this.messageEndTime;
            out = out + "\n\t-channelMessageCounts = \n" + EuclidCoreIOTools.getCollectionString((String)"\n", this.channelMessageCounts(), e -> e.toString(1));
            return out;
        }

        public static class ChannelMessageCount
        implements MCAPElement {
            private final int channelId;
            private final long messageCount;

            public ChannelMessageCount(MCAPDataInput dataInput, long elementPosition) {
                dataInput.position(elementPosition);
                this.channelId = dataInput.getUnsignedShort();
                this.messageCount = dataInput.getLong();
            }

            @Override
            public long getElementLength() {
                return 10L;
            }

            public int channelId() {
                return this.channelId;
            }

            public long messageCount() {
                return this.messageCount;
            }

            public String toString() {
                return this.toString(0);
            }

            @Override
            public String toString(int indent) {
                String out = this.getClass().getSimpleName() + ":";
                out = out + "\n\t-channelId = " + this.channelId;
                out = out + "\n\t-messageCount = " + this.messageCount;
                return MCAP.indent(out, indent);
            }
        }
    }

    public static class MessageIndex
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long elementLength;
        private final int channelId;
        private WeakReference<List<MessageIndexEntry>> messageIndexEntriesRef;
        private final long messageIndexEntriesOffset;
        private final long messageIndexEntriesLength;

        public MessageIndex(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            this.elementLength = elementLength;
            dataInput.position(elementPosition);
            this.channelId = dataInput.getUnsignedShort();
            this.messageIndexEntriesLength = dataInput.getUnsignedInt();
            this.messageIndexEntriesOffset = dataInput.position();
        }

        @Override
        public long getElementLength() {
            return this.elementLength;
        }

        public int channelId() {
            return this.channelId;
        }

        public List<MessageIndexEntry> messageIndexEntries() {
            List<MessageIndexEntry> messageIndexEntries;
            List<MessageIndexEntry> list = messageIndexEntries = this.messageIndexEntriesRef == null ? null : (List<MessageIndexEntry>)this.messageIndexEntriesRef.get();
            if (messageIndexEntries == null) {
                messageIndexEntries = MCAP.parseList(this.dataInput, MessageIndexEntry::new, this.messageIndexEntriesOffset, this.messageIndexEntriesLength);
                this.messageIndexEntriesRef = new WeakReference<List<MessageIndexEntry>>(messageIndexEntries);
            }
            return messageIndexEntries;
        }

        public String toString() {
            return this.toString(0);
        }

        @Override
        public String toString(int indent) {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-channelId = " + this.channelId;
            List<MessageIndexEntry> messageIndexEntries = this.messageIndexEntries();
            out = out + "\n\t-messageIndexEntries = " + (String)(messageIndexEntries == null ? "null" : "\n" + EuclidCoreIOTools.getCollectionString((String)"\n", messageIndexEntries, e -> e.toString(indent + 1)));
            return MCAP.indent(out, indent);
        }

        public static class MessageIndexEntry
        implements MCAPElement {
            private final long logTime;
            private final long offset;

            public MessageIndexEntry(MCAPDataInput dataInput, long elementPosition) {
                dataInput.position(elementPosition);
                this.logTime = MCAP.checkPositiveLong(dataInput.getLong(), "logTime");
                this.offset = MCAP.checkPositiveLong(dataInput.getLong(), "offset");
            }

            @Override
            public long getElementLength() {
                return 16L;
            }

            public long logTime() {
                return this.logTime;
            }

            public long offset() {
                return this.offset;
            }

            public String toString() {
                return this.toString(0);
            }

            @Override
            public String toString(int indent) {
                String out = this.getClass().getSimpleName() + ":";
                out = out + "\n\t-logTime = " + this.logTime;
                out = out + "\n\t-offset = " + this.offset;
                return MCAP.indent(out, indent);
            }
        }
    }

    public static class Channel
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long elementLength;
        private final int id;
        private final int schemaId;
        private final String topic;
        private final String messageEncoding;
        private WeakReference<List<TupleStrStr>> metadataRef;
        private final long metadataOffset;
        private final long metadataLength;

        public Channel(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            this.elementLength = elementLength;
            dataInput.position(elementPosition);
            this.id = dataInput.getUnsignedShort();
            this.schemaId = dataInput.getUnsignedShort();
            this.topic = dataInput.getString();
            this.messageEncoding = dataInput.getString();
            this.metadataLength = dataInput.getUnsignedInt();
            this.metadataOffset = dataInput.position();
        }

        @Override
        public long getElementLength() {
            return this.elementLength;
        }

        public int id() {
            return this.id;
        }

        public int schemaId() {
            return this.schemaId;
        }

        public String topic() {
            return this.topic;
        }

        public String messageEncoding() {
            return this.messageEncoding;
        }

        public List<TupleStrStr> metadata() {
            List<TupleStrStr> metadata;
            List<TupleStrStr> list = metadata = this.metadataRef == null ? null : (List<TupleStrStr>)this.metadataRef.get();
            if (metadata == null) {
                metadata = MCAP.parseList(this.dataInput, TupleStrStr::new, this.metadataOffset, this.metadataLength);
                this.metadataRef = new WeakReference<List<TupleStrStr>>(metadata);
            }
            return metadata;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-id = " + this.id;
            out = out + "\n\t-schemaId = " + this.schemaId;
            out = out + "\n\t-topic = " + this.topic;
            out = out + "\n\t-messageEncoding = " + this.messageEncoding;
            out = out + "\n\t-metadata = [%s]".formatted(this.metadata().toString());
            return out;
        }
    }

    public static class DataEnd
    implements MCAPElement {
        private final long dataSectionCrc32;

        public DataEnd(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            dataInput.position(elementPosition);
            this.dataSectionCrc32 = dataInput.getUnsignedInt();
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 4L;
        }

        public long dataSectionCrc32() {
            return this.dataSectionCrc32;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":\n\t-dataSectionCrc32 = " + this.dataSectionCrc32;
        }
    }

    public static class Chunk
    implements MCAPElement {
        private final MCAPDataInput dataInput;
        private final long messageStartTime;
        private final long messageEndTime;
        private final long recordsUncompressedLength;
        private final long uncompressedCrc32;
        private final String compression;
        private final long recordsOffset;
        private final long recordsCompressedLength;
        private WeakReference<Records> recordsRef;

        public Chunk(MCAPDataInput dataInput, long elementPosition, long elementLength) {
            this.dataInput = dataInput;
            dataInput.position(elementPosition);
            this.messageStartTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageStartTime");
            this.messageEndTime = MCAP.checkPositiveLong(dataInput.getLong(), "messageEndTime");
            this.recordsUncompressedLength = MCAP.checkPositiveLong(dataInput.getLong(), "uncompressedSize");
            this.uncompressedCrc32 = dataInput.getUnsignedInt();
            this.compression = dataInput.getString();
            this.recordsCompressedLength = MCAP.checkPositiveLong(dataInput.getLong(), "recordsLength");
            this.recordsOffset = dataInput.position();
            MCAP.checkLength(elementLength, this.getElementLength());
        }

        @Override
        public long getElementLength() {
            return 32 + this.compression.length() + 8 + (int)this.recordsCompressedLength;
        }

        public long messageStartTime() {
            return this.messageStartTime;
        }

        public long messageEndTime() {
            return this.messageEndTime;
        }

        public long uncompressedSize() {
            return this.recordsUncompressedLength;
        }

        public long uncompressedCrc32() {
            return this.uncompressedCrc32;
        }

        public String compression() {
            return this.compression;
        }

        public long recordsLength() {
            return this.recordsCompressedLength;
        }

        public Records records() {
            Records records;
            Records records2 = records = this.recordsRef == null ? null : (Records)this.recordsRef.get();
            if (records != null) {
                return records;
            }
            if (this.compression.equalsIgnoreCase("")) {
                records = new Records(this.dataInput, this.recordsOffset, (int)this.recordsCompressedLength);
            } else {
                ByteBuffer decompressedBuffer = this.dataInput.getDecompressedByteBuffer(this.recordsOffset, (int)this.recordsCompressedLength, (int)this.recordsUncompressedLength, MCAPDataInput.Compression.fromString(this.compression), false);
                records = new Records(MCAPDataInput.wrap(decompressedBuffer), 0L, (int)this.recordsUncompressedLength);
            }
            this.recordsRef = new WeakReference<Records>(records);
            return records;
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + ":";
            out = out + "\n\t-messageStartTime = " + this.messageStartTime;
            out = out + "\n\t-messageEndTime = " + this.messageEndTime;
            out = out + "\n\t-compression = " + this.compression;
            out = out + "\n\t-recordsCompressedLength = " + this.recordsCompressedLength;
            out = out + "\n\t-recordsUncompressedLength = " + this.recordsUncompressedLength;
            out = out + "\n\t-uncompressedCrc32 = " + this.uncompressedCrc32;
            return out;
        }
    }
}

