/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.mcap;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import us.ihmc.log.LogTools;

public class CDRDeserializer {
    private static final int encapsulation_size = 4;
    private ByteBuffer buffer;
    private int initialOffset;
    private int initialLimit;
    private int offset;

    public void initialize(ByteBuffer buffer) {
        this.initialize(buffer, -1, -1);
    }

    public void initialize(ByteBuffer buffer, int offset, int length) {
        this.initialOffset = buffer.position();
        this.initialLimit = buffer.limit();
        int n = this.offset = offset > -1 ? offset : buffer.position();
        if (length > -1) {
            buffer.limit(this.offset + length);
        }
        if (offset > -1) {
            buffer.position(offset);
        }
        CDRDeserializer.readEncapsulation(buffer);
        this.buffer = buffer;
    }

    public void finalize(boolean resetBufferPosition) {
        if (resetBufferPosition) {
            if (this.initialOffset > this.buffer.limit()) {
                this.buffer.limit(this.initialLimit);
            }
            this.buffer.position(this.initialOffset);
        }
        this.buffer.limit(this.initialLimit);
    }

    private static void readEncapsulation(ByteBuffer buffer) {
        buffer.get();
        short encapsulation = buffer.get();
        if (encapsulation == 0 || encapsulation == 2) {
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        buffer.getShort();
    }

    public boolean read_bool() {
        return this.buffer.get() != 0;
    }

    public float read_float32() {
        this.align(Type.FLOAT32.byteBoundary);
        return this.buffer.getFloat();
    }

    public double read_float64() {
        this.align(Type.FLOAT64.byteBoundary);
        return this.buffer.getDouble();
    }

    public byte read_byte() {
        return this.buffer.get();
    }

    public byte read_int8() {
        return this.read_byte();
    }

    public int read_uint8() {
        return Byte.toUnsignedInt(this.read_int8());
    }

    public short read_int16() {
        this.align(Type.INT16.byteBoundary);
        return this.buffer.getShort();
    }

    public int read_uint16() {
        return Short.toUnsignedInt(this.read_int16());
    }

    public int read_int32() {
        this.align(Type.INT32.byteBoundary);
        return this.buffer.getInt();
    }

    public long read_uint32() {
        return Integer.toUnsignedLong(this.read_int32());
    }

    public long read_int64() {
        this.align(Type.INT64.byteBoundary);
        return this.buffer.getLong();
    }

    public long read_uint64() {
        long uint64 = this.read_int64();
        if (uint64 < 0L) {
            LogTools.warn((String)("uint64 value is negative: " + uint64));
        }
        return uint64;
    }

    public String read_string() {
        return new String(this.read_stringAsBytes());
    }

    public byte[] read_stringAsBytes() {
        int length = this.read_int32() - 1;
        byte[] bytes = new byte[length];
        this.buffer.get(bytes);
        this.buffer.get();
        return bytes;
    }

    public void read_string(StringBuilder stringBuilderToPack) {
        int length = this.read_int32() - 1;
        for (int i = 0; i < length; ++i) {
            stringBuilderToPack.append((char)this.buffer.get());
        }
        this.buffer.get();
    }

    public void read_array(ElementReader reader, int arrayLength) {
        for (int i = 0; i < arrayLength; ++i) {
            reader.read(i, this);
        }
    }

    public int read_sequence(ElementReader reader) {
        int length = this.read_int32();
        for (int i = 0; i < length; ++i) {
            reader.read(i, this);
        }
        return length;
    }

    public double readTypeAsDouble(Type type) {
        return switch (type) {
            case Type.BOOL, Type.BOOLEAN -> {
                if (this.read_bool()) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case Type.FLOAT, Type.FLOAT32 -> this.read_float32();
            case Type.DOUBLE, Type.FLOAT64 -> this.read_float64();
            case Type.CHAR, Type.OCTET, Type.BYTE, Type.INT8 -> this.read_int8();
            case Type.UINT8 -> this.read_uint8();
            case Type.SHORT, Type.INT16 -> this.read_int16();
            case Type.UNSIGNEDSHORT, Type.UINT16 -> this.read_uint16();
            case Type.LONG, Type.INT32 -> this.read_int32();
            case Type.UNSIGNEDLONG, Type.UINT32 -> this.read_uint32();
            case Type.LONGLONG, Type.INT64 -> this.read_int64();
            case Type.UNSIGNEDLONGLONG, Type.UINT64 -> this.read_uint64();
            default -> throw new IllegalArgumentException("Unexpected type: " + type);
        };
    }

    public String readTypeAsString(Type type) {
        return this.readTypeAsString(type, -1);
    }

    public String readTypeAsString(Type type, int arrayLength) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.BOOL, Type.BOOLEAN -> String.valueOf(this.read_bool());
            case Type.FLOAT, Type.FLOAT32 -> String.valueOf(this.read_float32());
            case Type.DOUBLE, Type.FLOAT64 -> String.valueOf(this.read_float64());
            case Type.CHAR, Type.OCTET, Type.BYTE, Type.INT8 -> String.valueOf(this.read_int8());
            case Type.UINT8 -> String.valueOf(this.read_uint8());
            case Type.SHORT, Type.INT16 -> String.valueOf(this.read_int16());
            case Type.UNSIGNEDSHORT, Type.UINT16 -> String.valueOf(this.read_uint16());
            case Type.LONG, Type.INT32 -> String.valueOf(this.read_int32());
            case Type.UNSIGNEDLONG, Type.UINT32 -> String.valueOf(this.read_uint32());
            case Type.LONGLONG, Type.INT64 -> String.valueOf(this.read_int64());
            case Type.UNSIGNEDLONGLONG, Type.UINT64 -> String.valueOf(this.read_uint64());
            case Type.STRING -> this.read_string();
            case Type.ARRAY -> {
                if (arrayLength < 0) {
                    yield null;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (int i = 0; i < arrayLength; ++i) {
                    sb.append(this.readTypeAsString(type, -1));
                    if (i >= arrayLength - 1) continue;
                    sb.append(", ");
                }
                sb.append("]");
                yield sb.toString();
            }
            case Type.SEQUENCE -> {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                int length = this.read_int32();
                for (int i = 0; i < length; ++i) {
                    sb.append(this.readTypeAsString(type, -1));
                    if (i >= length - 1) continue;
                    sb.append(", ");
                }
                sb.append("]");
                yield sb.toString();
            }
        };
    }

    public boolean skipNext(Type nextType) {
        return this.skipNext(nextType, -1);
    }

    public boolean skipNext(Type nextType, int arrayLength) {
        boolean success = true;
        if (nextType.bytes > -1) {
            this.align(nextType.byteBoundary);
            this.buffer.position(this.buffer.position() + nextType.bytes);
        } else {
            switch (nextType) {
                case STRING: {
                    int length = this.read_int32() - 1;
                    this.buffer.position(this.buffer.position() + length + 1);
                    break;
                }
                case ARRAY: {
                    if (arrayLength < 0) {
                        success = false;
                        break;
                    }
                    this.buffer.position(this.buffer.position() + arrayLength);
                    break;
                }
                case SEQUENCE: {
                    int length = this.read_int32();
                    this.buffer.position(this.buffer.position() + length);
                }
            }
        }
        return success;
    }

    private int align(int byteBoundary) {
        int position = this.buffer.position() - this.offset - 4;
        int adv = position % byteBoundary;
        if (adv != 0) {
            this.buffer.position(position + this.offset + 4 + (byteBoundary - adv));
        }
        return adv;
    }

    public static enum Type {
        BOOL(1, -1),
        BOOLEAN(1, -1),
        FLOAT(4, 4),
        FLOAT32(4, 4),
        DOUBLE(8, 8),
        FLOAT64(8, 8),
        CHAR(1, -1),
        OCTET(1, -1),
        BYTE(1, -1),
        INT8(1, -1),
        UINT8(1, -1),
        SHORT(2, 2),
        INT16(2, 2),
        UNSIGNEDSHORT(2, 2),
        UINT16(2, 2),
        LONG(4, 4),
        INT32(4, 4),
        UNSIGNEDLONG(4, 4),
        UINT32(4, 4),
        LONGLONG(8, 8),
        INT64(8, 8),
        UNSIGNEDLONGLONG(8, 8),
        UINT64(8, 8),
        STRING(-1, -1),
        ARRAY(-1, -1),
        SEQUENCE(-1, -1);

        private final int bytes;
        private final int byteBoundary;

        private Type(int bytes, int byteBoundary) {
            this.bytes = bytes;
            this.byteBoundary = byteBoundary;
        }

        public static Type parseType(String stringValue) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(stringValue)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unexpected type: " + stringValue);
        }
    }

    public static interface ElementReader {
        public void read(int var1, CDRDeserializer var2);
    }
}

