/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.session.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import us.ihmc.commons.Conversions;
import us.ihmc.graphicsDescription.conversion.YoGraphicConversionTools;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotDataLogger.YoVariableClientInterface;
import us.ihmc.robotDataLogger.handshake.LogHandshake;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.util.DebugRegistry;
import us.ihmc.robotDataLogger.websocket.command.DataServerCommand;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.SessionProperties;
import us.ihmc.scs2.session.remote.LoggerStatusUpdater;
import us.ihmc.scs2.session.tools.RobotModelLoader;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotInterface;

public class RemoteSession
extends Session {
    private static final double MAX_DELAY_MILLI = 200.0;
    private YoVariableClientInterface yoVariableClientInterface;
    private final String sessionName;
    private final List<Robot> robots = new ArrayList<Robot>();
    private final List<RobotDefinition> robotDefinitions = new ArrayList<RobotDefinition>();
    private final List<YoGraphicDefinition> yoGraphicDefinitions = new ArrayList<YoGraphicDefinition>();
    private final Runnable robotStateUpdater;
    private final AtomicLong serverTimestamp = new AtomicLong(-1L);
    private final AtomicLong latestDataTimestamp = new AtomicLong(-1L);
    private final LoggerStatusUpdater loggerStatusUpdater = new LoggerStatusUpdater();
    private int bufferRecordTickPeriod = 1;
    private boolean initializeServerUpdateRate = true;

    public RemoteSession(YoVariableClientInterface yoVariableClientInterface, LogHandshake handshake, YoVariableHandshakeParser handshakeParser, DebugRegistry debugRegistry) {
        this.yoVariableClientInterface = yoVariableClientInterface;
        this.sessionName = yoVariableClientInterface.getServerName();
        this.rootRegistry.addChild(handshakeParser.getRootRegistry());
        this.rootRegistry.addChild(debugRegistry.getYoRegistry());
        this.yoGraphicDefinitions.add((YoGraphicDefinition)new YoGraphicGroupDefinition("SCS1 YoGraphics", (Collection)YoGraphicConversionTools.toYoGraphicDefinitions((YoGraphicsListRegistry)handshakeParser.getSCS1YoGraphics())));
        this.yoGraphicDefinitions.addAll(handshakeParser.getSCS2YoGraphics());
        RobotDefinition robotDefinition = RobotModelLoader.loadModel(handshake.getModelName(), handshake.getModelLoaderClass(), handshake.getResourceDirectories(), handshake.getModel(), handshake.getResourceZip());
        if (robotDefinition != null) {
            this.robotDefinitions.add(robotDefinition);
            Robot robot = new Robot(robotDefinition, this.getInertialFrame());
            this.robots.add(robot);
            this.robotStateUpdater = RobotModelLoader.setupRobotUpdater((RobotInterface)robot, handshakeParser, this.rootRegistry);
        } else {
            this.robotStateUpdater = null;
        }
        this.setSessionMode(SessionMode.RUNNING);
        this.setSessionDTSeconds(handshakeParser.getDt());
        this.setSessionModeTask(SessionMode.RUNNING, () -> {
            if (!this.yoVariableClientInterface.isConnected()) {
                this.setSessionMode(SessionMode.PAUSE);
            }
        });
        this.addSessionPropertiesListener(properties -> {
            if (properties.getActiveMode() == SessionMode.RUNNING) {
                this.reconnect();
            } else {
                this.disconnect();
            }
        });
        this.setDesiredBufferPublishPeriod(Conversions.secondsToNanoseconds((double)0.016666666666666666));
    }

    public long getDelay() {
        return this.serverTimestamp.get() - this.latestDataTimestamp.get();
    }

    protected long computeRunTaskPeriod() {
        return Conversions.secondsToNanoseconds((double)0.01);
    }

    protected long computePlaybackTaskPeriod() {
        int superBufferRecordTickPeriod = super.getBufferRecordTickPeriod();
        super.setBufferRecordTickPeriod(this.bufferRecordTickPeriod);
        long playbackTaskPeriod = super.computePlaybackTaskPeriod();
        super.setBufferRecordTickPeriod(superBufferRecordTickPeriod);
        return playbackTaskPeriod;
    }

    public SessionProperties getSessionProperties() {
        return new SessionProperties(this.getActiveMode(), this.getRunAtRealTimeRate(), this.getPlaybackRealTimeRate(), this.getSessionDTNanoseconds(), this.bufferRecordTickPeriod);
    }

    public void receivedTimestampOnly(long timestamp) {
        this.serverTimestamp.set(timestamp);
    }

    public void receivedTimestampAndData(long timestamp) {
        if (!this.hasSessionStarted() || this.getActiveMode() != SessionMode.RUNNING) {
            return;
        }
        if (this.initializeServerUpdateRate) {
            this.updateServerUpdateRate();
            this.initializeServerUpdateRate = false;
            return;
        }
        this.latestDataTimestamp.set(timestamp);
        this.runTick();
    }

    private void reconnect() {
        if (this.yoVariableClientInterface.isConnected()) {
            return;
        }
        this.sharedBuffer.setInPoint(this.sharedBuffer.getProperties().getCurrentIndex());
        try {
            if (this.yoVariableClientInterface.reconnect()) {
                this.updateServerUpdateRate();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void disconnect() {
        if (!this.yoVariableClientInterface.isConnected()) {
            return;
        }
        this.initializeServerUpdateRate = true;
        this.yoVariableClientInterface.disconnect();
    }

    protected double doSpecificRunTick() {
        if (this.robotStateUpdater != null) {
            this.robotStateUpdater.run();
        }
        return Conversions.nanosecondsToSeconds((long)this.latestDataTimestamp.get());
    }

    protected void initializeRunTick() {
        if (this.firstRunTick) {
            this.sharedBuffer.incrementBufferIndex(true);
            this.sharedBuffer.setInPoint(this.sharedBuffer.getProperties().getCurrentIndex());
            this.sharedBuffer.processLinkedPushRequests(false);
            this.nextRunBufferRecordTickCounter = 0;
            this.firstRunTick = false;
        } else if (this.nextRunBufferRecordTickCounter <= 0) {
            this.sharedBuffer.incrementBufferIndex(true);
            this.sharedBuffer.processLinkedPushRequests(false);
        }
    }

    protected void finalizeRunTick(boolean forceWriteBuffer) {
        if (forceWriteBuffer || (double)Conversions.nanosecondsToMilliseconds((long)this.getDelay()) < 200.0 * (double)this.bufferRecordTickPeriod) {
            super.finalizeRunTick(forceWriteBuffer);
        } else {
            this.sharedBuffer.writeBuffer();
            this.processBufferRequests(false);
            this.publishBufferProperties(this.sharedBuffer.getProperties());
        }
    }

    public void receivedCommand(DataServerCommand command, int argument) {
        this.loggerStatusUpdater.updateStatus(command, argument);
    }

    public void setBufferRecordTickPeriod(int bufferRecordTickPeriod) {
        if (bufferRecordTickPeriod == this.bufferRecordTickPeriod) {
            return;
        }
        this.bufferRecordTickPeriod = Math.max(1, bufferRecordTickPeriod);
        this.updateServerUpdateRate();
    }

    private void updateServerUpdateRate() {
        int updateRateInMilliseconds = (int)TimeUnit.NANOSECONDS.toMillis((long)this.bufferRecordTickPeriod * this.getSessionDTNanoseconds());
        this.yoVariableClientInterface.setVariableUpdateRate(updateRateInMilliseconds);
    }

    public void close() {
        if (this.yoVariableClientInterface != null) {
            if (this.yoVariableClientInterface.isConnected()) {
                this.yoVariableClientInterface.disconnect();
            }
            this.yoVariableClientInterface.stop();
        }
    }

    public void sendCommandToYoVariableServer(DataServerCommand command, int argument) {
        if (this.yoVariableClientInterface != null && this.yoVariableClientInterface.isConnected()) {
            this.yoVariableClientInterface.sendCommand(command, argument);
        }
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotDefinitions;
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return Collections.emptyList();
    }

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return this.yoGraphicDefinitions;
    }

    public List<RobotStateDefinition> getCurrentRobotStateDefinitions(boolean initialState) {
        return this.robots.stream().map(Robot::getCurrentRobotStateDefinition).collect(Collectors.toList());
    }

    public LoggerStatusUpdater getLoggerStatusUpdater() {
        return this.loggerStatusUpdater;
    }
}

