/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.examples.simulations.ExampleExperimentalSimulationTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationEnergyStatistics;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.parameters.BulletMultiBodyParameters;

public class FallingSphereExperimentalBulletSimulation {
    public FallingSphereExperimentalBulletSimulation() {
        double radius1 = 0.3;
        double mass1 = 2.0;
        double radiusOfGyrationPercent1 = 1.0;
        ColorDefinition appearance1 = ColorDefinitions.DarkGreen();
        ColorDefinition stripesAppearance1 = ColorDefinitions.LightGreen();
        RobotDefinition sphereRobot1 = ExampleExperimentalSimulationTools.newSphereRobot("sphere1", radius1, mass1, radiusOfGyrationPercent1, appearance1, true, stripesAppearance1);
        sphereRobot1.getRigidBodyDefinition("sphere1RigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Sphere3DDefinition(radius1)));
        SixDoFJointState sphere1InitialState = new SixDoFJointState();
        sphere1InitialState.setConfiguration(null, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 2.0));
        sphere1InitialState.setVelocity(null, (Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0));
        ((JointDefinition)sphereRobot1.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)sphere1InitialState);
        BulletMultiBodyParameters bulletMultiBodyParameters = BulletMultiBodyParameters.defaultBulletMultiBodyParameters();
        bulletMultiBodyParameters.setLinearDamping(0.0);
        BulletMultiBodyJointParameters bulletMultiBodyJointParameter = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        bulletMultiBodyJointParameter.setJointRestitution(1.0);
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)bulletMultiBodyParameters, (BulletMultiBodyJointParameters)bulletMultiBodyJointParameter));
        simulationSession.addRobot(sphereRobot1);
        Box3DDefinition terrainGeometry = new Box3DDefinition(6.0, 6.0, 0.01);
        RigidBodyTransform terrainPose = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0));
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.LightSlateGray())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        simulationSession.addTerrainObject(terrain);
        simulationSession.submitBufferSizeRequest(Integer.valueOf(245760));
        simulationSession.setBufferRecordTickPeriod(8);
        SimulationEnergyStatistics.setupSimulationEnergyStatistics((SimulationSession)simulationSession);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    public static void main(String[] args) {
        new FallingSphereExperimentalBulletSimulation();
    }
}

