/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.sessionVisualizer.jfx.model.viewer;

import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.urdf.URDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.ApplicationRunner;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.Simple3DViewer;
import us.ihmc.scs2.sessionVisualizer.jfx.Scene3DBuilder;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.FrameNode;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.RigidBodyFrameNodeFactories;

public class SimpleModelViewer {
    private static final ReferenceFrame rootFrame = ReferenceFrame.getWorldFrame();
    private static final String MODEL_FILE_KEY = "ROBOT_MODEL_FILE_SIMPLE_VIEWER";
    private File modelFile = null;

    public SimpleModelViewer(Stage primaryStage) {
        RobotDefinition robotDefinition;
        if (this.modelFile == null) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Model Files", new String[]{"*.urdf", "*.sdf"}), new FileChooser.ExtensionFilter("URDF Files", new String[]{"*.urdf"}), new FileChooser.ExtensionFilter("SDF Files", new String[]{"*.sdf"})});
            fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath((String)MODEL_FILE_KEY));
            this.modelFile = fileChooser.showOpenDialog((Window)primaryStage);
        }
        if (this.modelFile == null) {
            Platform.exit();
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath((String)MODEL_FILE_KEY, (File)this.modelFile);
        if (this.modelFile.getName().toLowerCase().endsWith("urdf")) {
            URDFModel urdfModel;
            try {
                urdfModel = URDFTools.loadURDFModel((File)this.modelFile, Collections.singletonList(this.modelFile.getParent()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            robotDefinition = URDFTools.toRobotDefinition((URDFModel)urdfModel);
        } else if (this.modelFile.getName().toLowerCase().endsWith("sdf")) {
            SDFModel sdfModel;
            try {
                sdfModel = (SDFModel)SDFTools.loadSDFRoot((File)this.modelFile).getModels().get(0);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            robotDefinition = SDFTools.toFloatingRobotDefinition((SDFModel)sdfModel);
        } else {
            LogTools.error((String)("Unhandled file type: " + this.modelFile.getName()));
            return;
        }
        RigidBodyBasics rigidBody = robotDefinition.newInstance(rootFrame);
        LinkedHashMap frameNodes = new LinkedHashMap();
        RigidBodyFrameNodeFactories.createRobotFrameNodeMap((RigidBodyReadOnly)rigidBody, (RobotDefinition)robotDefinition, null, frameNodes);
        rigidBody.updateFramesRecursively();
        frameNodes.values().forEach(FrameNode::updatePose);
        Scene3DBuilder scene3DBuilder = new Scene3DBuilder();
        Scene scene = new Scene((Parent)scene3DBuilder.getRoot(), 1024.0, 768.0, true, SceneAntialiasing.BALANCED);
        scene.setFill((Paint)Color.GREY);
        scene3DBuilder.addCoordinateSystem(0.2);
        frameNodes.values().forEach(frameNode -> scene3DBuilder.addNodeToView(frameNode.getNode()));
        Simple3DViewer.setupCamera(scene, scene3DBuilder.getRoot());
        primaryStage.setTitle("Robot Model Viewer");
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    public void stop() {
        System.out.println(this.getClass().getSimpleName() + " is going down.");
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(SimpleModelViewer::new);
    }
}

