/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.examples.simulations.ExampleExperimentalSimulationTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.parameters.ContactParameters;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngineFactory;

public class StackOfBlocksExperimentalSimulation {
    public StackOfBlocksExperimentalSimulation() {
        ContactParameters contactParameters = new ContactParameters();
        contactParameters.setMinimumPenetration(5.0E-5);
        contactParameters.setCoefficientOfFriction(0.7);
        contactParameters.setCoefficientOfRestitution(0.3);
        contactParameters.setRestitutionThreshold(0.15);
        contactParameters.setErrorReductionParameter(0.01);
        int numberOfBlocks = 6;
        Random random = new Random(1886L);
        ArrayList<RobotDefinition> robotDefinitions = new ArrayList<RobotDefinition>();
        double boxSizeX = 0.1;
        double boxSizeY = 0.08;
        double boxSizeZ = 0.1;
        double mass = 0.2;
        for (int i = 0; i < numberOfBlocks; ++i) {
            ColorDefinition appearance = ColorDefinition.rgb((int)random.nextInt());
            RobotDefinition boxRobot = ExampleExperimentalSimulationTools.newBoxRobot("Block" + i, boxSizeX, boxSizeY, boxSizeZ, mass, 0.5, appearance);
            robotDefinitions.add(boxRobot);
            boxRobot.getRigidBodyDefinition("Block" + i + "RigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Box3DDefinition(boxSizeX, boxSizeY, boxSizeZ)));
            double x = 0.0;
            double y = 0.0;
            double z = boxSizeZ * 1.05 * ((double)i + 1.0);
            double yaw = 0.0;
            double pitch = RandomNumbers.nextDouble((Random)random, (double)(-Math.PI / 90), (double)(Math.PI / 90));
            double roll = RandomNumbers.nextDouble((Random)random, (double)(-Math.PI / 90), (double)(Math.PI / 90));
            ((JointDefinition)boxRobot.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)new SixDoFJointState((Orientation3DReadOnly)new YawPitchRoll(yaw, pitch, roll), (Tuple3DReadOnly)new Point3D(x, y, z)));
        }
        RigidBodyTransform terrainPose = new RigidBodyTransform();
        terrainPose.getTranslation().subZ(0.05);
        Box3DDefinition terrainGeometry = new Box3DDefinition(1000.0, 1000.0, 0.1);
        TerrainObjectDefinition terrain = new TerrainObjectDefinition(new VisualDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry, new MaterialDefinition(ColorDefinitions.DarkGrey())), new CollisionShapeDefinition((RigidBodyTransformReadOnly)terrainPose, (GeometryDefinition)terrainGeometry));
        SimulationSession simulationSession = new SimulationSession(PhysicsEngineFactory.newImpulseBasedPhysicsEngineFactory((ContactParametersReadOnly)contactParameters));
        robotDefinitions.forEach(arg_0 -> ((SimulationSession)simulationSession).addRobot(arg_0));
        simulationSession.addTerrainObject(terrain);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    public static void main(String[] args) {
        new StackOfBlocksExperimentalSimulation();
    }
}

