/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class CylinderRobotSimulation
extends RobotDefinition {
    public CylinderRobotSimulation() {
        super("Cylinder");
        RigidBodyDefinition elevator = new RigidBodyDefinition("elevator");
        SixDoFJointDefinition floatingJoint = new SixDoFJointDefinition(this.getRootJointName());
        RigidBodyDefinition cylinder = this.createCylinderRigidBody();
        cylinder.setMass(10.0);
        cylinder.getMomentOfInertia().setToDiagonal(0.1, 0.1, 0.1);
        this.setRootBodyDefinition(elevator);
        elevator.addChildJoint((JointDefinition)floatingJoint);
        floatingJoint.setSuccessor(cylinder);
    }

    public String getRootJointName() {
        return "rootJoint";
    }

    private final RigidBodyDefinition createCylinderRigidBody() {
        RigidBodyDefinition ball = new RigidBodyDefinition("Cylinder");
        Cylinder3DDefinition geometryDefinition = new Cylinder3DDefinition(0.8, 0.25);
        MaterialDefinition materialDefinition = new MaterialDefinition(ColorDefinitions.Red());
        ball.addVisualDefinition(new VisualDefinition((GeometryDefinition)geometryDefinition, materialDefinition));
        ball.addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)geometryDefinition));
        return ball;
    }
}

