/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations;

import java.util.Random;
import java.util.stream.Stream;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.controller.implementations.ControllerCollectionDefinition;
import us.ihmc.scs2.definition.controller.implementations.OneDoFJointDampingControllerDefinition;
import us.ihmc.scs2.definition.controller.interfaces.ControllerDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Ellipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.HemiEllipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.TruncatedCone3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class MobileDefinition
extends RobotDefinition {
    private static final String MOBILE = "mobile";
    private static final double L1 = 0.3;
    private static final double M1 = 0.1;
    private static final double R1 = 0.01;
    private static final double Ixx1 = 0.01;
    private static final double Iyy1 = 0.01;
    private static final double Izz1 = 0.01;
    private static final double L2 = 0.12;
    private static final double M2 = 0.05;
    private static final double R2 = 0.005;
    private static final double Ixx2 = 0.01;
    private static final double Iyy2 = 0.01;
    private static final double Izz2 = 0.01;
    private static final double L3 = 0.08;
    private static final double M3 = 0.03;
    private static final double R3 = 0.001;
    private static final double Ixx3 = 0.01;
    private static final double Iyy3 = 0.01;
    private static final double Izz3 = 0.01;
    private static final double TOY_L = 0.02;
    private static final double TOY_W = 0.04;
    private static final double TOY_H = 0.03;
    private static final double TOY_R = 0.02;
    private static final double DAMP1 = 0.06;
    private static final double DAMP2 = 0.006;
    private static final double DAMP3 = 0.003;
    private final OneDoFJointDampingControllerDefinition jointLvl1DampingControllerDefinition = new OneDoFJointDampingControllerDefinition();
    private final OneDoFJointDampingControllerDefinition jointLvl2DampingControllerDefinition = new OneDoFJointDampingControllerDefinition();
    private final OneDoFJointDampingControllerDefinition jointLvl3DampingControllerDefinition = new OneDoFJointDampingControllerDefinition();

    public MobileDefinition() {
        super(MOBILE);
        this.jointLvl1DampingControllerDefinition.setControllerName("DampLevel1").createDampingVariable("damp1", 0.06);
        this.jointLvl2DampingControllerDefinition.setControllerName("DampLevel2").createDampingVariable("damp2", 0.006);
        this.jointLvl3DampingControllerDefinition.setControllerName("DampLevel3").createDampingVariable("damp3", 0.003);
        RigidBodyDefinition elevator = new RigidBodyDefinition("elevator");
        this.setRootBodyDefinition(elevator);
        OneDoFJointDefinition[] jointsLevel1 = this.createGimbal("jointLvl1", elevator, (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        RigidBodyDefinition crossBarLvl1 = this.createCrossBar("crossBarLvl1", (JointDefinition)jointsLevel1[2], 0.1, 0.3, 0.01, 0.01, 0.01, 0.01);
        this.jointLvl1DampingControllerDefinition.addJointsToControl((String[])Stream.of(jointsLevel1).map(JointDefinition::getName).toArray(String[]::new));
        for (int i = 0; i < 4; ++i) {
            double xOffset = 0.0;
            double yOffset = 0.0;
            if (i == 0) {
                xOffset = 0.3;
            } else if (i == 1) {
                xOffset = -0.3;
            } else {
                yOffset = i == 2 ? 0.3 : -0.3;
            }
            OneDoFJointDefinition[] jointsLevel2 = this.createGimbal("jointLvl2_" + i, crossBarLvl1, (Tuple3DReadOnly)new Vector3D(xOffset, yOffset, -0.15));
            RigidBodyDefinition crossBarLvl2 = this.createCrossBar("crossBarLvl2_" + i, (JointDefinition)jointsLevel2[2], 0.05, 0.12, 0.005, 0.01, 0.01, 0.01);
            this.jointLvl2DampingControllerDefinition.addJointsToControl((String[])Stream.of(jointsLevel2).map(JointDefinition::getName).toArray(String[]::new));
            for (int j = 0; j < 4; ++j) {
                xOffset = 0.0;
                yOffset = 0.0;
                if (j == 0) {
                    xOffset = 0.12;
                } else if (j == 1) {
                    xOffset = -0.12;
                } else {
                    yOffset = j == 2 ? 0.12 : -0.12;
                }
                OneDoFJointDefinition[] jointsLevel3 = this.createGimbal("jointLvl3_" + i + j, crossBarLvl2, (Tuple3DReadOnly)new Vector3D(xOffset, yOffset, -0.06));
                this.createRandomShape("toy_" + i + j, (JointDefinition)jointsLevel3[2]);
                this.jointLvl3DampingControllerDefinition.addJointsToControl((String[])Stream.of(jointsLevel3).map(JointDefinition::getName).toArray(String[]::new));
            }
        }
        this.addControllerDefinition((ControllerDefinition)new ControllerCollectionDefinition().setControllerName("mobileController").addControllerOutputReset().addControllerDefinitions(new ControllerDefinition[]{this.jointLvl1DampingControllerDefinition, this.jointLvl2DampingControllerDefinition, this.jointLvl3DampingControllerDefinition}));
    }

    private OneDoFJointDefinition[] createGimbal(String name, RigidBodyDefinition predecessor, Tuple3DReadOnly jointOffset) {
        RigidBodyDefinition jointXBody = this.createNullBody(name + "XBody");
        RigidBodyDefinition jointYBody = this.createNullBody(name + "YBody");
        RevoluteJointDefinition jointX = new RevoluteJointDefinition(name + "X");
        RevoluteJointDefinition jointY = new RevoluteJointDefinition(name + "Y");
        RevoluteJointDefinition jointZ = new RevoluteJointDefinition(name + "Z");
        jointX.getTransformToParent().getTranslation().set(jointOffset);
        jointX.getAxis().set((Tuple3DReadOnly)Axis3D.X);
        jointY.getAxis().set((Tuple3DReadOnly)Axis3D.Y);
        jointZ.getAxis().set((Tuple3DReadOnly)Axis3D.Z);
        predecessor.getChildrenJoints().add(jointX);
        jointX.setSuccessor(jointXBody);
        jointXBody.getChildrenJoints().add(jointY);
        jointY.setSuccessor(jointYBody);
        jointYBody.getChildrenJoints().add(jointZ);
        Random random = new Random();
        jointX.setInitialJointState(new OneDoFJointState(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.25), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5)));
        jointY.setInitialJointState(new OneDoFJointState(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.25), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5)));
        jointZ.setInitialJointState(new OneDoFJointState(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0)));
        return new OneDoFJointDefinition[]{jointX, jointY, jointZ};
    }

    private RigidBodyDefinition createNullBody(String name) {
        RigidBodyDefinition nullBody = new RigidBodyDefinition(name);
        nullBody.setMass(1.0E-12);
        nullBody.getMomentOfInertia().setToDiagonal(1.0E-12, 1.0E-12, 1.0E-12);
        return nullBody;
    }

    private RigidBodyDefinition createCrossBar(String name, JointDefinition parentJoint, double mass, double length, double radius, double Ixx, double Iyy, double Izz) {
        RigidBodyDefinition crossBar = new RigidBodyDefinition(name);
        crossBar.setMass(mass);
        crossBar.getMomentOfInertia().setToDiagonal(Ixx, Iyy, Izz);
        crossBar.getInertiaPose().getTranslation().set(0.0, 0.0, -length / 2.0);
        parentJoint.setSuccessor(crossBar);
        MaterialDefinition redMaterial = new MaterialDefinition(ColorDefinitions.Red());
        MaterialDefinition blackMaterial = new MaterialDefinition(ColorDefinitions.Black());
        Sphere3DDefinition sphere1 = new Sphere3DDefinition(0.01);
        Sphere3DDefinition sphere2 = new Sphere3DDefinition(radius);
        Cylinder3DDefinition cylinder1 = new Cylinder3DDefinition(0.5 * length, radius);
        Cylinder3DDefinition cylinder2 = new Cylinder3DDefinition(2.0 * length, radius);
        RigidBodyTransform verticalBarPose = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.25 * length));
        RigidBodyTransform crossBarCenter1 = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)Axis3D.X, 1.5707963267948966), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.5 * length));
        RigidBodyTransform crossBarCenter2 = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)Axis3D.Y, 1.5707963267948966), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.5 * length));
        RigidBodyTransform crossBarTip1 = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle(), (Tuple3DReadOnly)new Vector3D(length, 0.0, -0.5 * length));
        RigidBodyTransform crossBarTip2 = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)Axis3D.Z, -1.5707963267948966), (Tuple3DReadOnly)new Vector3D());
        crossBarTip2.multiply((RigidBodyTransformReadOnly)crossBarTip1);
        RigidBodyTransform crossBarTip3 = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)Axis3D.Z, -1.5707963267948966), (Tuple3DReadOnly)new Vector3D());
        crossBarTip3.multiply((RigidBodyTransformReadOnly)crossBarTip2);
        RigidBodyTransform crossBarTip4 = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)Axis3D.Z, -1.5707963267948966), (Tuple3DReadOnly)new Vector3D());
        crossBarTip4.multiply((RigidBodyTransformReadOnly)crossBarTip3);
        crossBar.addVisualDefinition(new VisualDefinition((GeometryDefinition)sphere1, redMaterial));
        crossBar.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)verticalBarPose, (GeometryDefinition)cylinder1, blackMaterial));
        crossBar.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)crossBarCenter1, (GeometryDefinition)cylinder2, blackMaterial));
        crossBar.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)crossBarCenter2, (GeometryDefinition)cylinder2, blackMaterial));
        crossBar.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)crossBarTip1, (GeometryDefinition)sphere2, redMaterial));
        crossBar.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)crossBarTip2, (GeometryDefinition)sphere2, redMaterial));
        crossBar.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)crossBarTip3, (GeometryDefinition)sphere2, redMaterial));
        crossBar.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)crossBarTip4, (GeometryDefinition)sphere2, redMaterial));
        return crossBar;
    }

    private RigidBodyDefinition createRandomShape(String name, JointDefinition parentJoint) {
        double stringLength = 0.08 * (1.0 + 2.0 * Math.random());
        RigidBodyDefinition toyRigidbody = new RigidBodyDefinition(name);
        toyRigidbody.setMass(0.03);
        toyRigidbody.getMomentOfInertia().setToDiagonal(0.01, 0.01, 0.01);
        toyRigidbody.getInertiaPose().getTranslation().set(0.0, 0.0, -stringLength);
        parentJoint.setSuccessor(toyRigidbody);
        RigidBodyTransform barVisualPose = new RigidBodyTransform();
        barVisualPose.getTranslation().setZ(-stringLength / 2.0);
        Cylinder3DDefinition barGeometryDefinition = new Cylinder3DDefinition(stringLength, 0.001);
        toyRigidbody.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)barVisualPose, (GeometryDefinition)barGeometryDefinition, new MaterialDefinition(ColorDefinitions.Black())));
        int toySelection = (int)(Math.random() * 7.0);
        Sphere3DDefinition toyGeometryDefinition = switch (toySelection) {
            case 0 -> new Sphere3DDefinition(0.02);
            case 1 -> new Cylinder3DDefinition(0.03, 0.02);
            case 2 -> new Box3DDefinition(0.02, 0.04, 0.03);
            case 3 -> new Cone3DDefinition(0.03, 0.02);
            case 4 -> new Ellipsoid3DDefinition(0.02, 0.04, 0.03);
            case 5 -> new HemiEllipsoid3DDefinition(0.02, 0.04, 0.03);
            default -> new TruncatedCone3DDefinition(0.03, 0.02, 0.04, 0.04, 0.02);
        };
        RigidBodyTransform toyVisualPose = new RigidBodyTransform();
        toyVisualPose.getTranslation().setZ(-stringLength);
        MaterialDefinition toyMaterialDefinition = new MaterialDefinition(ColorDefinition.rgb((int)new Random().nextInt()));
        toyRigidbody.addVisualDefinition(new VisualDefinition((RigidBodyTransformReadOnly)toyVisualPose, (GeometryDefinition)toyGeometryDefinition, toyMaterialDefinition));
        return toyRigidbody;
    }
}

