/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import org.bytedeco.bullet.BulletCollision.btBoxShape;
import org.bytedeco.bullet.BulletCollision.btBroadphaseInterface;
import org.bytedeco.bullet.BulletCollision.btCollisionConfiguration;
import org.bytedeco.bullet.BulletCollision.btCollisionDispatcher;
import org.bytedeco.bullet.BulletCollision.btCollisionShape;
import org.bytedeco.bullet.BulletCollision.btDbvtBroadphase;
import org.bytedeco.bullet.BulletCollision.btDefaultCollisionConfiguration;
import org.bytedeco.bullet.BulletCollision.btDispatcher;
import org.bytedeco.bullet.BulletDynamics.btConstraintSolver;
import org.bytedeco.bullet.BulletDynamics.btDiscreteDynamicsWorld;
import org.bytedeco.bullet.BulletDynamics.btRigidBody;
import org.bytedeco.bullet.BulletDynamics.btSequentialImpulseConstraintSolver;
import org.bytedeco.bullet.LinearMath.btDefaultMotionState;
import org.bytedeco.bullet.LinearMath.btMotionState;
import org.bytedeco.bullet.LinearMath.btTransform;
import org.bytedeco.bullet.LinearMath.btVector3;

public class SimpleBoxUsingBtClasses {
    private static btDefaultCollisionConfiguration m_collisionConfiguration;
    private static btCollisionDispatcher m_dispatcher;
    private static btBroadphaseInterface m_broadphase;
    private static btConstraintSolver m_solver;
    private static btDiscreteDynamicsWorld m_dynamicsWorld;

    public static void main(String[] args) {
        SimpleBoxUsingBtClasses.createEmptyDynamicsWorld();
        btBoxShape groundShape = new btBoxShape(new btVector3(50.0, 50.0, 50.0));
        btTransform groundTransform = new btTransform();
        groundTransform.setIdentity();
        groundTransform.setOrigin(new btVector3(0.0, -50.0, 0.0));
        SimpleBoxUsingBtClasses.createRigidBody(0.0, groundTransform, (btCollisionShape)groundShape);
        btBoxShape colShape = new btBoxShape(new btVector3(1.0, 1.0, 1.0));
        double mass = 1.0;
        colShape.calculateLocalInertia(mass, new btVector3(0.0, 0.0, 0.0));
        btTransform startTransform = new btTransform();
        startTransform.setIdentity();
        startTransform.setOrigin(new btVector3(0.0, 3.0, 0.0));
        btRigidBody box = SimpleBoxUsingBtClasses.createRigidBody(mass, startTransform, (btCollisionShape)colShape);
        for (int i = 0; i < 15; ++i) {
            m_dynamicsWorld.stepSimulation(0.1, 10, 0.01);
            btVector3 position = box.getWorldTransform().getOrigin();
            System.out.println(i + " " + position.y());
        }
        System.out.println("\nThis sample simulates falling of a rigid box, followed by \nan inelastic collision with a ground plane.\nThe numbers show height of the box at each simulation step. \nIt should start around 3.0 and end up around 1.0.\n");
    }

    private static void createEmptyDynamicsWorld() {
        m_collisionConfiguration = new btDefaultCollisionConfiguration();
        m_dispatcher = new btCollisionDispatcher((btCollisionConfiguration)m_collisionConfiguration);
        m_broadphase = new btDbvtBroadphase();
        m_solver = new btSequentialImpulseConstraintSolver();
        m_dynamicsWorld = new btDiscreteDynamicsWorld((btDispatcher)m_dispatcher, m_broadphase, m_solver, (btCollisionConfiguration)m_collisionConfiguration);
        m_dynamicsWorld.setGravity(new btVector3(0.0, -10.0, 0.0));
    }

    private static btRigidBody createRigidBody(double mass, btTransform startTransform, btCollisionShape shape) {
        boolean isDynamic = mass != 0.0;
        btVector3 localInertia = new btVector3(0.0, 0.0, 0.0);
        if (isDynamic) {
            shape.calculateLocalInertia(mass, localInertia);
        }
        btDefaultMotionState motionState = new btDefaultMotionState(startTransform, btTransform.getIdentity());
        btRigidBody.btRigidBodyConstructionInfo cInfo = new btRigidBody.btRigidBodyConstructionInfo(mass, (btMotionState)motionState, shape, localInertia);
        btRigidBody body = new btRigidBody(cInfo);
        body.setUserIndex(-1);
        m_dynamicsWorld.addRigidBody(body);
        return body;
    }
}

