/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import java.util.ArrayList;
import org.bytedeco.bullet.BulletCollision.btCollisionShape;
import org.bytedeco.bullet.BulletCollision.btCompoundShape;
import org.bytedeco.bullet.BulletCollision.btSphereShape;
import org.bytedeco.bullet.BulletDynamics.btMultiBody;
import org.bytedeco.bullet.LinearMath.btTransform;
import org.bytedeco.bullet.LinearMath.btVector3;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyDynamicsWorld;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyLinkCollider;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyRobot;

public class SimpleSphereUsingBulletNoSCS2 {
    public static void main(String[] args) {
        double dt = 0.1;
        double ballMass = 1.0;
        double ballRadius = 0.5;
        double gravity = -9.81;
        btVector3 baseInertiaDiag = new btVector3();
        boolean isFixed = false;
        BulletMultiBodyDynamicsWorld bulletMultiBodyDynamicsWorld = new BulletMultiBodyDynamicsWorld();
        btCompoundShape bulletCompoundShape = new btCompoundShape();
        btSphereShape childShape = new btSphereShape(ballRadius);
        bulletCompoundShape.addChildShape(btTransform.getIdentity(), (btCollisionShape)childShape);
        ArrayList<btSphereShape> btCollisionShapes = new ArrayList<btSphereShape>();
        btCollisionShapes.add(childShape);
        childShape.calculateLocalInertia(ballMass, baseInertiaDiag);
        BulletMultiBodyRobot bulletMultiBody = new BulletMultiBodyRobot(0, ballMass, baseInertiaDiag, isFixed, false, null);
        btTransform startTrans = new btTransform();
        startTrans.setIdentity();
        bulletMultiBody.getBtMultiBody().setBaseWorldTransform(startTrans);
        BulletMultiBodyLinkCollider linkCollider = new BulletMultiBodyLinkCollider(bulletMultiBody.getBtMultiBody(), -1, null);
        linkCollider.setCollisionShape(bulletCompoundShape, btCollisionShapes);
        linkCollider.setCollisionGroupMask(1, -1);
        bulletMultiBody.addBulletMuliBodyLinkCollider(linkCollider);
        bulletMultiBody.getBtMultiBody().setBaseCollider(linkCollider.getBtMultiBodyLinkCollider());
        bulletMultiBody.getBtMultiBody().finalizeMultiDof();
        btMultiBody btMultiBody2 = bulletMultiBody.getBtMultiBody();
        bulletMultiBodyDynamicsWorld.addBulletMultiBodyRobot(bulletMultiBody);
        bulletMultiBodyDynamicsWorld.setGravity((Tuple3DReadOnly)new Vector3D(0.0, 0.0, gravity));
        for (int i = 1; i < 100; ++i) {
            bulletMultiBodyDynamicsWorld.stepSimulation(dt, 1, dt);
            btVector3 position = btMultiBody2.getBasePos();
            System.out.println(i + " " + position.z());
        }
        bulletMultiBodyDynamicsWorld.dispose();
    }
}

