/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.simulations.bullet;

import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.SixDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.examples.simulations.ExampleExperimentalSimulationTools;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.simulation.SimulationEnergyStatistics;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyJointParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletMultiBodyParameters;
import us.ihmc.scs2.simulation.bullet.physicsEngine.BulletPhysicsEngineFactory;

public class CollidingSpheresNoGravityExperimentalBulletSimulation {
    public CollidingSpheresNoGravityExperimentalBulletSimulation() {
        double radius1 = 0.2;
        double mass1 = 1.0;
        double radiusOfGyrationPercent1 = 1.0;
        ColorDefinition appearance1 = ColorDefinitions.DarkGreen();
        ColorDefinition stripesAppearance1 = ColorDefinitions.LightGreen();
        RobotDefinition sphereRobot1 = ExampleExperimentalSimulationTools.newSphereRobot("sphere1", radius1, mass1, radiusOfGyrationPercent1, appearance1, true, stripesAppearance1);
        double radius2 = 0.2;
        double mass2 = 1.0;
        double radiusOfGyrationPercent2 = 1.0;
        ColorDefinition appearance2 = ColorDefinitions.DarkRed();
        ColorDefinition stripesAppearance2 = ColorDefinitions.LightSteelBlue();
        RobotDefinition sphereRobot2 = ExampleExperimentalSimulationTools.newSphereRobot("sphere2", radius2, mass2, radiusOfGyrationPercent2, appearance2, true, stripesAppearance2);
        sphereRobot1.getRigidBodyDefinition("sphere1RigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Sphere3DDefinition(radius1)));
        sphereRobot2.getRigidBodyDefinition("sphere2RigidBody").addCollisionShapeDefinition(new CollisionShapeDefinition((GeometryDefinition)new Sphere3DDefinition(radius2)));
        SixDoFJointState sphere1InitialState = new SixDoFJointState();
        sphere1InitialState.setConfiguration(null, (Tuple3DReadOnly)new Point3D(0.2, 3.0, 0.6));
        sphere1InitialState.setVelocity(null, (Vector3DReadOnly)new Vector3D(0.0, -1.0, 0.0));
        ((JointDefinition)sphereRobot1.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)sphere1InitialState);
        SixDoFJointState sphere2InitialState = new SixDoFJointState();
        sphere2InitialState.setConfiguration(null, (Tuple3DReadOnly)new Point3D(0.2, -3.0, 0.6));
        sphere2InitialState.setVelocity(null, (Vector3DReadOnly)new Vector3D(0.0, 1.0, 0.0));
        ((JointDefinition)sphereRobot2.getRootJointDefinitions().get(0)).setInitialJointState((JointStateReadOnly)sphere2InitialState);
        BulletMultiBodyParameters bulletMultiBodyParameters = BulletMultiBodyParameters.defaultBulletMultiBodyParameters();
        bulletMultiBodyParameters.setLinearDamping(0.0);
        bulletMultiBodyParameters.setMaxCoordinateVelocity(100000.0);
        bulletMultiBodyParameters.setUseRK4Integration(true);
        BulletMultiBodyJointParameters bulletMultiBodyJointParameter = BulletMultiBodyJointParameters.defaultBulletMultiBodyJointParameters();
        SimulationSession simulationSession = new SimulationSession(BulletPhysicsEngineFactory.newBulletPhysicsEngineFactory((BulletMultiBodyParameters)bulletMultiBodyParameters, (BulletMultiBodyJointParameters)bulletMultiBodyJointParameter));
        simulationSession.addRobot(sphereRobot1);
        simulationSession.addRobot(sphereRobot2);
        simulationSession.submitBufferSizeRequest(Integer.valueOf(245760));
        simulationSession.setBufferRecordTickPeriod(8);
        simulationSession.setGravity(0.0, 0.0, 0.0);
        simulationSession.setSessionDTSeconds(0.01);
        SimulationEnergyStatistics.setupSimulationEnergyStatistics((SimulationSession)simulationSession);
        SessionVisualizer.startSessionVisualizer((Session)simulationSession);
    }

    public static void main(String[] args) {
        new CollidingSpheresNoGravityExperimentalBulletSimulation();
    }
}

