/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.sessionVisualizer.jfx;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.cameraControllers.FocusBasedCameraMouseEventHandler;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinitionFactory;
import us.ihmc.scs2.examples.sessionVisualizer.jfx.Simple3DViewer;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;

public class VisualDefinitionFactoryJFXVisualizer {
    private static final boolean USE_TEXTURE = false;
    private final Random random = new Random(232L);
    private final View3DFactory view3dFactory;
    private final MaterialDefinition material;
    private final int gridWidth = 2;
    private int currentX = 0;
    private int currentY = 0;
    private final double cellSize = 0.5;

    public VisualDefinitionFactoryJFXVisualizer(Stage primaryStage) {
        primaryStage.setTitle(this.getClass().getSimpleName());
        this.view3dFactory = new View3DFactory(600.0, 400.0);
        FocusBasedCameraMouseEventHandler cameraController = this.view3dFactory.addCameraController(true);
        cameraController.changeFocusPosition(0.0, 0.0, 0.15, false);
        cameraController.changeCameraPosition(1.0, 1.0, 0.25);
        this.view3dFactory.addWorldCoordinateSystem(0.25);
        this.view3dFactory.addNodeToView(VisualDefinitionFactoryJFXVisualizer.createAxisLabels());
        this.material = new MaterialDefinition(ColorDefinitions.Cyan());
        List<? extends Point2DReadOnly> polygon2D = this.createPolygon2D(0.9, 7);
        List<? extends Point3DReadOnly> polygon3D = this.toPolygon3D(this.createPolygon2D(0.9, 7), 0.03, 0.075);
        List<? extends Point2DReadOnly> extrudedPolygon2D = this.createPolygon2D(0.4, 7);
        VisualDefinitionFactory factory = new VisualDefinitionFactory();
        factory.setDefaultMaterial(this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addCoordinateSystem(0.25, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addArrow(Axis3D.Z, 0.3, ColorDefinitions.Tomato(), ColorDefinitions.BlueViolet());
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addBox(0.1, 0.2, 0.3, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addBox(0.1, 0.2, 0.3, false, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addRamp(0.3, 0.2, 0.1, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addSphere(0.15, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addCapsule(0.2, 0.05, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addEllipsoid(0.025, 0.2, 0.1, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addCylinder(0.2, 0.05, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addCone(0.2, 0.1, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addTruncatedCone(0.2, 0.1, 0.04, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addTruncatedCone(0.175, 0.12, 0.075, 0.03, 0.06, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addHemiEllipsoid(0.15, 0.05, 0.225, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addTorus(0.2, 0.025, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addArcTorus(0.7853981633974483, 5.497787143782138, 0.2, 0.025, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addPyramidBox(0.15, 0.075, 0.15, 0.1, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addPolygon3D(polygon3D, true, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addPolygon2D(polygon2D, true, this.material);
        factory.getCurrentTransform().setTranslation((Tuple3DReadOnly)this.nextVisualPosition());
        factory.addExtrudedPolygon(extrudedPolygon2D, true, 0.1, this.material);
        List visualDefinitions = factory.getVisualDefinitions();
        Node node = JavaFXVisualTools.collectNodes((List)visualDefinitions);
        this.view3dFactory.addNodeToView(node);
        primaryStage.setMaximized(true);
        primaryStage.setScene(this.view3dFactory.getScene());
        primaryStage.show();
    }

    public static Node createAxisLabels() {
        AxisAngle orientation = new AxisAngle();
        orientation.appendYawRotation(2.356194490192345);
        orientation.appendRollRotation(-1.5707963267948966);
        Node xLabel = Simple3DViewer.createLabel("x", Color.RED, 0.1, 0.001, (Point3DReadOnly)new Point3D(350.0, -75.0, 0.0), (Orientation3DReadOnly)orientation);
        Node yLabel = Simple3DViewer.createLabel("y", Color.GREEN, 0.1, 0.001, (Point3DReadOnly)new Point3D(25.0, 275.0, 0.0), (Orientation3DReadOnly)orientation);
        Node zLabel = Simple3DViewer.createLabel("z", Color.BLUE, 0.1, 0.001, (Point3DReadOnly)new Point3D(25.0, -50.0, 300.0), (Orientation3DReadOnly)orientation);
        return new Group(new Node[]{xLabel, yLabel, zLabel});
    }

    private List<? extends Point2DReadOnly> createPolygon2D(double maxEdgeLength, int numberOfVertices) {
        List vertices = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)this.random, (Point2DReadOnly)new Point2D(), (double)maxEdgeLength, (int)numberOfVertices);
        Collections.reverse(vertices);
        return vertices;
    }

    private List<? extends Point3DReadOnly> toPolygon3D(List<? extends Point2DReadOnly> polygon2D, double minZ, double maxZ) {
        return polygon2D.stream().map(Point3D::new).peek(p -> p.setZ(EuclidCoreRandomTools.nextDouble((Random)this.random, (double)minZ, (double)maxZ))).collect(Collectors.toList());
    }

    private Point3D nextVisualPosition() {
        Point3D next = this.currentX == 0 && this.currentY == 0 ? new Point3D() : new Point3D((double)this.currentX * 0.5, (double)this.currentY * 0.5, 0.0);
        this.currentY = VisualDefinitionFactoryJFXVisualizer.nextIndex(this.currentY);
        if (this.currentY > 2) {
            this.currentY = 0;
            this.currentX = VisualDefinitionFactoryJFXVisualizer.nextIndex(this.currentX);
        }
        return next;
    }

    private static int nextIndex(int index) {
        if (index == 0) {
            return 1;
        }
        if (index > 0) {
            return -index;
        }
        return -index + 1;
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(VisualDefinitionFactoryJFXVisualizer::new);
    }
}

