/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.examples.sessionVisualizer.jfx.model.viewer;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.xml.bind.JAXBException;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.sdf.items.SDFModel;
import us.ihmc.scs2.definition.robot.urdf.URDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.FrameNode;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.JavaFXMultiBodySystemFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.JavaFXRigidBody;

public class SimpleModelViewer {
    private static final ReferenceFrame rootFrame = ReferenceFrame.getWorldFrame();
    private static final String MODEL_FILE_KEY = "ROBOT_MODEL_FILE_SIMPLE_VIEWER";
    private File modelFile = null;

    public SimpleModelViewer(Stage primaryStage) {
        RobotDefinition robotDefinition;
        if (this.modelFile == null) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Model Files", new String[]{"*.urdf", "*.sdf"}), new FileChooser.ExtensionFilter("URDF Files", new String[]{"*.urdf"}), new FileChooser.ExtensionFilter("SDF Files", new String[]{"*.sdf"})});
            fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath((String)MODEL_FILE_KEY));
            this.modelFile = fileChooser.showOpenDialog((Window)primaryStage);
        }
        if (this.modelFile == null) {
            Platform.exit();
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath((String)MODEL_FILE_KEY, (File)this.modelFile);
        if (this.modelFile.getName().toLowerCase().endsWith("urdf")) {
            URDFModel urdfModel;
            try {
                urdfModel = URDFTools.loadURDFModel((File)this.modelFile);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            robotDefinition = URDFTools.toFloatingRobotDefinition((URDFModel)urdfModel);
        } else if (this.modelFile.getName().toLowerCase().endsWith("sdf")) {
            SDFModel sdfModel;
            try {
                sdfModel = (SDFModel)SDFTools.loadSDFRoot((File)this.modelFile).getModels().get(0);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            robotDefinition = SDFTools.toFloatingRobotDefinition((SDFModel)sdfModel);
        } else {
            LogTools.error((String)("Unhandled file type: " + this.modelFile.getName()));
            return;
        }
        RigidBodyBasics rigidBody = robotDefinition.newIntance(rootFrame);
        JavaFXRigidBody javaFXRootBody = JavaFXMultiBodySystemFactories.toJavaFXMultiBodySystem((RigidBodyReadOnly)rigidBody, (ReferenceFrame)rootFrame, (RobotDefinition)robotDefinition);
        javaFXRootBody.updateFramesRecursively();
        javaFXRootBody.updateSubtreeGraphics();
        List<Node> graphicsNodes = SimpleModelViewer.collectGraphicsNodes(javaFXRootBody);
        View3DFactory view3dFactory = new View3DFactory(1024.0, 768.0);
        view3dFactory.addWorldCoordinateSystem(0.2);
        view3dFactory.addNodesToView(graphicsNodes);
        view3dFactory.addCameraController();
        primaryStage.setTitle("Robot Model Viewer");
        primaryStage.setScene(view3dFactory.getScene());
        primaryStage.show();
    }

    public static List<Node> collectGraphicsNodes(JavaFXRigidBody rootBody) {
        return rootBody.subtreeStream().map(JavaFXRigidBody::getGraphics).filter(graphics -> graphics != null).map(FrameNode::getNode).collect(Collectors.toList());
    }

    public void stop() {
        System.out.println(this.getClass().getSimpleName() + " is going down.");
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(SimpleModelViewer::new);
    }
}

