/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.yoComposite;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import us.ihmc.scs2.definition.yoChart.YoChartGroupModelDefinition;

@XmlRootElement(name="YoCompositePattern")
public class YoCompositePatternDefinition {
    private String name;
    private boolean crossRegistry = false;
    private final List<String> identifiers = new ArrayList<String>();
    private final List<YoChartGroupModelDefinition> preferredConfigurations = new ArrayList<YoChartGroupModelDefinition>();

    public YoCompositePatternDefinition() {
    }

    public YoCompositePatternDefinition(String name) {
        this.setName(name);
    }

    public YoCompositePatternDefinition(YoCompositePatternDefinition other) {
        if (other == null) {
            return;
        }
        this.setName(other.name);
        this.setCrossRegistry(other.crossRegistry);
        this.setIdentifiers(other.identifiers);
        this.setPreferredConfigurations(other.preferredConfigurations);
    }

    @XmlAttribute
    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public void setCrossRegistry(boolean crossRegistry) {
        this.crossRegistry = crossRegistry;
    }

    @XmlElement
    public void setIdentifiers(List<String> identifiers) {
        this.identifiers.clear();
        this.identifiers.addAll(identifiers);
    }

    @XmlElement
    public void setPreferredConfigurations(List<YoChartGroupModelDefinition> preferredConfigurations) {
        this.preferredConfigurations.clear();
        for (YoChartGroupModelDefinition model : preferredConfigurations) {
            this.preferredConfigurations.add(model.clone());
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isCrossRegistry() {
        return this.crossRegistry;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public List<YoChartGroupModelDefinition> getPreferredConfigurations() {
        return this.preferredConfigurations;
    }

    public YoCompositePatternDefinition clone() {
        return new YoCompositePatternDefinition(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof YoCompositePatternDefinition) {
            YoCompositePatternDefinition other = (YoCompositePatternDefinition)object;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.crossRegistry != other.crossRegistry) {
                return false;
            }
            if (!this.identifiers.equals(other.identifiers)) {
                return false;
            }
            return this.preferredConfigurations.equals(other.preferredConfigurations);
        }
        return false;
    }

    public String toString() {
        return "name: " + this.name + ", ids: " + this.identifiers.toString() + ", chart ids: " + this.preferredConfigurations.toString();
    }
}

