/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot.urdf;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.YawPitchRollTransformDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.FixedJointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.LidarSensorDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.PlanarJointDefinition;
import us.ihmc.scs2.definition.robot.PrismaticJointDefinition;
import us.ihmc.scs2.definition.robot.RevoluteJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.definition.robot.sdf.SDFTools;
import us.ihmc.scs2.definition.robot.urdf.items.URDFAxis;
import us.ihmc.scs2.definition.robot.urdf.items.URDFColor;
import us.ihmc.scs2.definition.robot.urdf.items.URDFDynamics;
import us.ihmc.scs2.definition.robot.urdf.items.URDFFilenameHolder;
import us.ihmc.scs2.definition.robot.urdf.items.URDFGazebo;
import us.ihmc.scs2.definition.robot.urdf.items.URDFGeometry;
import us.ihmc.scs2.definition.robot.urdf.items.URDFInertia;
import us.ihmc.scs2.definition.robot.urdf.items.URDFInertial;
import us.ihmc.scs2.definition.robot.urdf.items.URDFJoint;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLimit;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLink;
import us.ihmc.scs2.definition.robot.urdf.items.URDFLinkReference;
import us.ihmc.scs2.definition.robot.urdf.items.URDFMass;
import us.ihmc.scs2.definition.robot.urdf.items.URDFMaterial;
import us.ihmc.scs2.definition.robot.urdf.items.URDFModel;
import us.ihmc.scs2.definition.robot.urdf.items.URDFOrigin;
import us.ihmc.scs2.definition.robot.urdf.items.URDFSensor;
import us.ihmc.scs2.definition.robot.urdf.items.URDFTexture;
import us.ihmc.scs2.definition.robot.urdf.items.URDFVisual;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class URDFTools {
    private static final Vector3D DEFAULT_ORIGIN_XYZ = new Vector3D();
    private static final Vector3D DEFAULT_ORIGIN_RPY = new Vector3D();
    private static final double DEFAULT_MASS = 0.0;
    private static final double DEFAULT_IXX = 0.0;
    private static final double DEFAULT_IYY = 0.0;
    private static final double DEFAULT_IZZ = 0.0;
    private static final double DEFAULT_IXY = 0.0;
    private static final double DEFAULT_IXZ = 0.0;
    private static final double DEFAULT_IYZ = 0.0;
    private static final Vector3DReadOnly DEFAULT_AXIS = new Vector3D(1.0, 0.0, 0.0);
    private static final double DEFAULT_LOWER_LIMIT = Double.NEGATIVE_INFINITY;
    private static final double DEFAULT_UPPER_LIMIT = Double.POSITIVE_INFINITY;
    private static final double DEFAULT_EFFORT_LIMIT = Double.POSITIVE_INFINITY;
    private static final double DEFAULT_VELOCITY_LIMIT = Double.POSITIVE_INFINITY;

    public static URDFModel loadURDFModel(File urdfFile) throws JAXBException {
        return URDFTools.loadURDFModel(urdfFile, Collections.emptyList());
    }

    public static URDFModel loadURDFModel(File urdfFile, Collection<String> resourceDirectories) throws JAXBException {
        HashSet<String> allResourceDirectories = new HashSet<String>(resourceDirectories);
        File parentFile = urdfFile.getParentFile();
        if (parentFile != null) {
            allResourceDirectories.add(parentFile.getAbsolutePath() + File.separator);
            Stream.of(parentFile.listFiles(File::isDirectory)).map(file -> file.getAbsolutePath() + File.separator).forEach(allResourceDirectories::add);
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{URDFModel.class});
        Unmarshaller um = context.createUnmarshaller();
        URDFModel urdfModel = (URDFModel)um.unmarshal(urdfFile);
        URDFTools.resolvePaths(urdfModel, allResourceDirectories);
        return urdfModel;
    }

    public static URDFModel loadURDFModel(InputStream inputStream, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{URDFModel.class});
        Unmarshaller um = context.createUnmarshaller();
        URDFModel urdfModel = (URDFModel)um.unmarshal(inputStream);
        URDFTools.resolvePaths(urdfModel, resourceDirectories, resourceClassLoader);
        return urdfModel;
    }

    public static void resolvePaths(URDFModel urdfModel, Collection<String> resourceDirectories) {
        URDFTools.resolvePaths(urdfModel, resourceDirectories, null);
    }

    public static void resolvePaths(URDFModel urdfModel, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) {
        if (resourceClassLoader == null) {
            resourceClassLoader = URDFTools.class.getClassLoader();
        }
        List<URDFFilenameHolder> filenameHolders = urdfModel.getFilenameHolders();
        for (URDFFilenameHolder urdfFilenameHolder : filenameHolders) {
            urdfFilenameHolder.setFilename(URDFTools.tryToConvertToPath(urdfFilenameHolder.getFilename(), resourceDirectories, resourceClassLoader));
        }
    }

    public static String tryToConvertToPath(String filename, Collection<String> resourceDirectories, ClassLoader resourceClassLoader) {
        return SDFTools.tryToConvertToPath(filename, resourceDirectories, resourceClassLoader);
    }

    public static RobotDefinition toFloatingRobotDefinition(URDFModel urdfModel) {
        return URDFTools.toRobotDefinition(new SixDoFJointDefinition(), urdfModel);
    }

    public static RobotDefinition toRobotDefinition(JointDefinition rootJointDefinition, URDFModel urdfModel) {
        List<URDFLink> urdfLinks = urdfModel.getLinks();
        List<URDFJoint> urdfJoints = urdfModel.getJoints();
        List<URDFGazebo> urdfGazebos = urdfModel.getGazebos();
        List<RigidBodyDefinition> rigidBodyDefinitions = urdfLinks.stream().map(URDFTools::toRigidBodyDefinition).collect(Collectors.toList());
        List<JointDefinition> jointDefinitions = urdfJoints == null ? Collections.emptyList() : urdfJoints.stream().map(URDFTools::toJointDefinition).collect(Collectors.toList());
        RigidBodyDefinition startBodyDefinition = URDFTools.connectKinematics(rigidBodyDefinitions, jointDefinitions, urdfJoints);
        if (rootJointDefinition.getName() == null) {
            rootJointDefinition.setName(startBodyDefinition.getName());
        }
        rootJointDefinition.setSuccessor(startBodyDefinition);
        RigidBodyDefinition rootBodyDefinition = new RigidBodyDefinition("rootBody");
        rootBodyDefinition.addChildJoint(rootJointDefinition);
        URDFTools.addSensor(urdfGazebos, jointDefinitions);
        URDFTools.simplifyKinematics(rootJointDefinition);
        URDFTools.correctTransforms(rootJointDefinition);
        RobotDefinition robotDefinition = new RobotDefinition(urdfModel.getName());
        robotDefinition.setRootBodyDefinition(rootBodyDefinition);
        return robotDefinition;
    }

    public static void addSensor(List<URDFGazebo> urdfGazebos, List<JointDefinition> jointDefinitions) {
        if (urdfGazebos == null || urdfGazebos.isEmpty()) {
            return;
        }
        Map jointDefinitionMap = jointDefinitions.stream().collect(Collectors.toMap(JointDefinition::getName, Function.identity()));
        Map linkNameToJointDefinitionMap = jointDefinitions.stream().collect(Collectors.toMap(joint -> joint.getSuccessor().getName(), Function.identity()));
        for (URDFGazebo urdfGazebo : urdfGazebos) {
            if (urdfGazebo.getSensor() == null) continue;
            List<SensorDefinition> sensorDefinitions = URDFTools.toSensorDefinition(urdfGazebo.getSensor());
            JointDefinition jointDefinition = (JointDefinition)jointDefinitionMap.get(urdfGazebo.getReference());
            if (jointDefinition == null) {
                jointDefinition = (JointDefinition)linkNameToJointDefinitionMap.get(urdfGazebo.getReference());
            }
            if (jointDefinition == null) {
                LogTools.error((String)("Could not find reference: " + urdfGazebo.getReference()));
                continue;
            }
            if (sensorDefinitions == null) continue;
            sensorDefinitions.forEach(jointDefinition::addSensorDefinition);
        }
    }

    public static void simplifyKinematics(JointDefinition joint) {
        int i = 0;
        while (i < joint.getSuccessor().getChildrenJoints().size()) {
            List<JointDefinition> children = joint.getSuccessor().getChildrenJoints();
            JointDefinition child2 = children.get(i);
            if (!(child2 instanceof FixedJointDefinition)) {
                ++i;
            }
            URDFTools.simplifyKinematics(child2);
        }
        JointDefinition parentJoint = joint.getParentJoint();
        if (parentJoint == null) {
            return;
        }
        if (joint instanceof FixedJointDefinition) {
            RigidBodyDefinition rigidBody = joint.getSuccessor();
            YawPitchRollTransformDefinition transformToParentJoint = joint.getTransformToParent();
            rigidBody.applyTransform((Transform)transformToParentJoint);
            RigidBodyDefinition oldParentRigidBody = parentJoint.getSuccessor();
            parentJoint.setSuccessor(URDFTools.merge(oldParentRigidBody.getName(), oldParentRigidBody, rigidBody));
            parentJoint.getSuccessor().addChildJoints(oldParentRigidBody.getChildrenJoints());
            joint.getKinematicPointDefinitions().removeIf(kp -> {
                kp.applyTransform((Transform)transformToParentJoint);
                parentJoint.addKinematicPointDefinition((KinematicPointDefinition)kp);
                return true;
            });
            joint.getExternalWrenchPointDefinitions().removeIf(efp -> {
                efp.applyTransform((Transform)transformToParentJoint);
                parentJoint.addExternalWrenchPointDefinition((ExternalWrenchPointDefinition)efp);
                return true;
            });
            joint.getGroundContactPointDefinitions().removeIf(gcp -> {
                gcp.applyTransform((Transform)transformToParentJoint);
                parentJoint.addGroundContactPointDefinition((GroundContactPointDefinition)gcp);
                return true;
            });
            joint.getSensorDefinitions().removeIf(sensor -> {
                sensor.applyTransform((Transform)transformToParentJoint);
                parentJoint.addSensorDefinition((SensorDefinition)sensor);
                return true;
            });
            joint.getSuccessor().getChildrenJoints().removeIf(child -> {
                child.getTransformToParent().preMultiply((RigidBodyTransformReadOnly)transformToParentJoint);
                parentJoint.getSuccessor().addChildJoint((JointDefinition)child);
                return true;
            });
            parentJoint.getSuccessor().removeChildJoint(joint);
        }
    }

    public static RigidBodyDefinition merge(String name, RigidBodyDefinition rigidBodyA, RigidBodyDefinition rigidBodyB) {
        double mergedMass = rigidBodyA.getMass() + rigidBodyB.getMass();
        Vector3D mergedCoM = new Vector3D();
        mergedCoM.setAndScale(rigidBodyA.getMass(), (Tuple3DReadOnly)rigidBodyA.getCenterOfMassOffset());
        mergedCoM.scaleAdd(rigidBodyB.getMass(), (Tuple3DReadOnly)rigidBodyB.getCenterOfMassOffset(), (Tuple3DReadOnly)mergedCoM);
        mergedCoM.scale(1.0 / mergedMass);
        Vector3D translationInertiaA = new Vector3D();
        translationInertiaA.sub((Tuple3DReadOnly)mergedCoM, (Tuple3DReadOnly)rigidBodyA.getCenterOfMassOffset());
        Matrix3D inertiaA = new Matrix3D((Matrix3DReadOnly)rigidBodyA.getMomentOfInertia());
        URDFTools.translateMomentOfInertia(rigidBodyA.getMass(), (Tuple3DReadOnly)translationInertiaA, (Matrix3DBasics)inertiaA);
        Vector3D translationInertiaB = new Vector3D();
        translationInertiaB.sub((Tuple3DReadOnly)mergedCoM, (Tuple3DReadOnly)rigidBodyB.getCenterOfMassOffset());
        Matrix3D inertiaB = new Matrix3D((Matrix3DReadOnly)rigidBodyB.getMomentOfInertia());
        URDFTools.translateMomentOfInertia(rigidBodyB.getMass(), (Tuple3DReadOnly)translationInertiaB, (Matrix3DBasics)inertiaB);
        Matrix3D mergedInertia = new Matrix3D();
        mergedInertia.add((Matrix3DReadOnly)inertiaA);
        mergedInertia.add((Matrix3DReadOnly)inertiaB);
        RigidBodyDefinition merged = new RigidBodyDefinition(name);
        merged.setMass(mergedMass);
        merged.getInertiaPose().getTranslation().set(mergedCoM);
        merged.getMomentOfInertia().set((Matrix3DReadOnly)mergedInertia);
        ArrayList<VisualDefinition> mergedGraphics = new ArrayList<VisualDefinition>();
        mergedGraphics.addAll(rigidBodyA.getVisualDefinitions());
        mergedGraphics.addAll(rigidBodyB.getVisualDefinitions());
        merged.addVisualDefinitions(mergedGraphics);
        return merged;
    }

    public static void translateMomentOfInertia(double mass, Tuple3DReadOnly translation, Matrix3DBasics momentOfInertiaToTransform) {
        double xp = translation.getX();
        double yp = translation.getY();
        double zp = translation.getZ();
        double xp_xp = xp * xp;
        double yp_yp = yp * yp;
        double zp_zp = zp * zp;
        double txx = mass * (yp_yp + zp_zp);
        double tyy = mass * (xp_xp + zp_zp);
        double tzz = mass * (xp_xp + yp_yp);
        double txy = -mass * xp * yp;
        double txz = -mass * xp * zp;
        double tyz = -mass * yp * zp;
        double m00 = momentOfInertiaToTransform.getM00() + txx;
        double m01 = momentOfInertiaToTransform.getM01() + txy;
        double m02 = momentOfInertiaToTransform.getM02() + txz;
        double m10 = momentOfInertiaToTransform.getM10() + txy;
        double m11 = momentOfInertiaToTransform.getM11() + tyy;
        double m12 = momentOfInertiaToTransform.getM12() + tyz;
        double m20 = momentOfInertiaToTransform.getM20() + txz;
        double m21 = momentOfInertiaToTransform.getM21() + tyz;
        double m22 = momentOfInertiaToTransform.getM22() + tzz;
        momentOfInertiaToTransform.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public static RigidBodyDefinition connectKinematics(List<RigidBodyDefinition> rigidBodyDefinitions, List<JointDefinition> jointDefinitions, List<URDFJoint> urdfJoints) {
        Map rigidBodyDefinitionMap = rigidBodyDefinitions.stream().collect(Collectors.toMap(RigidBodyDefinition::getName, Function.identity()));
        Map jointDefinitionMap = jointDefinitions.stream().collect(Collectors.toMap(JointDefinition::getName, Function.identity()));
        if (urdfJoints != null) {
            for (URDFJoint urdfJoint2 : urdfJoints) {
                URDFLinkReference parent = urdfJoint2.getParent();
                URDFLinkReference child = urdfJoint2.getChild();
                RigidBodyDefinition parentRigidBodyDefinition = (RigidBodyDefinition)rigidBodyDefinitionMap.get(parent.getLink());
                RigidBodyDefinition childRigidBodyDefinition = (RigidBodyDefinition)rigidBodyDefinitionMap.get(child.getLink());
                JointDefinition jointDefinition = (JointDefinition)jointDefinitionMap.get(urdfJoint2.getName());
                jointDefinition.setSuccessor(childRigidBodyDefinition);
                parentRigidBodyDefinition.addChildJoint(jointDefinition);
            }
        }
        if (urdfJoints == null) {
            return rigidBodyDefinitions.get(0);
        }
        Map childToParentJoint = urdfJoints.stream().collect(Collectors.toMap(urdfJoint -> urdfJoint.getChild().getLink(), Function.identity()));
        String rootBodyName = urdfJoints.iterator().next().getParent().getLink();
        URDFJoint parentJoint = (URDFJoint)childToParentJoint.get(rootBodyName);
        while (parentJoint != null) {
            rootBodyName = parentJoint.getParent().getLink();
            parentJoint = (URDFJoint)childToParentJoint.get(rootBodyName);
        }
        return (RigidBodyDefinition)rigidBodyDefinitionMap.get(rootBodyName);
    }

    public static void correctTransforms(JointDefinition jointDefinition) {
        Orientation3DBasics jointRotation = jointDefinition.getTransformToParent().getRotation();
        if (jointDefinition instanceof OneDoFJointDefinition) {
            jointRotation.transform((Tuple3DBasics)((OneDoFJointDefinition)jointDefinition).getAxis());
        }
        RigidBodyDefinition linkDefinition = jointDefinition.getSuccessor();
        YawPitchRollTransformDefinition inertiaPose = linkDefinition.getInertiaPose();
        inertiaPose.prependOrientation((Orientation3DReadOnly)jointRotation);
        inertiaPose.transform(linkDefinition.getMomentOfInertia());
        inertiaPose.getRotation().setToZero();
        for (KinematicPointDefinition kinematicPointDefinition : jointDefinition.getKinematicPointDefinitions()) {
            kinematicPointDefinition.getTransformToParent().prependOrientation((Orientation3DReadOnly)jointRotation);
        }
        for (ExternalWrenchPointDefinition externalWrenchPointDefinition : jointDefinition.getExternalWrenchPointDefinitions()) {
            externalWrenchPointDefinition.getTransformToParent().prependOrientation((Orientation3DReadOnly)jointRotation);
        }
        for (GroundContactPointDefinition groundContactPointDefinition : jointDefinition.getGroundContactPointDefinitions()) {
            groundContactPointDefinition.getTransformToParent().prependOrientation((Orientation3DReadOnly)jointRotation);
        }
        for (SensorDefinition sensorDefinition : jointDefinition.getSensorDefinitions()) {
            sensorDefinition.getTransformToJoint().prependOrientation((Orientation3DReadOnly)jointRotation);
        }
        for (VisualDefinition visualDefinition : linkDefinition.getVisualDefinitions()) {
            visualDefinition.getOriginPose().prependOrientation((Orientation3DReadOnly)jointRotation);
        }
        for (JointDefinition childDefinition : jointDefinition.getSuccessor().getChildrenJoints()) {
            childDefinition.getTransformToParent().prependOrientation((Orientation3DReadOnly)jointRotation);
            URDFTools.correctTransforms(childDefinition);
        }
        jointRotation.setToZero();
    }

    public static RigidBodyDefinition toRigidBodyDefinition(URDFLink urdfLink) {
        RigidBodyDefinition definition = new RigidBodyDefinition(urdfLink.getName());
        URDFInertial urdfInertial = urdfLink.getInertial();
        if (urdfInertial == null) {
            definition.setMass(URDFTools.parseMass(null));
            definition.getMomentOfInertia().set((Matrix3DReadOnly)URDFTools.parseMomentOfInertia(null));
            definition.getInertiaPose().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(null));
        } else {
            definition.setMass(URDFTools.parseMass(urdfInertial.getMass()));
            definition.getMomentOfInertia().set((Matrix3DReadOnly)URDFTools.parseMomentOfInertia(urdfInertial.getInertia()));
            definition.getInertiaPose().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfInertial.getOrigin()));
        }
        if (urdfLink.getVisual() != null) {
            urdfLink.getVisual().stream().map(URDFTools::toVisualDefinition).forEach(definition::addVisualDefinition);
        }
        return definition;
    }

    public static JointDefinition toJointDefinition(URDFJoint urdfJoint) {
        switch (urdfJoint.getType()) {
            case "continuous": {
                return URDFTools.toRevoluteJointDefinition(urdfJoint, true);
            }
            case "revolute": {
                return URDFTools.toRevoluteJointDefinition(urdfJoint, false);
            }
            case "prismatic": {
                return URDFTools.toPrismaticJointDefinition(urdfJoint);
            }
            case "fixed": {
                return URDFTools.toFixedJointDefinition(urdfJoint);
            }
            case "floating": {
                return URDFTools.toSixDoFJointDefinition(urdfJoint);
            }
            case "planar": {
                return URDFTools.toPlanarJointDefinition(urdfJoint);
            }
        }
        throw new RuntimeException("Unexpected value for the joint type: " + urdfJoint.getType());
    }

    public static RevoluteJointDefinition toRevoluteJointDefinition(URDFJoint urdfJoint, boolean ignorePositionLimits) {
        RevoluteJointDefinition definition = new RevoluteJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin()));
        definition.getAxis().set(URDFTools.parseAxis(urdfJoint.getAxis()));
        URDFTools.parseLimit(urdfJoint.getLimit(), definition, ignorePositionLimits);
        URDFTools.parseDynamics(urdfJoint.getDynamics(), definition);
        return definition;
    }

    public static PrismaticJointDefinition toPrismaticJointDefinition(URDFJoint urdfJoint) {
        PrismaticJointDefinition definition = new PrismaticJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin()));
        definition.getAxis().set(URDFTools.parseAxis(urdfJoint.getAxis()));
        URDFTools.parseLimit(urdfJoint.getLimit(), definition, false);
        URDFTools.parseDynamics(urdfJoint.getDynamics(), definition);
        return definition;
    }

    public static FixedJointDefinition toFixedJointDefinition(URDFJoint urdfJoint) {
        FixedJointDefinition definition = new FixedJointDefinition(urdfJoint.getName());
        RigidBodyTransform parseRigidBodyTransform = URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)parseRigidBodyTransform);
        return definition;
    }

    public static SixDoFJointDefinition toSixDoFJointDefinition(URDFJoint urdfJoint) {
        SixDoFJointDefinition definition = new SixDoFJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin()));
        return definition;
    }

    public static PlanarJointDefinition toPlanarJointDefinition(URDFJoint urdfJoint) {
        PlanarJointDefinition definition = new PlanarJointDefinition(urdfJoint.getName());
        definition.getTransformToParent().set((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfJoint.getOrigin()));
        Vector3D surfaceNormal = URDFTools.parseAxis(urdfJoint.getAxis());
        if (!surfaceNormal.geometricallyEquals((Vector3DReadOnly)Axis3D.Y, 1.0E-5)) {
            throw new UnsupportedOperationException("Planar joint are supported only with a surface normal equal to: " + EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)Axis3D.Y) + ", received:" + surfaceNormal);
        }
        return definition;
    }

    public static List<SensorDefinition> toSensorDefinition(URDFSensor urdfSensor) {
        ArrayList<SensorDefinition> definitions = new ArrayList<SensorDefinition>();
        switch (urdfSensor.getType()) {
            case "camera": 
            case "multicamera": 
            case "depth": {
                definitions.addAll(URDFTools.toCameraSensorDefinition(urdfSensor.getCamera()));
                break;
            }
            case "imu": {
                definitions.add(URDFTools.toIMUSensorDefinition(urdfSensor.getImu()));
                break;
            }
            case "gpu_ray": 
            case "ray": {
                definitions.add(URDFTools.toLidarSensorDefinition(urdfSensor.getRay()));
                break;
            }
            case "force_torque": {
                definitions.add(new WrenchSensorDefinition());
                break;
            }
            default: {
                LogTools.error((String)("Unsupport sensor type: " + urdfSensor.getType()));
                return null;
            }
        }
        int updatePeriod = urdfSensor.getUpdateRate() == null ? -1 : (int)(1000.0 / URDFTools.parseDouble(urdfSensor.getUpdateRate(), 1000.0));
        for (SensorDefinition definition : definitions) {
            if (definition.getName() != null && !definition.getName().isEmpty()) {
                definition.setName(urdfSensor.getName() + "_" + definition.getName());
            } else {
                definition.setName(urdfSensor.getName());
            }
            definition.getTransformToJoint().preMultiply((RigidBodyTransformReadOnly)URDFTools.parsePose(urdfSensor.getPose()));
            definition.setUpdatePeriod(updatePeriod);
        }
        return definitions;
    }

    public static List<CameraSensorDefinition> toCameraSensorDefinition(List<URDFSensor.URDFCamera> urdfCameras) {
        return urdfCameras.stream().map(URDFTools::toCameraSensorDefinition).collect(Collectors.toList());
    }

    public static CameraSensorDefinition toCameraSensorDefinition(URDFSensor.URDFCamera urdfCamera) {
        CameraSensorDefinition definition = new CameraSensorDefinition();
        definition.setName(urdfCamera.getName());
        definition.getTransformToJoint().set((RigidBodyTransformReadOnly)URDFTools.parsePose(urdfCamera.getPose()));
        definition.setFieldOfView(URDFTools.parseDouble(urdfCamera.getHorizontalFov(), Double.NaN));
        definition.setClipNear(URDFTools.parseDouble(urdfCamera.getClip().getNear(), Double.NaN));
        definition.setClipFar(URDFTools.parseDouble(urdfCamera.getClip().getFar(), Double.NaN));
        definition.setImageWidth(URDFTools.parseInteger(urdfCamera.getImage().getWidth(), -1));
        definition.setImageHeight(URDFTools.parseInteger(urdfCamera.getImage().getHeight(), -1));
        return definition;
    }

    public static LidarSensorDefinition toLidarSensorDefinition(URDFSensor.URDFRay urdfRay) {
        LidarSensorDefinition definition = new LidarSensorDefinition();
        URDFSensor.URDFRay.URDFRange urdfRange = urdfRay.getRange();
        double urdfRangeMax = URDFTools.parseDouble(urdfRange.getMax(), Double.NaN);
        double urdfRangeMin = URDFTools.parseDouble(urdfRange.getMin(), Double.NaN);
        double urdfRangeResolution = URDFTools.parseDouble(urdfRange.getResolution(), Double.NaN);
        URDFSensor.URDFRay.URDFScan.URDFHorizontalScan urdfHorizontalScan = urdfRay.getScan().getHorizontal();
        URDFSensor.URDFRay.URDFScan.URDFVerticalScan urdfVerticalScan = urdfRay.getScan().getVertical();
        double maxSweepAngle = URDFTools.parseDouble(urdfHorizontalScan.getMaxAngle(), 0.0);
        double minSweepAngle = URDFTools.parseDouble(urdfHorizontalScan.getMinAngle(), 0.0);
        double maxHeightAngle = urdfVerticalScan == null ? 0.0 : URDFTools.parseDouble(urdfVerticalScan.getMaxAngle(), 0.0);
        double minHeightAngle = urdfVerticalScan == null ? 0.0 : URDFTools.parseDouble(urdfVerticalScan.getMinAngle(), 0.0);
        int samples = URDFTools.parseInteger(urdfHorizontalScan.getSamples(), -1) / 3 * 3;
        int scanHeight = urdfVerticalScan == null ? 1 : URDFTools.parseInteger(urdfVerticalScan.getSamples(), 1);
        URDFSensor.URDFRay.URDFNoise urdfNoise = urdfRay.getNoise();
        if (urdfNoise != null) {
            if ("gaussian".equals(urdfNoise.getType())) {
                definition.setGaussianNoiseMean(URDFTools.parseDouble(urdfNoise.getMean(), 0.0));
                definition.setGaussianNoiseStandardDeviation(URDFTools.parseDouble(urdfNoise.getStddev(), 0.0));
            } else {
                LogTools.error((String)"Unknown noise model: {}.", (Object)urdfNoise.getType());
            }
        }
        definition.getTransformToJoint().set((RigidBodyTransformReadOnly)URDFTools.parsePose(urdfRay.getPose()));
        definition.setPointsPerSweep(samples);
        definition.setSweepYawLimits(minSweepAngle, maxSweepAngle);
        definition.setHeightPitchLimits(minHeightAngle, maxHeightAngle);
        definition.setRangeLimits(urdfRangeMin, urdfRangeMax);
        definition.setRangeResolution(urdfRangeResolution);
        definition.setScanHeight(scanHeight);
        return definition;
    }

    public static IMUSensorDefinition toIMUSensorDefinition(URDFSensor.URDFIMU urdfIMU) {
        IMUSensorDefinition definition = new IMUSensorDefinition();
        URDFSensor.URDFIMU.URDFIMUNoise urdfNoise = urdfIMU.getNoise();
        if (urdfNoise != null) {
            if ("gaussian".equals(urdfNoise.getType())) {
                URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters accelerationNoise = urdfNoise.getAccel();
                URDFSensor.URDFIMU.URDFIMUNoise.URDFNoiseParameters angularVelocityNoise = urdfNoise.getRate();
                definition.setAccelerationNoiseParameters(URDFTools.parseDouble(accelerationNoise.getMean(), 0.0), URDFTools.parseDouble(accelerationNoise.getStddev(), 0.0));
                definition.setAccelerationBiasParameters(URDFTools.parseDouble(accelerationNoise.getBias_mean(), 0.0), URDFTools.parseDouble(accelerationNoise.getBias_stddev(), 0.0));
                definition.setAngularVelocityNoiseParameters(URDFTools.parseDouble(angularVelocityNoise.getMean(), 0.0), URDFTools.parseDouble(angularVelocityNoise.getStddev(), 0.0));
                definition.setAngularVelocityBiasParameters(URDFTools.parseDouble(angularVelocityNoise.getBias_mean(), 0.0), URDFTools.parseDouble(angularVelocityNoise.getBias_stddev(), 0.0));
            } else {
                LogTools.error((String)"Unknown IMU noise model: {}.", (Object)urdfNoise.getType());
            }
        }
        return definition;
    }

    public static VisualDefinition toVisualDefinition(URDFVisual urdfVisual) {
        if (urdfVisual == null) {
            return null;
        }
        VisualDefinition visualDefinition = new VisualDefinition();
        visualDefinition.setName(urdfVisual.getName());
        visualDefinition.setOriginPose((RigidBodyTransformReadOnly)URDFTools.parseRigidBodyTransform(urdfVisual.getOrigin()));
        visualDefinition.setMaterialDefinition(URDFTools.toMaterialDefinition(urdfVisual.getMaterial()));
        visualDefinition.setGeometryDefinition(URDFTools.toGeometryDefinition(urdfVisual.getGeometry()));
        return visualDefinition;
    }

    public static GeometryDefinition toGeometryDefinition(URDFGeometry urdfGeometry) {
        return URDFTools.toGeometryDefinition(urdfGeometry, Collections.emptyList());
    }

    public static GeometryDefinition toGeometryDefinition(URDFGeometry urdfGeometry, List<String> resourceDirectories) {
        if (urdfGeometry.getBox() != null) {
            Box3DDefinition boxGeometryDefinition = new Box3DDefinition();
            boxGeometryDefinition.setSize((Tuple3DReadOnly)URDFTools.parseVector3D(urdfGeometry.getBox().getSize(), null));
            return boxGeometryDefinition;
        }
        if (urdfGeometry.getCylinder() != null) {
            Cylinder3DDefinition cylinderGeometryDefinition = new Cylinder3DDefinition();
            cylinderGeometryDefinition.setRadius(URDFTools.parseDouble(urdfGeometry.getCylinder().getRadius(), 0.0));
            cylinderGeometryDefinition.setLength(URDFTools.parseDouble(urdfGeometry.getCylinder().getLength(), 0.0));
            return cylinderGeometryDefinition;
        }
        if (urdfGeometry.getSphere() != null) {
            Sphere3DDefinition sphereGeometryDefinition = new Sphere3DDefinition();
            sphereGeometryDefinition.setRadius(URDFTools.parseDouble(urdfGeometry.getSphere().getRadius(), 0.0));
            return sphereGeometryDefinition;
        }
        if (urdfGeometry.getMesh() != null) {
            ModelFileGeometryDefinition modelFileGeometryDefinition = new ModelFileGeometryDefinition();
            modelFileGeometryDefinition.setResourceDirectories(resourceDirectories);
            modelFileGeometryDefinition.setFileName(urdfGeometry.getMesh().getFilename());
            modelFileGeometryDefinition.setScale(URDFTools.parseVector3D(urdfGeometry.getMesh().getScale(), new Vector3D(1.0, 1.0, 1.0)));
            return modelFileGeometryDefinition;
        }
        throw new IllegalArgumentException("The given URDF Geometry is empty.");
    }

    public static MaterialDefinition toMaterialDefinition(URDFMaterial urdfMaterial) {
        if (urdfMaterial == null) {
            return null;
        }
        MaterialDefinition materialDefinition = new MaterialDefinition();
        materialDefinition.setName(urdfMaterial.getName());
        materialDefinition.setDiffuseColor(URDFTools.toColorDefinition(urdfMaterial.getColor()));
        materialDefinition.setDiffuseMap(URDFTools.toTextureDefinition(urdfMaterial.getTexture()));
        return materialDefinition;
    }

    public static TextureDefinition toTextureDefinition(URDFTexture urdfTexture) {
        if (urdfTexture == null) {
            return null;
        }
        TextureDefinition textureDefinition = new TextureDefinition();
        textureDefinition.setFilename(urdfTexture.getFilename());
        return textureDefinition;
    }

    public static ColorDefinition toColorDefinition(URDFColor urdfColor) {
        if (urdfColor == null) {
            return null;
        }
        double[] colorArray = URDFTools.parseArray(urdfColor.getRGBA(), null);
        if (colorArray == null) {
            return null;
        }
        if (colorArray.length < 4) {
            return ColorDefinitions.rgb(colorArray);
        }
        return ColorDefinitions.rgba(colorArray);
    }

    public static RigidBodyTransform parsePose(String pose) {
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        if (pose != null) {
            String[] split = pose.split("\\s+");
            Vector3D position = new Vector3D(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
            YawPitchRoll orientation = new YawPitchRoll(Double.parseDouble(split[5]), Double.parseDouble(split[4]), Double.parseDouble(split[3]));
            rigidBodyTransform.set((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position);
        }
        return rigidBodyTransform;
    }

    public static RigidBodyTransform parseRigidBodyTransform(URDFOrigin origin) {
        if (origin == null) {
            origin = new URDFOrigin();
        }
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        rigidBodyTransform.getTranslation().set((Tuple3DReadOnly)URDFTools.parseVector3D(origin.getXYZ(), DEFAULT_ORIGIN_XYZ));
        rigidBodyTransform.getRotation().setEuler((Vector3DReadOnly)URDFTools.parseVector3D(origin.getRPY(), DEFAULT_ORIGIN_RPY));
        return rigidBodyTransform;
    }

    public static Matrix3D parseMomentOfInertia(URDFInertia inertia) {
        if (inertia == null) {
            inertia = new URDFInertia();
        }
        Matrix3D momentOfInertia = new Matrix3D();
        double ixx = URDFTools.parseDouble(inertia.getIxx(), 0.0);
        double iyy = URDFTools.parseDouble(inertia.getIyy(), 0.0);
        double izz = URDFTools.parseDouble(inertia.getIzz(), 0.0);
        double ixy = URDFTools.parseDouble(inertia.getIxy(), 0.0);
        double ixz = URDFTools.parseDouble(inertia.getIxz(), 0.0);
        double iyz = URDFTools.parseDouble(inertia.getIyz(), 0.0);
        momentOfInertia.setM00(ixx);
        momentOfInertia.setM11(iyy);
        momentOfInertia.setM22(izz);
        momentOfInertia.setM01(ixy);
        momentOfInertia.setM02(ixz);
        momentOfInertia.setM12(iyz);
        momentOfInertia.setM10(ixy);
        momentOfInertia.setM20(ixz);
        momentOfInertia.setM21(iyz);
        return momentOfInertia;
    }

    public static double parseMass(URDFMass urdfMass) {
        if (urdfMass == null) {
            return 0.0;
        }
        return URDFTools.parseDouble(urdfMass.getValue(), 0.0);
    }

    public static void parseLimit(URDFLimit urdfLimit, OneDoFJointDefinition jointDefinitionToParseLimitInto, boolean ignorePositionLimits) {
        jointDefinitionToParseLimitInto.setPositionLimits(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        jointDefinitionToParseLimitInto.setEffortLimits(Double.POSITIVE_INFINITY);
        jointDefinitionToParseLimitInto.setVelocityLimits(Double.POSITIVE_INFINITY);
        if (urdfLimit != null) {
            double velocityLimit;
            double effortLimit;
            double positionUpperLimit;
            double positionLowerLimit;
            if (!ignorePositionLimits && (positionLowerLimit = URDFTools.parseDouble(urdfLimit.getLower(), Double.NEGATIVE_INFINITY)) < (positionUpperLimit = URDFTools.parseDouble(urdfLimit.getUpper(), Double.POSITIVE_INFINITY))) {
                jointDefinitionToParseLimitInto.setPositionLimits(positionLowerLimit, positionUpperLimit);
            }
            if (Double.isFinite(effortLimit = URDFTools.parseDouble(urdfLimit.getEffort(), Double.POSITIVE_INFINITY)) && effortLimit >= 0.0) {
                jointDefinitionToParseLimitInto.setEffortLimits(effortLimit);
            }
            if (Double.isFinite(velocityLimit = URDFTools.parseDouble(urdfLimit.getVelocity(), Double.POSITIVE_INFINITY)) && velocityLimit >= 0.0) {
                jointDefinitionToParseLimitInto.setVelocityLimits(velocityLimit);
            }
        }
    }

    public static void parseDynamics(URDFDynamics urdfDynamics, OneDoFJointDefinition jointDefinitionToParseDynamicsInto) {
        double damping = 0.0;
        double stiction = 0.0;
        if (urdfDynamics != null) {
            damping = URDFTools.parseDouble(urdfDynamics.getDamping(), 0.0);
            stiction = URDFTools.parseDouble(urdfDynamics.getFriction(), 0.0);
        }
        jointDefinitionToParseDynamicsInto.setDamping(damping);
        jointDefinitionToParseDynamicsInto.setStiction(stiction);
    }

    public static Vector3D parseAxis(URDFAxis axis) {
        if (axis == null) {
            return new Vector3D((Tuple3DReadOnly)DEFAULT_AXIS);
        }
        Vector3D parsedAxis = URDFTools.parseVector3D(axis.getXYZ(), new Vector3D((Tuple3DReadOnly)DEFAULT_AXIS));
        parsedAxis.normalize();
        return parsedAxis;
    }

    public static double parseDouble(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static int parseInteger(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Vector3D parseVector3D(String value, Vector3D defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String[] split = value.split("\\s+");
        Vector3D vector = new Vector3D();
        vector.setX(Double.parseDouble(split[0]));
        vector.setY(Double.parseDouble(split[1]));
        vector.setZ(Double.parseDouble(split[2]));
        return vector;
    }

    public static double[] parseArray(String value, double[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String[] split = value.split("\\s+");
        double[] array = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            array[i] = Double.parseDouble(split[i]);
        }
        return array;
    }
}

