/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Point2DDefinition;

public class Polygon2DDefinition
extends GeometryDefinition {
    private List<Point2DDefinition> polygonVertices = new ArrayList<Point2DDefinition>();
    private boolean counterClockwiseOrdered;

    public Polygon2DDefinition() {
        this.setName("polygon2D");
    }

    public Polygon2DDefinition(List<Point2DDefinition> polygonVertices, boolean counterClockwiseOrdered) {
        this();
        this.polygonVertices = polygonVertices;
        this.counterClockwiseOrdered = counterClockwiseOrdered;
    }

    public Polygon2DDefinition(Polygon2DDefinition other) {
        this.setName(other.getName());
        if (other.polygonVertices != null) {
            this.polygonVertices = other.polygonVertices.stream().map(Point2DDefinition::new).collect(Collectors.toList());
        }
        this.counterClockwiseOrdered = other.counterClockwiseOrdered;
    }

    public static List<Point2DDefinition> toPoint2DDefinitionList(Collection<? extends Tuple2DReadOnly> tuple2DCollection) {
        return tuple2DCollection.stream().map(Point2DDefinition::new).collect(Collectors.toList());
    }

    public static List<Point2DDefinition> toPoint2DDefinitionList(Tuple2DReadOnly ... tuple2Ds) {
        return Polygon2DDefinition.toPoint2DDefinitionList(Arrays.asList(tuple2Ds));
    }

    @XmlElement
    public void setPolygonVertices(List<Point2DDefinition> polygonVertices) {
        this.polygonVertices = polygonVertices;
    }

    @XmlElement
    public void setCounterClockwiseOrdered(boolean counterClockwiseOrdered) {
        this.counterClockwiseOrdered = counterClockwiseOrdered;
    }

    public List<Point2DDefinition> getPolygonVertices() {
        return this.polygonVertices;
    }

    public boolean isCounterClockwiseOrdered() {
        return this.counterClockwiseOrdered;
    }

    @Override
    public Polygon2DDefinition copy() {
        return new Polygon2DDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.polygonVertices);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (boolean)this.counterClockwiseOrdered);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Polygon2DDefinition other = (Polygon2DDefinition)object;
        if (!Objects.equals(this.polygonVertices, other.polygonVertices)) {
            return false;
        }
        return this.counterClockwiseOrdered == other.counterClockwiseOrdered;
    }

    public String toString() {
        String ordering = this.counterClockwiseOrdered ? "counter-clockwise" : "clockwise";
        return "Polygon 2D: [name: " + this.getName() + ", " + ordering + ", vertices: " + EuclidCoreIOTools.getCollectionString((String)"[", (String)"]", (String)", ", this.polygonVertices, Object::toString);
    }
}

