/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.Tetrahedron3DDefinition;
import us.ihmc.scs2.definition.geometry.TriangleMesh3DDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinitionColorPalette;
import us.ihmc.scs2.definition.visual.TextureDefinitionColorPalette2D;
import us.ihmc.scs2.definition.visual.TriangleMesh3DBuilder;
import us.ihmc.scs2.definition.visual.TriangleMesh3DFactories;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class MultiColorTriangleMesh3DBuilder {
    private final TriangleMesh3DBuilder meshBuilder = new TriangleMesh3DBuilder();
    private TextureDefinitionColorPalette colorPalette;

    public MultiColorTriangleMesh3DBuilder() {
        this.colorPalette = new TextureDefinitionColorPalette2D();
    }

    public MultiColorTriangleMesh3DBuilder(TextureDefinitionColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void addTriangleMesh3D(TriangleMesh3DDefinition triangleMesh, ColorDefinition color) {
        this.addTriangleMesh3D(triangleMesh, null, null, color);
    }

    public void addTriangleMesh3D(TriangleMesh3DDefinition triangleMesh, Tuple3DReadOnly offset, ColorDefinition color) {
        this.addTriangleMesh3D(triangleMesh, offset, null, color);
    }

    public void addTriangleMesh3D(TriangleMesh3DDefinition triangleMesh, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, ColorDefinition color) {
        this.meshBuilder.addTriangleMesh3D(this.setColor(triangleMesh, color), offset, orientation);
    }

    private TriangleMesh3DDefinition setColor(TriangleMesh3DDefinition input, ColorDefinition color) {
        if (input == null) {
            return null;
        }
        Point3D32[] vertices = input.getVertices();
        int[] triangleIndices = input.getTriangleIndices();
        Vector3D32[] normals = input.getNormals();
        Object[] textures = new Point2D32[input.getTextures().length];
        Arrays.fill(textures, this.colorPalette.getTextureLocation(color));
        return new TriangleMesh3DDefinition(vertices, (Point2D32[])textures, normals, triangleIndices);
    }

    public void addGeometry(GeometryDefinition geometry, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, ColorDefinition color) {
        this.addTriangleMesh3D(TriangleMesh3DFactories.TriangleMesh(geometry), offset, orientation, color);
    }

    public void addBox(double sizeX, double sizeY, double sizeZ, ColorDefinition color) {
        this.addBox(sizeX, sizeY, sizeZ, null, null, color);
    }

    public void addBox(double sizeX, double sizeY, double sizeZ, Tuple3DReadOnly offset, ColorDefinition color) {
        this.addBox(sizeX, sizeY, sizeZ, offset, null, color);
    }

    public void addBox(double sizeX, double sizeY, double sizeZ, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, ColorDefinition color) {
        this.addGeometry(new Box3DDefinition(sizeX, sizeY, sizeZ), offset, orientation, color);
    }

    public void addCapsule(double length, double radius, ColorDefinition color) {
        this.addCapsule(length, radius, null, null, color);
    }

    public void addCapsule(double length, double radius, Tuple3DReadOnly offset, ColorDefinition color) {
        this.addCapsule(length, radius, offset, null, color);
    }

    public void addCapsule(double length, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, ColorDefinition color) {
        this.addGeometry(new Capsule3DDefinition(length, radius), offset, orientation, color);
    }

    public void addCone(double height, double radius, ColorDefinition color) {
        this.addCone(height, radius, null, null, color);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset, ColorDefinition color) {
        this.addCone(height, radius, offset, null, color);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, ColorDefinition color) {
        this.addGeometry(new Cone3DDefinition(height, radius), offset, orientation, color);
    }

    public void addCylinder(double length, double radius, ColorDefinition color) {
        this.addCylinder(length, radius, null, null, color);
    }

    public void addCylinder(double length, double radius, Tuple3DReadOnly offset, ColorDefinition color) {
        this.addCylinder(length, radius, offset, null, color);
    }

    public void addCylinder(double length, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, ColorDefinition color) {
        this.addGeometry(new Cylinder3DDefinition(radius, length), offset, orientation, color);
    }

    public void addLine(double x0, double y0, double z0, double xf, double yf, double zf, double lineWidth, ColorDefinition color) {
        this.addTriangleMesh3D(TriangleMesh3DFactories.Line(x0, y0, z0, xf, yf, zf, lineWidth), color);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, double lineWidth, ColorDefinition color) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), lineWidth, color);
    }

    public void addMultiLine(RigidBodyTransformReadOnly transform, List<? extends Point2DReadOnly> points, double lineWidth, boolean close, ColorDefinition color) {
        List<Point3D> point3Ds = points.stream().map(Point3D::new).collect(Collectors.toList());
        point3Ds.forEach(arg_0 -> ((RigidBodyTransformReadOnly)transform).transform(arg_0));
        this.addMultiLine(point3Ds, lineWidth, close, color);
    }

    public void addMultiLine(List<? extends Point3DReadOnly> points, double lineWidth, boolean close, ColorDefinition color) {
        if (points.size() < 2) {
            return;
        }
        for (int i = 1; i < points.size(); ++i) {
            Point3DReadOnly start = points.get(i - 1);
            Point3DReadOnly end = points.get(i);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
        if (close) {
            Point3DReadOnly start = points.get(points.size() - 1);
            Point3DReadOnly end = points.get(0);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
    }

    public void addMultiLine(Point3DReadOnly[] points, double lineWidth, boolean close, ColorDefinition color) {
        if (points.length < 2) {
            return;
        }
        for (int i = 1; i < points.length; ++i) {
            Point3DReadOnly start = points[i - 1];
            Point3DReadOnly end = points[i];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
        if (close) {
            Point3DReadOnly start = points[points.length - 1];
            Point3DReadOnly end = points[0];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
    }

    public void addPolygonCounterClockwise(RigidBodyTransformReadOnly polygonPose, List<? extends Point2DReadOnly> polygon, ColorDefinition color) {
        this.addTriangleMesh3D(TriangleMesh3DFactories.PolygonCounterClockwise(polygonPose, polygon), color);
    }

    public void addPolygon(RigidBodyTransformReadOnly polygonPose, ConvexPolygon2DReadOnly polygon, ColorDefinition color) {
        this.addTriangleMesh3D(TriangleMesh3DFactories.Polygon(polygonPose, polygon), color);
    }

    public void addSphere(double radius, ColorDefinition color) {
        this.addSphere(radius, null, color);
    }

    public void addSphere(double radius, Tuple3DReadOnly offset, ColorDefinition color) {
        this.addGeometry(new Sphere3DDefinition(radius), offset, null, color);
    }

    public void addSpheres(float radius, Point3DReadOnly[] offsets, ColorDefinition color) {
        for (Point3DReadOnly point : offsets) {
            this.addSphere(radius, (Tuple3DReadOnly)point, color);
        }
    }

    public void addTetrahedron(double edgeLength, Tuple3DReadOnly offset, ColorDefinition color) {
        this.addTetrahedron(edgeLength, offset, null, color);
    }

    public void addTetrahedron(double edgeLength, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, ColorDefinition color) {
        this.addGeometry(new Tetrahedron3DDefinition(edgeLength), offset, orientation, color);
    }

    public void changeColorPalette(TextureDefinitionColorPalette2D newColorPalette) {
        this.colorPalette = newColorPalette;
    }

    public void clear() {
        this.meshBuilder.clear();
    }

    public TextureDefinition generateTexture() {
        return this.colorPalette.getTextureDefinition();
    }

    public MaterialDefinition generateMaterial() {
        return new MaterialDefinition(this.generateTexture());
    }

    public TriangleMesh3DDefinition generateTriangleMesh3D() {
        return this.meshBuilder.generateTriangleMesh3D();
    }

    public VisualDefinition generateVisual() {
        return new VisualDefinition(this.generateTriangleMesh3D(), this.generateMaterial());
    }
}

