/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state.interfaces;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateReadOnly;

public interface SixDoFJointStateBasics
extends JointStateBasics,
SixDoFJointStateReadOnly {
    public QuaternionBasics getOrientation();

    public Point3DBasics getPosition();

    public Vector3DBasics getAngularVelocity();

    public Vector3DBasics getLinearVelocity();

    public Vector3DBasics getAngularAcceleration();

    public Vector3DBasics getLinearAcceleration();

    public Vector3DBasics getTorque();

    public Vector3DBasics getForce();

    @Override
    default public void clear() {
        this.getOrientation().setToNaN();
        this.getPosition().setToNaN();
        this.getAngularVelocity().setToNaN();
        this.getLinearVelocity().setToNaN();
        this.getAngularAcceleration().setToNaN();
        this.getLinearAcceleration().setToNaN();
        this.getTorque().setToNaN();
        this.getForce().setToNaN();
    }

    default public void set(SixDoFJointStateReadOnly other) {
        this.getOrientation().set(other.getOrientation());
        this.getPosition().set((Tuple3DReadOnly)other.getPosition());
        this.getAngularVelocity().set((Tuple3DReadOnly)other.getAngularVelocity());
        this.getLinearVelocity().set((Tuple3DReadOnly)other.getLinearVelocity());
        this.getAngularAcceleration().set((Tuple3DReadOnly)other.getAngularAcceleration());
        this.getLinearAcceleration().set((Tuple3DReadOnly)other.getLinearAcceleration());
        this.getTorque().set((Tuple3DReadOnly)other.getTorque());
        this.getForce().set((Tuple3DReadOnly)other.getForce());
    }

    default public void setConfiguration(Pose3DReadOnly configuration) {
        this.getOrientation().set(configuration.getOrientation());
        this.getPosition().set((Tuple3DReadOnly)configuration.getPosition());
    }

    default public void setConfiguration(Orientation3DReadOnly orientation, Tuple3DReadOnly position) {
        if (orientation != null) {
            this.getOrientation().set(orientation);
        } else {
            this.getOrientation().setToZero();
        }
        if (position != null) {
            this.getPosition().set(position);
        } else {
            this.getPosition().setToZero();
        }
    }

    default public void setVelocity(SpatialVectorReadOnly velocity) {
        this.getAngularVelocity().set((Tuple3DReadOnly)velocity.getAngularPart());
        this.getLinearVelocity().set((Tuple3DReadOnly)velocity.getLinearPart());
    }

    default public void setVelocity(Vector3DReadOnly angularVelocity, Vector3DReadOnly linearVelocity) {
        if (angularVelocity != null) {
            this.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        } else {
            this.getAngularVelocity().setToZero();
        }
        if (linearVelocity != null) {
            this.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        } else {
            this.getLinearVelocity().setToZero();
        }
    }

    default public void setAcceleration(SpatialVectorReadOnly acceleration) {
        this.getAngularAcceleration().set((Tuple3DReadOnly)acceleration.getAngularPart());
        this.getLinearAcceleration().set((Tuple3DReadOnly)acceleration.getLinearPart());
    }

    default public void setAcceleration(Vector3DReadOnly angularAcceleration, Vector3DReadOnly linearAcceleration) {
        if (angularAcceleration != null) {
            this.getAngularAcceleration().set((Tuple3DReadOnly)angularAcceleration);
        } else {
            this.getAngularAcceleration().setToZero();
        }
        if (linearAcceleration != null) {
            this.getLinearAcceleration().set((Tuple3DReadOnly)linearAcceleration);
        } else {
            this.getLinearAcceleration().setToZero();
        }
    }

    default public void setEffort(SpatialVectorReadOnly effort) {
        this.getTorque().set((Tuple3DReadOnly)effort.getAngularPart());
        this.getForce().set((Tuple3DReadOnly)effort.getLinearPart());
    }

    default public void setEffort(Vector3DReadOnly torque, Vector3DReadOnly force) {
        if (torque != null) {
            this.getTorque().set((Tuple3DReadOnly)torque);
        } else {
            this.getTorque().setToZero();
        }
        if (force != null) {
            this.getForce().set((Tuple3DReadOnly)force);
        } else {
            this.getForce().setToZero();
        }
    }

    @Override
    default public void setConfiguration(JointReadOnly joint) {
        this.setConfiguration(((SixDoFJointReadOnly)joint).getJointPose());
    }

    @Override
    default public void setVelocity(JointReadOnly joint) {
        this.setVelocity((SpatialVectorReadOnly)((SixDoFJointReadOnly)joint).getJointTwist());
    }

    @Override
    default public void setAcceleration(JointReadOnly joint) {
        this.setAcceleration((SpatialVectorReadOnly)((SixDoFJointReadOnly)joint).getJointAcceleration());
    }

    @Override
    default public void setEffort(JointReadOnly joint) {
        this.setEffort((SpatialVectorReadOnly)((SixDoFJointReadOnly)joint).getJointWrench());
    }

    @Override
    default public int setConfiguration(int startRow, DMatrix configuration) {
        this.getOrientation().set(startRow, configuration);
        this.getPosition().set(startRow + 4, configuration);
        return startRow + this.getConfigurationSize();
    }

    @Override
    default public int setVelocity(int startRow, DMatrix velocity) {
        this.getAngularVelocity().set(startRow, velocity);
        this.getLinearVelocity().set(startRow + 3, velocity);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    default public int setAcceleration(int startRow, DMatrix acceleration) {
        this.getAngularAcceleration().set(startRow, acceleration);
        this.getLinearAcceleration().set(startRow + 3, acceleration);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    default public int setEffort(int startRow, DMatrix effort) {
        this.getTorque().set(startRow, effort);
        this.getForce().set(startRow + 3, effort);
        return startRow + this.getDegreesOfFreedom();
    }
}

