/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.controller.interfaces;

import java.util.concurrent.TimeUnit;
import us.ihmc.commons.Conversions;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ControllerThrottler
implements Controller {
    private final String name;
    private final YoRegistry registry;
    private final Controller controller;
    private final YoDouble desiredControllerPeriod;
    private final YoDouble nextControllerDoControlTime;
    private DoubleProvider timeProvider;

    public ControllerThrottler(Controller controller) {
        YoRegistry controllerRegistry;
        this.controller = controller;
        String controllerName = controller.getName();
        if (controllerName == null || controllerName.isEmpty()) {
            Class<?> controllerClass = controller.getClass();
            if (!controllerClass.isAnonymousClass()) {
                controllerName = controllerClass.getSimpleName();
            } else {
                String className = controllerClass.getName();
                controllerName = className.substring(className.lastIndexOf(46) + 1).replace("$", "AnonymousController");
            }
        }
        if ((controllerRegistry = controller.getYoRegistry()) == null) {
            controllerRegistry = new YoRegistry(controllerName);
        }
        this.name = controllerName;
        this.registry = controllerRegistry;
        this.desiredControllerPeriod = new YoDouble("desiredControllerPeriod" + this.name, this.registry);
        this.nextControllerDoControlTime = new YoDouble("nextControllerDoControlTime" + this.name, this.registry);
    }

    public ControllerThrottler(Controller controller, double periodInSeconds) {
        this(controller);
        this.setDesiredControllerPeriod(periodInSeconds);
    }

    public ControllerThrottler(Controller controller, long period, TimeUnit timeUnit) {
        this(controller);
        this.setDesiredControllerPeriod(period, timeUnit);
    }

    public void setTimeProvider(DoubleProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public void setDesiredControllerPeriod(double periodInSeconds) {
        if (periodInSeconds < 0.0) {
            throw new IllegalArgumentException("The period cannot be negative: " + periodInSeconds);
        }
        this.desiredControllerPeriod.set(periodInSeconds);
    }

    public void setDesiredControllerPeriod(long period, TimeUnit timeUnit) {
        if (period < 0L) {
            throw new IllegalArgumentException("The period cannot be negative: " + period);
        }
        this.setDesiredControllerPeriod(Conversions.nanosecondsToSeconds((long)timeUnit.toNanos(period)));
    }

    @Override
    public void initialize() {
        this.nextControllerDoControlTime.set(this.timeProvider.getValue());
        this.controller.initialize();
    }

    @Override
    public void doControl() {
        if (this.timeProvider.getValue() < this.nextControllerDoControlTime.getValue()) {
            return;
        }
        this.nextControllerDoControlTime.add(this.desiredControllerPeriod.getValue());
        this.controller.doControl();
    }

    @Override
    public void pause() {
        this.controller.pause();
    }

    @Override
    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

