/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.PointShape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Torus3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.geometry.ArcTorus3DDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Capsule3DDefinition;
import us.ihmc.scs2.definition.geometry.Cone3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.Ellipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.ExtrudedPolygon2DDefinition;
import us.ihmc.scs2.definition.geometry.ExtrusionDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.HemiEllipsoid3DDefinition;
import us.ihmc.scs2.definition.geometry.ModelFileGeometryDefinition;
import us.ihmc.scs2.definition.geometry.Polygon2DDefinition;
import us.ihmc.scs2.definition.geometry.Polygon3DDefinition;
import us.ihmc.scs2.definition.geometry.PyramidBox3DDefinition;
import us.ihmc.scs2.definition.geometry.Ramp3DDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.geometry.TruncatedCone3DDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;

public class VisualDefinitionFactory {
    private static final MaterialDefinition DEFAULT_MATERIAL = new MaterialDefinition(ColorDefinitions.Black());
    private static final int RESOLUTION = 32;
    private final AffineTransform currentTransform = new AffineTransform();
    private final List<VisualDefinition> visualDefinitions = new ArrayList<VisualDefinition>();

    public List<VisualDefinition> getVisualDefinitions() {
        return this.visualDefinitions;
    }

    public void combine(VisualDefinitionFactory other) {
        this.identity();
        this.visualDefinitions.addAll(other.getVisualDefinitions());
    }

    public void identity() {
        this.currentTransform.setIdentity();
    }

    public void appendTransform(RigidBodyTransformReadOnly transform) {
        this.currentTransform.multiply(transform);
    }

    public void appendTranslation(double x, double y, double z) {
        this.currentTransform.appendTranslation(x, y, z);
    }

    public void appendTranslation(Tuple3DReadOnly translation) {
        this.currentTransform.appendTranslation(translation);
    }

    public void appendRotation(double rotationAngle, Vector3DReadOnly rotationAxis) {
        this.appendRotation((Orientation3DReadOnly)new AxisAngle(rotationAxis, rotationAngle));
    }

    public void appendRotation(Orientation3DReadOnly orientation) {
        this.currentTransform.appendOrientation(orientation);
    }

    public void appendScale(double scaleFactor) {
        this.currentTransform.appendScale(scaleFactor);
    }

    public void appendScale(Vector3DReadOnly scaleFactors) {
        this.currentTransform.appendScale((Tuple3DReadOnly)scaleFactors);
    }

    public void prependTransform(RigidBodyTransformReadOnly transform) {
        for (int i = 0; i < this.visualDefinitions.size(); ++i) {
            this.visualDefinitions.get(i).getOriginPose().preMultiply(transform);
        }
        this.currentTransform.preMultiply(transform);
    }

    public void prependTranslation(double x, double y, double z) {
        for (int i = 0; i < this.visualDefinitions.size(); ++i) {
            this.visualDefinitions.get(i).getOriginPose().prependTranslation(x, y, z);
        }
        this.currentTransform.prependTranslation(x, y, z);
    }

    public void prependTranslation(Tuple3DReadOnly translation) {
        this.prependTranslation(translation.getX(), translation.getY(), translation.getZ());
    }

    public void prependRotation(double rotationAngle, Vector3DReadOnly rotationAxis) {
        this.prependRotation((Orientation3DReadOnly)new AxisAngle(rotationAxis, rotationAngle));
    }

    public void prependRotation(Orientation3DReadOnly orientation) {
        for (int i = 0; i < this.visualDefinitions.size(); ++i) {
            this.visualDefinitions.get(i).getOriginPose().prependOrientation(orientation);
        }
        this.currentTransform.prependOrientation(orientation);
    }

    public void prependScale(double scaleFactor) {
        this.prependScale((Tuple3DReadOnly)new Vector3D(scaleFactor, scaleFactor, scaleFactor));
    }

    public void prependScale(Tuple3DReadOnly scaleFactors) {
        for (int i = 0; i < this.visualDefinitions.size(); ++i) {
            this.visualDefinitions.get(i).getOriginPose().prependScale(scaleFactors);
        }
        this.currentTransform.prependScale(scaleFactors);
    }

    public VisualDefinition addVisualDefinition(VisualDefinition instruction) {
        this.visualDefinitions.add(instruction);
        return instruction;
    }

    public VisualDefinition addGeometryDefinition(GeometryDefinition geometryDefinition, MaterialDefinition materialDefinition) {
        return this.addVisualDefinition(new VisualDefinition((AffineTransformReadOnly)new AffineTransform((AffineTransformReadOnly)this.currentTransform), geometryDefinition, materialDefinition));
    }

    public VisualDefinition addModelFile(URL fileURL) {
        return this.addModelFile(fileURL, null);
    }

    public VisualDefinition addModelFile(URL fileURL, MaterialDefinition materialDefinition) {
        if (fileURL == null) {
            LogTools.error((String)"fileURL == null in addModelFile");
            return null;
        }
        String fileName = fileURL.getFile();
        if (fileName == null || fileName.equals("")) {
            LogTools.error((String)"Null File Name in add3DSFile");
            return null;
        }
        return this.addModelFile(fileName, materialDefinition);
    }

    public VisualDefinition addModelFile(String fileName) {
        return this.addModelFile(fileName, null);
    }

    public VisualDefinition addModelFile(String fileName, MaterialDefinition materialDefinition) {
        ModelFileGeometryDefinition modelFileGeometryDefinition = new ModelFileGeometryDefinition();
        modelFileGeometryDefinition.setFileName(fileName);
        return this.addGeometryDefinition(modelFileGeometryDefinition, materialDefinition);
    }

    public VisualDefinition addModelFile(String fileName, String submesh, boolean centerSubmesh, List<String> resourceDirectories, ClassLoader resourceClassLoader, MaterialDefinition materialDefinition) {
        ModelFileGeometryDefinition modelFileGeometryDefinition = new ModelFileGeometryDefinition(fileName);
        modelFileGeometryDefinition.setResourceDirectories(resourceDirectories);
        modelFileGeometryDefinition.setSubmeshes(Collections.singletonList(new ModelFileGeometryDefinition.SubMeshDefinition(submesh, centerSubmesh)));
        modelFileGeometryDefinition.setResourceClassLoader(resourceClassLoader);
        return this.addGeometryDefinition(modelFileGeometryDefinition, materialDefinition);
    }

    public VisualDefinition addModelFile(String fileName, List<String> resourceDirectories, ClassLoader resourceClassLoader, MaterialDefinition materialDefinition) {
        return this.addModelFile(fileName, null, false, resourceDirectories, resourceClassLoader, materialDefinition);
    }

    public void addCoordinateSystem(double length) {
        this.addCoordinateSystem(length, new MaterialDefinition(ColorDefinitions.Gray()));
    }

    public void addCoordinateSystem(double length, MaterialDefinition materialDefinition) {
        this.addCoordinateSystem(length, new MaterialDefinition(ColorDefinitions.Red()), new MaterialDefinition(ColorDefinitions.White()), new MaterialDefinition(ColorDefinitions.Blue()), materialDefinition);
    }

    public void addCoordinateSystem(double length, MaterialDefinition xAxisMaterial, MaterialDefinition yAxisMaterial, MaterialDefinition zAxisMaterial, MaterialDefinition arrowMaterial) {
        this.appendRotation(1.5707963267948966, (Vector3DReadOnly)Axis3D.Y);
        this.addArrow(length, xAxisMaterial, arrowMaterial);
        this.appendRotation(-1.5707963267948966, (Vector3DReadOnly)Axis3D.Y);
        this.appendRotation(-1.5707963267948966, (Vector3DReadOnly)Axis3D.X);
        this.addArrow(length, yAxisMaterial, arrowMaterial);
        this.appendRotation(1.5707963267948966, (Vector3DReadOnly)Axis3D.X);
        this.addArrow(length, zAxisMaterial, arrowMaterial);
    }

    public void add(Shape3DReadOnly shape, MaterialDefinition materialDefinition) {
        if (shape instanceof Box3DReadOnly) {
            Box3DReadOnly box = (Box3DReadOnly)shape;
            this.appendTransform((RigidBodyTransformReadOnly)box.getPose());
            this.addBox(box.getSizeX(), box.getSizeY(), box.getSizeZ(), true, materialDefinition);
        } else if (shape instanceof Capsule3DReadOnly) {
            Capsule3DReadOnly capsule = (Capsule3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)capsule.getPosition());
            this.appendRotation((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)capsule.getAxis()));
            this.addCapsule(capsule.getRadius(), capsule.getLength() + 2.0 * capsule.getRadius(), materialDefinition);
        } else if (shape instanceof Cylinder3DReadOnly) {
            Cylinder3DReadOnly cylinder = (Cylinder3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)cylinder.getPosition());
            this.appendRotation((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)cylinder.getAxis()));
            this.appendTranslation(0.0, 0.0, -cylinder.getHalfLength());
            this.addCylinder(cylinder.getLength(), cylinder.getRadius(), materialDefinition);
        } else if (shape instanceof Ellipsoid3DReadOnly) {
            Ellipsoid3DReadOnly ellipsoid = (Ellipsoid3DReadOnly)shape;
            this.appendTransform((RigidBodyTransformReadOnly)ellipsoid.getPose());
            this.addEllipsoid(ellipsoid.getRadiusX(), ellipsoid.getRadiusY(), ellipsoid.getRadiusZ(), materialDefinition);
        } else if (shape instanceof PointShape3DReadOnly) {
            PointShape3DReadOnly pointShape = (PointShape3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)pointShape);
            this.addSphere(0.005, materialDefinition);
        } else if (shape instanceof Ramp3DReadOnly) {
            Ramp3DReadOnly ramp = (Ramp3DReadOnly)shape;
            this.appendTransform((RigidBodyTransformReadOnly)ramp.getPose());
            this.appendTranslation(-0.5 * ramp.getSizeX(), 0.0, 0.0);
            this.addRamp(ramp.getSizeX(), ramp.getSizeY(), ramp.getSizeZ(), materialDefinition);
        } else if (shape instanceof Sphere3DReadOnly) {
            Sphere3DReadOnly sphere = (Sphere3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)sphere.getPosition());
            this.addSphere(sphere.getRadius(), materialDefinition);
        } else if (shape instanceof Torus3DReadOnly) {
            Torus3DReadOnly torus = (Torus3DReadOnly)shape;
            this.appendTranslation((Tuple3DReadOnly)torus.getPosition());
            this.appendRotation((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)torus.getAxis()));
            this.addArcTorus(0.0, Math.PI * 2, torus.getRadius(), torus.getTubeRadius(), materialDefinition);
        } else {
            throw new UnsupportedOperationException("Unsupported shape: " + shape);
        }
    }

    public void addArrow(double length, MaterialDefinition baseMaterial, MaterialDefinition headMaterial) {
        double coneHeight = 0.1 * length;
        double cylinderHeight = length - coneHeight;
        double radius = 0.02 * length;
        double coneRadius = 2.0 * radius;
        this.addCylinder(cylinderHeight, radius, baseMaterial);
        this.appendTranslation(0.0, 0.0, cylinderHeight);
        this.addCone(coneHeight, coneRadius, headMaterial);
        this.appendTranslation(0.0, 0.0, -cylinderHeight);
    }

    public VisualDefinition addBox(double lengthX, double widthY, double heightZ) {
        return this.addBox(lengthX, widthY, heightZ, DEFAULT_MATERIAL);
    }

    public VisualDefinition addBox(double lengthX, double widthY, double heightZ, MaterialDefinition materialDefinition) {
        return this.addBox(lengthX, widthY, heightZ, true, materialDefinition);
    }

    public VisualDefinition addBox(double lengthX, double widthY, double heightZ, boolean centeredInTheCenter, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Box3DDefinition(lengthX, widthY, heightZ, centeredInTheCenter), materialDefinition);
    }

    public VisualDefinition addRamp(double lengthX, double widthY, double heightZ) {
        return this.addRamp(lengthX, widthY, heightZ, DEFAULT_MATERIAL);
    }

    public VisualDefinition addRamp(double lengthX, double widthY, double heightZ, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Ramp3DDefinition(lengthX, widthY, heightZ), materialDefinition);
    }

    public VisualDefinition addSphere(double radius) {
        return this.addSphere(radius, DEFAULT_MATERIAL);
    }

    public VisualDefinition addSphere(double radius, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Sphere3DDefinition(radius, 32), materialDefinition);
    }

    public VisualDefinition addCapsule(double radius, double height) {
        return this.addCapsule(radius, height, DEFAULT_MATERIAL);
    }

    public VisualDefinition addCapsule(double radius, double height, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Capsule3DDefinition(height, radius, 32), materialDefinition);
    }

    public VisualDefinition addEllipsoid(double xRadius, double yRadius, double zRadius) {
        return this.addEllipsoid(xRadius, yRadius, zRadius, DEFAULT_MATERIAL);
    }

    public VisualDefinition addEllipsoid(double xRadius, double yRadius, double zRadius, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Ellipsoid3DDefinition(xRadius, yRadius, zRadius, 32), materialDefinition);
    }

    public VisualDefinition addCylinder(double height, double radius) {
        return this.addCylinder(height, radius, DEFAULT_MATERIAL);
    }

    public VisualDefinition addCylinder(double height, double radius, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Cylinder3DDefinition(height, radius, false, 32), materialDefinition);
    }

    public VisualDefinition addCone(double height, double radius) {
        return this.addCone(height, radius, DEFAULT_MATERIAL);
    }

    public VisualDefinition addCone(double height, double radius, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Cone3DDefinition(height, radius, 32), materialDefinition);
    }

    public VisualDefinition addGenTruncatedCone(double height, double bx, double by, double tx, double ty) {
        return this.addGenTruncatedCone(height, bx, by, tx, ty, DEFAULT_MATERIAL);
    }

    public VisualDefinition addGenTruncatedCone(double height, double bx, double by, double tx, double ty, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new TruncatedCone3DDefinition(height, tx, ty, bx, by, 32), materialDefinition);
    }

    public VisualDefinition addHemiEllipsoid(double xRad, double yRad, double zRad) {
        return this.addHemiEllipsoid(xRad, yRad, zRad, DEFAULT_MATERIAL);
    }

    public VisualDefinition addHemiEllipsoid(double xRad, double yRad, double zRad, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new HemiEllipsoid3DDefinition(xRad, yRad, zRad, 32), materialDefinition);
    }

    public VisualDefinition addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius) {
        return this.addArcTorus(startAngle, endAngle, majorRadius, minorRadius, DEFAULT_MATERIAL);
    }

    public VisualDefinition addArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new ArcTorus3DDefinition(startAngle, endAngle, majorRadius, minorRadius, 32), materialDefinition);
    }

    public VisualDefinition addPyramidCube(double lx, double ly, double lz, double lh) {
        return this.addPyramidCube(lx, ly, lz, lh, DEFAULT_MATERIAL);
    }

    public VisualDefinition addPyramidCube(double lx, double ly, double lz, double lh, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new PyramidBox3DDefinition(lx, ly, lz, lh), materialDefinition);
    }

    public VisualDefinition addPolygon(List<? extends Point3DReadOnly> polygonPoints) {
        return this.addPolygon(polygonPoints, DEFAULT_MATERIAL);
    }

    public VisualDefinition addPolygon(List<? extends Point3DReadOnly> polygonPoints, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Polygon3DDefinition(Polygon3DDefinition.toPoint3DDefinitionList(polygonPoints), true), materialDefinition);
    }

    public VisualDefinition addPolygon(ConvexPolygon2DReadOnly convexPolygon2d, MaterialDefinition materialDefinition) {
        ArrayList<Point3D> polygonPoints = new ArrayList<Point3D>();
        int numPoints = convexPolygon2d.getNumberOfVertices();
        for (int i = 0; i < numPoints; ++i) {
            Point2DReadOnly planarPoint = convexPolygon2d.getVertex(i);
            polygonPoints.add(new Point3D(planarPoint.getX(), planarPoint.getY(), 0.0));
        }
        return this.addPolygon(polygonPoints, materialDefinition);
    }

    public VisualDefinition addPolygon(ConvexPolygon2DReadOnly convexPolygon2d) {
        return this.addPolygon(convexPolygon2d, DEFAULT_MATERIAL);
    }

    public void addPolygons(RigidBodyTransformReadOnly transform, List<? extends ConvexPolygon2DReadOnly> convexPolygon2D) {
        this.addPolygons(transform, convexPolygon2D, DEFAULT_MATERIAL);
    }

    public void addPolygons(RigidBodyTransformReadOnly transform, List<? extends ConvexPolygon2DReadOnly> convexPolygon2D, MaterialDefinition materialDefinition) {
        this.appendTransform(transform);
        for (int i = 0; i < convexPolygon2D.size(); ++i) {
            ConvexPolygon2DReadOnly convexPolygon = convexPolygon2D.get(i);
            this.addGeometryDefinition(new Polygon2DDefinition(Polygon2DDefinition.toPoint2DDefinitionList(convexPolygon.getPolygonVerticesView()), !convexPolygon.isClockwiseOrdered()), materialDefinition);
        }
        RigidBodyTransform transformLocal = new RigidBodyTransform(transform);
        transformLocal.invert();
        this.appendTransform((RigidBodyTransformReadOnly)transformLocal);
    }

    public VisualDefinition addPolygon(Point3DReadOnly[] polygonPoint) {
        return this.addPolygon(polygonPoint, DEFAULT_MATERIAL);
    }

    public VisualDefinition addPolygon(Point3DReadOnly[] polygonPoints, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new Polygon3DDefinition(Polygon3DDefinition.toPoint3DDefinitionList((Tuple3DReadOnly[])polygonPoints), true), materialDefinition);
    }

    public VisualDefinition addPolygon(MaterialDefinition materialDefinition, Point3DReadOnly ... polygonPoints) {
        return this.addPolygon(polygonPoints, materialDefinition);
    }

    public VisualDefinition addExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon2d, double height) {
        return this.addExtrudedPolygon(convexPolygon2d, height, DEFAULT_MATERIAL);
    }

    public VisualDefinition addExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon2d, double height, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new ExtrudedPolygon2DDefinition(ExtrudedPolygon2DDefinition.toPoint2DDefinitionList(convexPolygon2d.getPolygonVerticesView()), true, height), materialDefinition);
    }

    public VisualDefinition addExtrudedPolygon(List<? extends Point2DReadOnly> polygonPoints, double height) {
        return this.addExtrudedPolygon(polygonPoints, height, DEFAULT_MATERIAL);
    }

    public VisualDefinition addExtrudedPolygon(List<? extends Point2DReadOnly> polygonPoints, double height, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new ExtrudedPolygon2DDefinition(ExtrudedPolygon2DDefinition.toPoint2DDefinitionList(polygonPoints), true, height), materialDefinition);
    }

    public VisualDefinition addExtrusion(BufferedImage bufferedImageToExtrude, double thickness, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new ExtrusionDefinition(bufferedImageToExtrude, thickness), materialDefinition);
    }

    public VisualDefinition addText(String text, double thickness, MaterialDefinition materialDefinition) {
        return this.addGeometryDefinition(new ExtrusionDefinition(text, thickness), materialDefinition);
    }
}

