/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import java.util.Objects;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class KinematicPointDefinition
implements Transformable {
    private String name;
    private final RigidBodyTransform transformToParent = new RigidBodyTransform();

    public KinematicPointDefinition() {
    }

    public KinematicPointDefinition(String name, Tuple3DReadOnly offsetFromJoint) {
        this.name = name;
        this.transformToParent.getTranslation().set(offsetFromJoint);
    }

    public KinematicPointDefinition(String name, RigidBodyTransformReadOnly transformToParent) {
        this.name = name;
        this.transformToParent.set(transformToParent);
    }

    public KinematicPointDefinition(KinematicPointDefinition other) {
        this.name = other.name;
        this.transformToParent.set(other.transformToParent);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RigidBodyTransform getTransformToParent() {
        return this.transformToParent;
    }

    public void setTransformToParent(RigidBodyTransformReadOnly transformToParent) {
        this.transformToParent.set(transformToParent);
    }

    public KinematicPointDefinition copy() {
        return new KinematicPointDefinition(this);
    }

    public void applyTransform(Transform transform) {
        transform.transform((RigidBodyTransformBasics)this.transformToParent);
    }

    public void applyInverseTransform(Transform transform) {
        transform.inverseTransform((RigidBodyTransformBasics)this.transformToParent);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.name;
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.name);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.transformToParent);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KinematicPointDefinition other = (KinematicPointDefinition)object;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.transformToParent, other.transformToParent);
    }
}

