/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

@XmlType(propOrder={"x", "y", "z", "yaw", "pitch", "roll"})
public class YawPitchRollTransformDefinition
implements RigidBodyTransformBasics {
    private final Vector3D translation = new Vector3D();
    private final YawPitchRoll orientation = new YawPitchRoll();

    public YawPitchRollTransformDefinition() {
    }

    public YawPitchRollTransformDefinition(double x, double y, double z) {
        this.setTranslation(x, y, z);
    }

    public YawPitchRollTransformDefinition(double x, double y, double z, double yaw, double pitch, double roll) {
        this.setTranslation(x, y, z);
        this.setOrientation(yaw, pitch, roll);
    }

    public YawPitchRollTransformDefinition(Tuple3DReadOnly translation) {
        this.setTranslation(translation);
    }

    public YawPitchRollTransformDefinition(Orientation3DReadOnly orientation) {
        this.setTranslation((Tuple3DReadOnly)this.translation);
        this.setOrientation(orientation);
    }

    public YawPitchRollTransformDefinition(Tuple3DReadOnly translation, Orientation3DReadOnly orientation) {
        this.setTranslation(translation);
        this.setOrientation(orientation);
    }

    public YawPitchRollTransformDefinition(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.set(rigidBodyTransform);
    }

    public void setTranslation(double x, double y, double z) {
        this.translation.set(x, y, z);
    }

    public void setTranslation(Tuple3DReadOnly translation) {
        this.translation.set(translation);
    }

    public void setOrientation(double yaw, double pitch, double roll) {
        this.orientation.set(yaw, pitch, roll);
    }

    public void setOrientation(Orientation3DReadOnly orientation) {
        this.orientation.set(orientation);
    }

    @XmlAttribute
    public void setX(double x) {
        this.translation.setX(x);
    }

    @XmlAttribute
    public void setY(double y) {
        this.translation.setY(y);
    }

    @XmlAttribute
    public void setZ(double z) {
        this.translation.setZ(z);
    }

    @XmlAttribute
    public void setYaw(double yaw) {
        this.orientation.setYaw(yaw);
    }

    @XmlAttribute
    public void setPitch(double pitch) {
        this.orientation.setPitch(pitch);
    }

    @XmlAttribute
    public void setRoll(double roll) {
        this.orientation.setRoll(roll);
    }

    public double getX() {
        return this.translation.getX();
    }

    public double getY() {
        return this.translation.getY();
    }

    public double getZ() {
        return this.translation.getZ();
    }

    public double getYaw() {
        return this.orientation.getYaw();
    }

    public double getPitch() {
        return this.orientation.getPitch();
    }

    public double getRoll() {
        return this.orientation.getRoll();
    }

    public Vector3D getTranslation() {
        return this.translation;
    }

    public Orientation3DBasics getRotation() {
        return this.orientation;
    }

    public String toString() {
        return "[(x,y,z)=" + this.translation + ", (y,p,r)=" + EuclidCoreIOTools.getStringOf((String)"(", (String)")]", (String)", ", (double[])new double[]{this.orientation.getYaw(), this.orientation.getPitch(), this.orientation.getRoll()});
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.translation);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.orientation);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        YawPitchRollTransformDefinition other = (YawPitchRollTransformDefinition)object;
        if (!Objects.equals(this.translation, other.translation)) {
            return false;
        }
        return Objects.equals(this.orientation, other.orientation);
    }
}

