/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.visual;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.scs2.definition.visual.ColorDefinitions;

@XmlRootElement(name="Color")
public class ColorDefinition {
    private double red;
    private double green;
    private double blue;
    private double alpha;
    private static final double BRIGHTNESS_SCALE = 0.7;
    private static final double SATURATION_SCALE = 0.7;

    public ColorDefinition() {
        this(0.0, 0.0, 0.0, 1.0);
    }

    public ColorDefinition(ColorDefinition other) {
        this(other.red, other.green, other.blue, other.alpha);
    }

    public ColorDefinition(int red, int green, int blue) {
        this(red, green, blue, 1.0);
    }

    public ColorDefinition(int red, int green, int blue, double alpha) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setAlpha(alpha);
    }

    public ColorDefinition(int red, int green, int blue, int alpha) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setAlpha(alpha);
    }

    public ColorDefinition(double red, double green, double blue) {
        this(red, green, blue, 1.0);
    }

    public ColorDefinition(double red, double green, double blue, double alpha) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setAlpha(alpha);
    }

    public void setRed(int red) {
        this.setRed((double)red / 255.0);
    }

    @XmlAttribute
    public void setRed(double red) {
        this.red = red < 0.0 ? 0.0 : (red > 1.0 ? 1.0 : red);
    }

    public void setGreen(int green) {
        this.setGreen((double)green / 255.0);
    }

    @XmlAttribute
    public void setGreen(double green) {
        this.green = green < 0.0 ? 0.0 : (green > 1.0 ? 1.0 : green);
    }

    public void setBlue(int blue) {
        this.setBlue((double)blue / 255.0);
    }

    @XmlAttribute
    public void setBlue(double blue) {
        this.blue = blue < 0.0 ? 0.0 : (blue > 1.0 ? 1.0 : blue);
    }

    public void setAlpha(int alpha) {
        this.setAlpha((double)alpha / 255.0);
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha < 0.0 ? 0.0 : (alpha > 1.0 ? 1.0 : alpha);
    }

    public double getRed() {
        return this.red;
    }

    public int getRedAsInteger() {
        return (int)(this.red * 255.0);
    }

    public double getGreen() {
        return this.green;
    }

    public int getGreenAsInteger() {
        return (int)(this.green * 255.0);
    }

    public double getBlue() {
        return this.blue;
    }

    public int getBlueAsInteger() {
        return (int)(this.blue * 255.0);
    }

    public boolean isOpaque() {
        return this.alpha == 1.0;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public int getAlphaAsInteger() {
        return (int)(this.alpha * 255.0);
    }

    public double getHue() {
        double brightness = this.getBrightness();
        double c = brightness - EuclidCoreTools.min((double)this.red, (double)this.green, (double)this.blue);
        double hue = 0.0;
        if (c == 0.0) {
            hue = 0.0;
        } else if (brightness == this.red) {
            hue = 60.0 * (this.green - this.blue) / c;
        } else if (brightness == this.green) {
            hue = 60.0 * (2.0 + (this.blue - this.red) / c);
        } else if (brightness == this.blue) {
            hue = 60.0 * (4.0 + (this.red - this.green) / c);
        }
        if (hue < 0.0) {
            hue += 360.0;
        }
        return hue %= 360.0;
    }

    public double getSaturation() {
        double brightness = this.getBrightness();
        if (brightness == 0.0) {
            return 0.0;
        }
        return 1.0 - EuclidCoreTools.min((double)this.red, (double)this.green, (double)this.blue) / brightness;
    }

    public double getBrightness() {
        return EuclidCoreTools.max((double)this.red, (double)this.green, (double)this.blue);
    }

    public ColorDefinition invert() {
        return new ColorDefinition(1.0 - this.red, 1.0 - this.green, 1.0 - this.blue, this.alpha);
    }

    public ColorDefinition brighter() {
        return this.derive(0.0, 1.0, 1.4285714285714286, 1.0);
    }

    public ColorDefinition darker() {
        return this.derive(0.0, 1.0, 0.7, 1.0);
    }

    public ColorDefinition saturate() {
        return this.derive(0.0, 1.4285714285714286, 1.0, 1.0);
    }

    public ColorDefinition desaturate() {
        return this.derive(0.0, 0.7, 1.0, 1.0);
    }

    public ColorDefinition derive(double hueOffset, double saturationScale, double brightnessScale, double opacityScale) {
        double outputHue = this.getHue() + hueOffset;
        double outputSaturation = this.getSaturation();
        if (saturationScale > 1.0 && outputSaturation <= 1.0E-6) {
            outputSaturation = 0.05;
        }
        outputSaturation *= saturationScale;
        double outputBrightness = this.getBrightness();
        if (brightnessScale > 1.0 && outputBrightness <= 1.0E-6) {
            outputBrightness = 0.05;
        }
        outputBrightness *= brightnessScale;
        double outputAlpha = this.getAlpha();
        if (opacityScale > 1.0 && outputAlpha <= 1.0E-6) {
            outputAlpha = 0.05;
        }
        return ColorDefinition.hsba(outputHue, outputSaturation, outputBrightness, outputAlpha *= opacityScale);
    }

    public int toRGB() {
        int argb = (this.getRedAsInteger() & 0xFF) << 16;
        argb |= (this.getGreenAsInteger() & 0xFF) << 8;
        return argb |= (this.getBlueAsInteger() & 0xFF) << 0;
    }

    public int toARGB() {
        int argb = (this.getAlphaAsInteger() & 0xFF) << 24;
        argb |= (this.getRedAsInteger() & 0xFF) << 16;
        argb |= (this.getGreenAsInteger() & 0xFF) << 8;
        return argb |= (this.getBlueAsInteger() & 0xFF) << 0;
    }

    public int toRGBA() {
        int argb = (this.getRedAsInteger() & 0xFF) << 24;
        argb |= (this.getGreenAsInteger() & 0xFF) << 16;
        argb |= (this.getBlueAsInteger() & 0xFF) << 8;
        return argb |= (this.getAlphaAsInteger() & 0xFF) << 0;
    }

    public double[] toRGBDoubleArray() {
        return new double[]{this.getRed(), this.getGreen(), this.getBlue()};
    }

    public int[] toRGBIntArray() {
        return new int[]{this.getRedAsInteger(), this.getGreenAsInteger(), this.getBlueAsInteger()};
    }

    public double[] toRGBADoubleArray() {
        return new double[]{this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha()};
    }

    public int[] toRGBAIntArray() {
        return new int[]{this.getRedAsInteger(), this.getGreenAsInteger(), this.getBlueAsInteger(), this.getAlphaAsInteger()};
    }

    public double[] toHSBDoubleArray() {
        return new double[]{this.getHue(), this.getSaturation(), this.getBrightness()};
    }

    public double[] toHSBADoubleArray() {
        return new double[]{this.getHue(), this.getSaturation(), this.getBrightness(), this.getAlpha()};
    }

    public double[] toHSLDoubleArray() {
        return Arrays.copyOf(this.toHSLADoubleArray(), 3);
    }

    public double[] toHSLADoubleArray() {
        double xmax = EuclidCoreTools.max((double)this.red, (double)this.green, (double)this.blue);
        double xmin = EuclidCoreTools.min((double)this.red, (double)this.green, (double)this.blue);
        double c = xmax - xmin;
        double lightness = 0.5 * (xmax + xmin);
        double hue = 0.0;
        if (c == 0.0) {
            hue = 0.0;
        } else if (xmax == this.red) {
            hue = 60.0 * (this.green - this.blue) / c;
        } else if (xmax == this.green) {
            hue = 60.0 * (2.0 + (this.blue - this.red) / c);
        } else if (xmax == this.blue) {
            hue = 60.0 * (4.0 + (this.red - this.green) / c);
        }
        if (hue < 0.0) {
            hue += 360.0;
        }
        hue %= 360.0;
        double saturation = 0.0;
        if (lightness > 0.0 && lightness < 1.0) {
            saturation = (xmax - lightness) / Math.min(lightness, 1.0 - lightness);
        }
        return new double[]{hue, saturation, lightness, this.alpha};
    }

    public ColorDefinition copy() {
        return new ColorDefinition(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ColorDefinition) {
            ColorDefinition other = (ColorDefinition)object;
            return this.red == other.red && this.green == other.green && this.blue == other.blue && this.alpha == other.alpha;
        }
        return false;
    }

    public int hashCode() {
        return this.toARGB();
    }

    public String toString() {
        if (this.alpha == 1.0) {
            return String.format("RGB(%d, %d, %d)", this.getRedAsInteger(), this.getGreenAsInteger(), this.getBlueAsInteger());
        }
        return String.format("RGBA(%d, %d, %d, %d)", this.getRedAsInteger(), this.getGreenAsInteger(), this.getBlueAsInteger(), this.getAlphaAsInteger());
    }

    public static ColorDefinition rgb(int rgb) {
        return ColorDefinitions.rgb(rgb);
    }

    public static ColorDefinition argb(int argb) {
        return ColorDefinitions.argb(argb);
    }

    public static ColorDefinition rgba(int rgba) {
        return ColorDefinitions.rgba(rgba);
    }

    public static ColorDefinition rgb(int[] rgb) {
        return ColorDefinitions.rgb(rgb);
    }

    public static ColorDefinition rgb(double[] rgb) {
        return ColorDefinitions.rgb(rgb);
    }

    public static ColorDefinition rgba(int[] rgba) {
        return ColorDefinitions.rgba(rgba);
    }

    public static ColorDefinition rgba(double[] rgba) {
        return ColorDefinitions.rgba(rgba);
    }

    public static ColorDefinition hsb(double[] hsb) {
        return ColorDefinitions.hsb(hsb);
    }

    public static ColorDefinition hsb(double hue, double saturation, double brightness) {
        return ColorDefinitions.hsb(hue, saturation, brightness);
    }

    public static ColorDefinition hsba(double[] hsba) {
        return ColorDefinitions.hsba(hsba);
    }

    public static ColorDefinition hsba(double hue, double saturation, double brightness, double alpha) {
        return ColorDefinitions.hsba(hue, saturation, brightness, alpha);
    }

    public static ColorDefinition hsl(double[] hsl) {
        return ColorDefinitions.hsl(hsl);
    }

    public static ColorDefinition hsl(double hue, double saturation, double lightness) {
        return ColorDefinitions.hsl(hue, saturation, lightness);
    }

    public static ColorDefinition hsla(double[] hsla) {
        return ColorDefinitions.hsla(hsla);
    }

    public static ColorDefinition hsla(double hue, double saturation, double lightness, double alpha) {
        return ColorDefinitions.hsla(hue, saturation, lightness, alpha);
    }

    public static ColorDefinition parse(String webColor) {
        return ColorDefinitions.parse(webColor);
    }
}

