/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;

public class JointState
extends JointStateBase
implements JointStateBasics {
    private final DMatrixRMaj configuration;
    private final DMatrixRMaj velocity;
    private final DMatrixRMaj acceleration;
    private final DMatrixRMaj effort;
    private final int configurationSize;
    private final int degreesOfFreedom;

    public JointState(int configurationSize, int degreesOfFreedom) {
        this.configurationSize = configurationSize;
        this.degreesOfFreedom = degreesOfFreedom;
        this.configuration = this.createNonReshapableMatrix(configurationSize);
        this.velocity = this.createNonReshapableMatrix(degreesOfFreedom);
        this.acceleration = this.createNonReshapableMatrix(degreesOfFreedom);
        this.effort = this.createNonReshapableMatrix(degreesOfFreedom);
        this.clear();
    }

    public JointState(JointState other) {
        this(other.configurationSize, other.degreesOfFreedom);
        this.set(other);
    }

    private DMatrixRMaj createNonReshapableMatrix(int numRows) {
        return new DMatrixRMaj(numRows, 1){
            private static final long serialVersionUID = 1921050577949310146L;

            public void reshape(int numRows, int numCols, boolean saveValues) {
                if (numRows != this.getNumRows()) {
                    throw new IllegalStateException("Cannot reshape joint state matrices.");
                }
            }
        };
    }

    public JointState(JointStateReadOnly other) {
        this(other.getConfigurationSize(), other.getDegreesOfFreedom());
        this.set(other);
    }

    @Override
    public void clear() {
        CommonOps_DDRM.fill((DMatrixD1)this.configuration, (double)Double.NaN);
        CommonOps_DDRM.fill((DMatrixD1)this.velocity, (double)Double.NaN);
        CommonOps_DDRM.fill((DMatrixD1)this.acceleration, (double)Double.NaN);
        CommonOps_DDRM.fill((DMatrixD1)this.effort, (double)Double.NaN);
    }

    @Override
    public void set(JointStateReadOnly other) {
        if (other.getConfigurationSize() != this.configurationSize || other.getDegreesOfFreedom() != this.degreesOfFreedom) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        if (other.hasOutputFor(JointStateType.CONFIGURATION)) {
            other.getConfiguration(0, (DMatrix)this.configuration);
        } else {
            CommonOps_DDRM.fill((DMatrixD1)this.configuration, (double)Double.NaN);
        }
        if (other.hasOutputFor(JointStateType.VELOCITY)) {
            other.getVelocity(0, (DMatrix)this.velocity);
        } else {
            CommonOps_DDRM.fill((DMatrixD1)this.velocity, (double)Double.NaN);
        }
        if (other.hasOutputFor(JointStateType.ACCELERATION)) {
            other.getAcceleration(0, (DMatrix)this.acceleration);
        } else {
            CommonOps_DDRM.fill((DMatrixD1)this.acceleration, (double)Double.NaN);
        }
        if (other.hasOutputFor(JointStateType.EFFORT)) {
            other.getEffort(0, (DMatrix)this.effort);
        } else {
            CommonOps_DDRM.fill((DMatrixD1)this.effort, (double)Double.NaN);
        }
    }

    @Override
    public int getConfigurationSize() {
        return this.configurationSize;
    }

    @Override
    public int getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public void setConfiguration(JointReadOnly joint) {
        this.checkConfigurationSize(joint);
        joint.getJointConfiguration(0, (DMatrix)this.configuration);
    }

    @Override
    public int setConfiguration(int startRow, DMatrix configuration) {
        CommonOps_DDRM.extract((DMatrix)configuration, (int)startRow, (int)(startRow + this.getConfigurationSize()), (int)0, (int)1, (DMatrix)this.configuration);
        return startRow + this.getConfigurationSize();
    }

    @Override
    public void setVelocity(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.velocity.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointVelocity(0, (DMatrix)this.velocity);
    }

    @Override
    public int setVelocity(int startRow, DMatrix velocity) {
        CommonOps_DDRM.extract((DMatrix)velocity, (int)startRow, (int)(startRow + this.getDegreesOfFreedom()), (int)0, (int)1, (DMatrix)this.velocity);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public void setAcceleration(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.acceleration.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointAcceleration(0, (DMatrix)this.acceleration);
    }

    @Override
    public int setAcceleration(int startRow, DMatrix acceleration) {
        CommonOps_DDRM.extract((DMatrix)acceleration, (int)startRow, (int)(startRow + this.getDegreesOfFreedom()), (int)0, (int)1, (DMatrix)this.acceleration);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public void setEffort(JointReadOnly joint) {
        this.checkDegreesOfFreedom(joint);
        this.effort.reshape(joint.getDegreesOfFreedom(), 1);
        joint.getJointTau(0, (DMatrix)this.effort);
    }

    @Override
    public int setEffort(int startRow, DMatrix effort) {
        CommonOps_DDRM.extract((DMatrix)effort, (int)startRow, (int)(startRow + this.getDegreesOfFreedom()), (int)0, (int)1, (DMatrix)this.effort);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        switch (query) {
            case CONFIGURATION: {
                return !MatrixFeatures_DDRM.hasNaN((DMatrixD1)this.configuration);
            }
            case VELOCITY: {
                return !MatrixFeatures_DDRM.hasNaN((DMatrixD1)this.velocity);
            }
            case ACCELERATION: {
                return !MatrixFeatures_DDRM.hasNaN((DMatrixD1)this.acceleration);
            }
            case EFFORT: {
                return !MatrixFeatures_DDRM.hasNaN((DMatrixD1)this.effort);
            }
        }
        throw new IllegalStateException("Should not get here.");
    }

    @Override
    public int getConfiguration(int startRow, DMatrix configurationToPack) {
        CommonOps_DDRM.insert((DMatrix)this.configuration, (DMatrix)configurationToPack, (int)startRow, (int)0);
        return startRow + this.configuration.getNumRows();
    }

    @Override
    public int getVelocity(int startRow, DMatrix velocityToPack) {
        CommonOps_DDRM.insert((DMatrix)this.velocity, (DMatrix)velocityToPack, (int)startRow, (int)0);
        return startRow + this.velocity.getNumRows();
    }

    @Override
    public int getAcceleration(int startRow, DMatrix accelerationToPack) {
        CommonOps_DDRM.insert((DMatrix)this.acceleration, (DMatrix)accelerationToPack, (int)startRow, (int)0);
        return startRow + this.acceleration.getNumRows();
    }

    @Override
    public int getEffort(int startRow, DMatrix effortToPack) {
        CommonOps_DDRM.insert((DMatrix)this.effort, (DMatrix)effortToPack, (int)startRow, (int)0);
        return startRow + this.effort.getNumRows();
    }

    @Override
    public void getConfiguration(JointBasics jointToUpdate) {
        jointToUpdate.setJointConfiguration(0, (DMatrix)this.configuration);
    }

    @Override
    public void getVelocity(JointBasics jointToUpdate) {
        jointToUpdate.setJointVelocity(0, (DMatrix)this.velocity);
    }

    @Override
    public void getAcceleration(JointBasics jointToUpdate) {
        jointToUpdate.setJointAcceleration(0, (DMatrix)this.acceleration);
    }

    @Override
    public void getEffort(JointBasics jointToUpdate) {
        jointToUpdate.setJointTau(0, (DMatrix)this.effort);
    }

    public DMatrixRMaj getConfiguration() {
        return this.configuration;
    }

    public DMatrixRMaj getVelocity() {
        return this.velocity;
    }

    public DMatrixRMaj getAcceleration() {
        return this.acceleration;
    }

    public DMatrixRMaj getEffort() {
        return this.effort;
    }

    @Override
    public JointState copy() {
        return new JointState(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double[])this.configuration.getData());
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double[])this.velocity.getData());
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double[])this.acceleration.getData());
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double[])this.effort.getData());
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.configurationSize);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (int)this.degreesOfFreedom);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JointState other = (JointState)object;
        if (MatrixFeatures_DDRM.hasNaN((DMatrixD1)this.configuration) ? !MatrixFeatures_DDRM.hasNaN((DMatrixD1)other.configuration) : !MatrixFeatures_DDRM.isEquals((DMatrixD1)this.configuration, (DMatrixD1)other.configuration)) {
            return false;
        }
        if (MatrixFeatures_DDRM.hasNaN((DMatrixD1)this.velocity) ? !MatrixFeatures_DDRM.hasNaN((DMatrixD1)other.velocity) : !MatrixFeatures_DDRM.isEquals((DMatrixD1)this.velocity, (DMatrixD1)other.velocity)) {
            return false;
        }
        if (MatrixFeatures_DDRM.hasNaN((DMatrixD1)this.acceleration) ? !MatrixFeatures_DDRM.hasNaN((DMatrixD1)other.acceleration) : !MatrixFeatures_DDRM.isEquals((DMatrixD1)this.acceleration, (DMatrixD1)other.acceleration)) {
            return false;
        }
        if (MatrixFeatures_DDRM.hasNaN((DMatrixD1)this.effort) ? !MatrixFeatures_DDRM.hasNaN((DMatrixD1)other.effort) : !MatrixFeatures_DDRM.isEquals((DMatrixD1)this.effort, (DMatrixD1)other.effort)) {
            return false;
        }
        if (this.configurationSize != other.configurationSize) {
            return false;
        }
        return this.degreesOfFreedom == other.degreesOfFreedom;
    }

    public String toString() {
        String ret = this.degreesOfFreedom + "-DoF joint state";
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = ret + ", configuration: " + Arrays.toString(this.configuration.getData());
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = ret + ", velocity: " + Arrays.toString(this.velocity.getData());
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = ret + ", acceleration: " + Arrays.toString(this.acceleration.getData());
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = ret + ", effort: " + Arrays.toString(this.effort.getData());
        }
        return ret;
    }
}

