/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.robot;

import javax.xml.bind.annotation.XmlElement;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.robot.SensorDefinition;

public class IMUSensorDefinition
extends SensorDefinition {
    private double accelerationNoiseMean;
    private double accelerationNoiseStandardDeviation;
    private double accelerationBiasMean;
    private double accelerationBiasStandardDeviation;
    private double angularVelocityNoiseMean;
    private double angularVelocityNoiseStandardDeviation;
    private double angularVelocityBiasMean;
    private double angularVelocityBiasStandardDeviation;

    public IMUSensorDefinition() {
    }

    public IMUSensorDefinition(String name, RigidBodyTransformReadOnly imuTransform) {
        super(name, imuTransform);
    }

    public IMUSensorDefinition(IMUSensorDefinition other) {
        super(other);
        this.accelerationNoiseMean = other.accelerationNoiseMean;
        this.accelerationNoiseStandardDeviation = other.accelerationNoiseStandardDeviation;
        this.accelerationBiasMean = other.accelerationBiasMean;
        this.accelerationBiasStandardDeviation = other.accelerationBiasStandardDeviation;
        this.angularVelocityNoiseMean = other.angularVelocityNoiseMean;
        this.angularVelocityNoiseStandardDeviation = other.angularVelocityNoiseStandardDeviation;
        this.angularVelocityBiasMean = other.angularVelocityBiasMean;
        this.angularVelocityBiasStandardDeviation = other.angularVelocityBiasStandardDeviation;
    }

    public void setAccelerationNoiseParameters(double noiseMean, double noiseStandardDeviation) {
        this.setAccelerationNoiseMean(noiseMean);
        this.setAccelerationNoiseStandardDeviation(noiseStandardDeviation);
    }

    public void setAccelerationBiasParameters(double biasMean, double biasStandardDeviation) {
        this.setAccelerationBiasMean(biasMean);
        this.setAccelerationBiasStandardDeviation(biasStandardDeviation);
    }

    public void setAngularVelocityNoiseParameters(double noiseMean, double noiseStandardDeviation) {
        this.setAngularVelocityNoiseMean(noiseMean);
        this.setAngularVelocityNoiseStandardDeviation(noiseStandardDeviation);
    }

    public void setAngularVelocityBiasParameters(double biasMean, double biasStandardDeviation) {
        this.setAngularVelocityNoiseMean(biasMean);
        this.setAngularVelocityNoiseStandardDeviation(biasStandardDeviation);
    }

    public double getAccelerationNoiseMean() {
        return this.accelerationNoiseMean;
    }

    @XmlElement
    public void setAccelerationNoiseMean(double accelerationNoiseMean) {
        this.accelerationNoiseMean = accelerationNoiseMean;
    }

    public double getAccelerationNoiseStandardDeviation() {
        return this.accelerationNoiseStandardDeviation;
    }

    @XmlElement
    public void setAccelerationNoiseStandardDeviation(double accelerationNoiseStandardDeviation) {
        this.accelerationNoiseStandardDeviation = accelerationNoiseStandardDeviation;
    }

    public double getAccelerationBiasMean() {
        return this.accelerationBiasMean;
    }

    @XmlElement
    public void setAccelerationBiasMean(double accelerationBiasMean) {
        this.accelerationBiasMean = accelerationBiasMean;
    }

    public double getAccelerationBiasStandardDeviation() {
        return this.accelerationBiasStandardDeviation;
    }

    @XmlElement
    public void setAccelerationBiasStandardDeviation(double accelerationBiasStandardDeviation) {
        this.accelerationBiasStandardDeviation = accelerationBiasStandardDeviation;
    }

    public double getAngularVelocityNoiseMean() {
        return this.angularVelocityNoiseMean;
    }

    @XmlElement
    public void setAngularVelocityNoiseMean(double angularVelocityNoiseMean) {
        this.angularVelocityNoiseMean = angularVelocityNoiseMean;
    }

    public double getAngularVelocityNoiseStandardDeviation() {
        return this.angularVelocityNoiseStandardDeviation;
    }

    @XmlElement
    public void setAngularVelocityNoiseStandardDeviation(double angularVelocityNoiseStandardDeviation) {
        this.angularVelocityNoiseStandardDeviation = angularVelocityNoiseStandardDeviation;
    }

    public double getAngularVelocityBiasMean() {
        return this.angularVelocityBiasMean;
    }

    @XmlElement
    public void setAngularVelocityBiasMean(double angularVelocityBiasMean) {
        this.angularVelocityBiasMean = angularVelocityBiasMean;
    }

    public double getAngularVelocityBiasStandardDeviation() {
        return this.angularVelocityBiasStandardDeviation;
    }

    @XmlElement
    public void setAngularVelocityBiasStandardDeviation(double angularVelocityBiasStandardDeviation) {
        this.angularVelocityBiasStandardDeviation = angularVelocityBiasStandardDeviation;
    }

    @Override
    public IMUSensorDefinition copy() {
        return new IMUSensorDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.accelerationNoiseMean);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.accelerationNoiseStandardDeviation);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.accelerationBiasMean);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.accelerationBiasStandardDeviation);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.angularVelocityNoiseMean);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.angularVelocityNoiseStandardDeviation);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.angularVelocityBiasMean);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.angularVelocityBiasStandardDeviation);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        IMUSensorDefinition other = (IMUSensorDefinition)object;
        if (Double.doubleToLongBits(this.accelerationNoiseMean) != Double.doubleToLongBits(other.accelerationNoiseMean)) {
            return false;
        }
        if (Double.doubleToLongBits(this.accelerationNoiseStandardDeviation) != Double.doubleToLongBits(other.accelerationNoiseStandardDeviation)) {
            return false;
        }
        if (Double.doubleToLongBits(this.accelerationBiasMean) != Double.doubleToLongBits(other.accelerationBiasMean)) {
            return false;
        }
        if (Double.doubleToLongBits(this.accelerationBiasStandardDeviation) != Double.doubleToLongBits(other.accelerationBiasStandardDeviation)) {
            return false;
        }
        if (Double.doubleToLongBits(this.angularVelocityNoiseMean) != Double.doubleToLongBits(other.angularVelocityNoiseMean)) {
            return false;
        }
        if (Double.doubleToLongBits(this.angularVelocityNoiseStandardDeviation) != Double.doubleToLongBits(other.angularVelocityNoiseStandardDeviation)) {
            return false;
        }
        if (Double.doubleToLongBits(this.angularVelocityBiasMean) != Double.doubleToLongBits(other.angularVelocityBiasMean)) {
            return false;
        }
        return Double.doubleToLongBits(this.angularVelocityBiasStandardDeviation) == Double.doubleToLongBits(other.angularVelocityBiasStandardDeviation);
    }
}

