/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.geometry;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Objects;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;

public class ExtrusionDefinition
extends GeometryDefinition {
    private BufferedImage image;
    private double thickness;

    public ExtrusionDefinition(String text, double thickness) {
        this(ExtrusionDefinition.textToImage(text), thickness);
    }

    public ExtrusionDefinition(BufferedImage image, double thickness) {
        this.image = image;
        this.thickness = thickness;
    }

    public ExtrusionDefinition(ExtrusionDefinition other) {
        this.setName(other.getName());
        this.image = ExtrusionDefinition.copyImage(other.image);
        this.thickness = other.thickness;
    }

    public static BufferedImage textToImage(String text) {
        return ExtrusionDefinition.textToImage(text, new Font("Lucida Sans", 0, 40));
    }

    public static BufferedImage textToImage(String text, Font font) {
        BufferedImage measurementImage = new BufferedImage(1, 1, 5);
        Graphics2D measurementGraphics = measurementImage.createGraphics();
        FontRenderContext fontRenderContext = measurementGraphics.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(text, fontRenderContext);
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 5);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(Color.black);
        graphics.setFont(font);
        graphics.drawString(text, 0, (int)((double)height + bounds.getCenterY()));
        graphics.dispose();
        return bufferedImage;
    }

    public static BufferedImage copyImage(BufferedImage original) {
        if (original == null) {
            return null;
        }
        ColorModel colorModel = original.getColorModel();
        boolean isAlphaPremultiplied = colorModel.isAlphaPremultiplied();
        WritableRaster raster = original.copyData(null);
        return new BufferedImage(colorModel, raster, isAlphaPremultiplied, null);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public double getThickness() {
        return this.thickness;
    }

    @Override
    public ExtrusionDefinition copy() {
        return new ExtrusionDefinition(this);
    }

    @Override
    public int hashCode() {
        long bits = super.hashCode();
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.image);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (double)this.thickness);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ExtrusionDefinition other = (ExtrusionDefinition)object;
        if (!Objects.equals(this.image, other.image)) {
            return false;
        }
        return Double.doubleToLongBits(this.thickness) == Double.doubleToLongBits(other.thickness);
    }
}

