/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.definition.state;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.JointStateBase;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.SphericalJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.SphericalJointStateReadOnly;

public class SphericalJointState
extends JointStateBase
implements SphericalJointStateBasics {
    private final Set<JointStateType> availableStates = EnumSet.noneOf(JointStateType.class);
    private final Quaternion configuration = new Quaternion();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D angularAcceleration = new Vector3D();
    private final Vector3D torque = new Vector3D();
    private final DMatrixRMaj temp = new DMatrixRMaj(1, 1);

    public SphericalJointState() {
    }

    public SphericalJointState(JointStateReadOnly other) {
        this.set(other);
    }

    @Override
    public void clear() {
        this.availableStates.clear();
    }

    public void set(SphericalJointState other) {
        this.configuration.set(other.configuration);
        this.angularVelocity.set(other.angularVelocity);
        this.angularAcceleration.set(other.angularAcceleration);
        this.torque.set(other.torque);
        this.availableStates.addAll(other.availableStates);
    }

    @Override
    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof SphericalJointState) {
            this.set((SphericalJointState)jointStateReadOnly);
        } else if (jointStateReadOnly instanceof SphericalJointStateReadOnly) {
            SphericalJointStateBasics.super.set((SphericalJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            this.clear();
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            }
        }
    }

    @Override
    public void setConfiguration(Orientation3DReadOnly configuration) {
        this.configuration.set(configuration);
        this.availableStates.add(JointStateType.CONFIGURATION);
    }

    @Override
    public int setConfiguration(int startRow, DMatrix configuration) {
        this.configuration.set(startRow, configuration);
        this.availableStates.add(JointStateType.CONFIGURATION);
        return startRow + this.getConfigurationSize();
    }

    @Override
    public void setVelocity(Vector3DReadOnly angularVelocity) {
        this.angularVelocity.set((Tuple3DReadOnly)angularVelocity);
        this.availableStates.add(JointStateType.VELOCITY);
    }

    @Override
    public int setVelocity(int startRow, DMatrix velocity) {
        this.angularVelocity.set(startRow, velocity);
        this.availableStates.add(JointStateType.VELOCITY);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public void setAcceleration(Vector3DReadOnly angularAcceleration) {
        this.angularAcceleration.set((Tuple3DReadOnly)angularAcceleration);
        this.availableStates.add(JointStateType.ACCELERATION);
    }

    @Override
    public int setAcceleration(int startRow, DMatrix acceleration) {
        this.angularAcceleration.set(startRow, acceleration);
        this.availableStates.add(JointStateType.ACCELERATION);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public void setEffort(Vector3DReadOnly torque) {
        this.torque.set((Tuple3DReadOnly)torque);
        this.availableStates.add(JointStateType.EFFORT);
    }

    @Override
    public int setEffort(int startRow, DMatrix effort) {
        this.torque.set(startRow, effort);
        this.availableStates.add(JointStateType.EFFORT);
        return startRow + this.getDegreesOfFreedom();
    }

    @Override
    public boolean hasOutputFor(JointStateType query) {
        return this.availableStates.contains(query);
    }

    public Quaternion getConfiguration() {
        return this.configuration;
    }

    public Vector3D getVelocity() {
        return this.angularVelocity;
    }

    public Vector3D getAcceleration() {
        return this.angularAcceleration;
    }

    public Vector3D getEffort() {
        return this.torque;
    }

    @Override
    public SphericalJointState copy() {
        return new SphericalJointState(this);
    }

    public int hashCode() {
        long bits = 1L;
        bits = EuclidHashCodeTools.addToHashCode((long)bits, this.availableStates);
        if (this.availableStates.contains(JointStateType.CONFIGURATION)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.configuration);
        }
        if (this.availableStates.contains(JointStateType.VELOCITY)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.angularVelocity);
        }
        if (this.availableStates.contains(JointStateType.ACCELERATION)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.angularAcceleration);
        }
        if (this.availableStates.contains(JointStateType.EFFORT)) {
            bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.torque);
        }
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SphericalJointState other = (SphericalJointState)object;
        if (!Objects.equals(this.availableStates, other.availableStates)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.CONFIGURATION) && !Objects.equals(this.configuration, other.configuration)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.VELOCITY) && !Objects.equals(this.angularVelocity, other.angularVelocity)) {
            return false;
        }
        if (this.availableStates.contains(JointStateType.ACCELERATION) && !Objects.equals(this.angularAcceleration, other.angularAcceleration)) {
            return false;
        }
        return !this.availableStates.contains(JointStateType.EFFORT) || Objects.equals(this.torque, other.torque);
    }
}

